=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: finite_difference_european.rb,v 1.5 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

class FdEuropeanOptionTest < RUNIT::TestCase
    def name
        "Testing finite-difference European option pricer..."
    end
    def test
        under       = 100
        strikeMin   = 60
        strikeRange = 100
        rRateRange = 0.18
        qRateRange = 0.02
        volRange   = 1.2
        timeMin    = 0.5
        timeRange  = 2.0

        tolerance = 1.0e-2
        totCases = 200
        rng = QuantLib::UniformRandomGenerator.new(56789012)

        totCases.times {
            strike  = strikeMin + strikeRange * rng.next.value
            qRate   =              qRateRange * rng.next.value
            rRate   =              rRateRange * rng.next.value
            vol     =                volRange * rng.next.value
            resTime = timeMin   +   timeRange * rng.next.value

            ['Call', 'Put', 'Straddle'].each { |type|
                analytic  = QuantLib::EuropeanOption.new(
                                type, under, strike, qRate,
                                rRate, resTime, vol).value
                numerical = QuantLib::FdEuropean.new(
                                type, under, strike, qRate,
                                rRate, resTime, vol, 100, 400).value
                unless (analytic - numerical).abs <= tolerance
                    assert_fail(<<-MESSAGE

    Option details: #{type} #{under} #{strike} #{qRate} #{rRate} #{resTime} #{vol}
    Error: #{(analytic - numerical).abs}

                        MESSAGE
                    )
                end
            }
        }
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(FdEuropeanOptionTest.suite)
end
