/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.33
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<typename T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000900f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <stdexcept>


#include <string>


#include <vector>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


#include <boost/algorithm/string/case_conv.hpp>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;


using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;
using QuantLib::Biweekly;
using QuantLib::Weekly;
using QuantLib::Daily;


using QuantLib::Period;
using QuantLib::PeriodParser;

SWIGINTERN Period *new_Period__SWIG_3(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
SWIGINTERN std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
SWIGINTERN std::vector<Period >::const_reference std_vector_Sl_Period_Sg__get(std::vector<Period > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Period_Sg__set(std::vector<Period > *self,int i,std::vector<Period >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Date;
using QuantLib::DateParser;

SWIGINTERN Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
SWIGINTERN Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
SWIGINTERN std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Date___repr__(Date *self){
            std::ostringstream out;
            if (*self == Date())
                out << "Date()";
            else
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
SWIGINTERN std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
SWIGINTERN std::vector<Date >::const_reference std_vector_Sl_Date_Sg__get(std::vector<Date > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Date_Sg__set(std::vector<Date > *self,int i,std::vector<Date >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::IMM;

SWIGINTERN std::vector<int >::const_reference std_vector_Sl_int_Sg__get(std::vector<int > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_int_Sg__set(std::vector<int > *self,int i,std::vector<int >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector<double >::const_reference std_vector_Sl_double_Sg__get(std::vector<double > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_double_Sg__set(std::vector<double > *self,int i,std::vector<double >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector<std::string >::const_reference std_vector_Sl_std_string_Sg__get(std::vector<std::string > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_string_Sg__set(std::vector<std::string > *self,int i,std::vector<std::string >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector<std::pair<Date,double > >::const_reference std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__get(std::vector<std::pair<Date,double > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__set(std::vector<std::pair<Date,double > > *self,int i,std::vector<std::pair<Date,double > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Exercise;

SWIGINTERN bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

SWIGINTERN EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
SWIGINTERN AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }
SWIGINTERN BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector<Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

using QuantLib::Observer;
using QuantLib::Observable;

SWIGINTERN bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr<Observable > *self){
                return !(*self);
            }

using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::SampledCurve;

SWIGINTERN std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Array_get(Array *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("array index out of range");
        }
SWIGINTERN void Array_set(Array *self,Size i,Real x){
            if (i<self->size())
                (*self)[i] = x;
            else
                throw std::out_of_range("array index out of range");
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    DefaultLexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    DefaultLexicographicalViewColumn;

SWIGINTERN DefaultLexicographicalView *new_DefaultLexicographicalView(Array &a,Size xSize){
            return new DefaultLexicographicalView(a.begin(),a.end(),xSize);
        }
SWIGINTERN std::string DefaultLexicographicalView___str__(DefaultLexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

SWIGINTERN std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN Real Matrix_get(Matrix *self,Size i,Size j){
            return (*self)[i][j];
        }
SWIGINTERN void Matrix_set(Matrix *self,Size i,Size j,Real x){
            (*self)[i][j] = x;
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::CostFunction;
using QuantLib::Disposable;


using QuantLib::Quote;

SWIGINTERN bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_Quote_Sg__asObservable(Handle<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

SWIGINTERN SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
SWIGINTERN void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
SWIGINTERN std::vector<boost::shared_ptr<Quote > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__get(std::vector<boost::shared_ptr<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(std::vector<boost::shared_ptr<Quote > > *self,int i,std::vector<boost::shared_ptr<Quote > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector<Handle<Quote > >::const_reference std_vector_Sl_Handle_Sl_Quote_Sg__Sg__get(std::vector<Handle<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(std::vector<Handle<Quote > > *self,int i,std::vector<Handle<Quote > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector<RelinkableHandle<Quote > >::const_reference std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__get(std::vector<RelinkableHandle<Quote > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__set(std::vector<RelinkableHandle<Quote > > *self,int i,std::vector<RelinkableHandle<Quote > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

SWIGINTERN std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
SWIGINTERN bool DayCounter___eq__(DayCounter *self,DayCounter const &other){
            return (*self) == other;
        }
SWIGINTERN bool DayCounter___ne__(DayCounter *self,DayCounter const &other){
            return (*self) != other;
        }

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;


using QuantLib::InterestRate;

SWIGINTERN std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Unadjusted;
using QuantLib::ModifiedFollowing;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

SWIGINTERN std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
SWIGINTERN bool Calendar___eq__(Calendar *self,Calendar const &other){
            return (*self) == other;
        }
SWIGINTERN bool Calendar___ne__(Calendar *self,Calendar const &other){
            return (*self) != other;
        }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;

SWIGINTERN std::string Currency___str__(Currency *self){
            return self->name();
        }
SWIGINTERN bool Currency___eq__(Currency *self,Currency const &other){
            return (*self) == other;
        }
SWIGINTERN bool Currency___ne__(Currency *self,Currency const &other){
            return (*self) != other;
        }

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

SWIGINTERN Real SafeNaturalCubicSpline_derivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeNaturalCubicSpline_secondDerivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

SWIGINTERN Real SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::BackwardFlat;
using QuantLib::ForwardFlat;
using QuantLib::Linear;
using QuantLib::LogLinear;
using QuantLib::CubicSpline;


using QuantLib::YieldTermStructure;

SWIGINTERN bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

SWIGINTERN ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

SWIGINTERN ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
            return new ZeroSpreadedTermStructurePtr(
                new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }
SWIGINTERN ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
            return new ForwardSpreadedTermStructurePtr(
                new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;
using QuantLib::OptionletVolatilityStructure;
using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__isNull(boost::shared_ptr<OptionletVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__asObservable(boost::shared_ptr<OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_OptionletVolatilityStructure_Sg__asObservable(Handle<OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Calendar const &c,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, c,
		volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Calendar const &c,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, c, 
		volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Natural settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Natural settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::BlackVarianceSurface;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

SWIGINTERN BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,Calendar const &cal,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,BlackVarianceSurface::Extrapolation lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,BlackVarianceSurface::Extrapolation upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,cal,
					dates,strikes,
				blackVols,dayCounter,lower,upper));
        }

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::ConstantOptionletVol;
typedef boost::shared_ptr<OptionletVolatilityStructure>
    ConstantOptionletVolPtr;

SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(referenceDate, volatility,cal,
                                             dayCounter));
        }
SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(referenceDate, volatility,
                                    	cal, dayCounter));
        }
SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_2(Volatility volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(volatility, cal, dayCounter));
        }
SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_3(Handle<Quote > const &volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(volatility, cal, dayCounter));
        }

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

SWIGINTERN SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }

using QuantLib::StochasticProcess;

SWIGINTERN bool boost_shared_ptr_Sl_StochasticProcess_Sg__isNull(boost::shared_ptr<StochasticProcess > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_StochasticProcess_Sg__asObservable(boost::shared_ptr<StochasticProcess > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<StochasticProcess> StochasticProcess1DPtr;


using QuantLib::GeneralizedBlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> GeneralizedBlackScholesProcessPtr;

SWIGINTERN GeneralizedBlackScholesProcessPtr *new_GeneralizedBlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new GeneralizedBlackScholesProcessPtr(
                       new GeneralizedBlackScholesProcess(s0, dividendTS,
                                                          riskFreeTS, volTS));
      }

using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesProcessPtr;

SWIGINTERN BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                            new BlackScholesProcess(s0, riskFreeTS, volTS));
      }

using QuantLib::BlackScholesMertonProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesMertonProcessPtr;

SWIGINTERN BlackScholesMertonProcessPtr *new_BlackScholesMertonProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesMertonProcessPtr(
                            new BlackScholesMertonProcess(s0, dividendTS,
                                                          riskFreeTS, volTS));
      }

using QuantLib::BlackProcess;
typedef boost::shared_ptr<StochasticProcess> BlackProcessPtr;

SWIGINTERN BlackProcessPtr *new_BlackProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackProcessPtr(new BlackProcess(s0, riskFreeTS, volTS));
      }

using QuantLib::GarmanKohlagenProcess;
typedef boost::shared_ptr<StochasticProcess> GarmanKohlagenProcessPtr;

SWIGINTERN GarmanKohlagenProcessPtr *new_GarmanKohlagenProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &foreignRiskFreeTS,Handle<YieldTermStructure > const &domesticRiskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new GarmanKohlagenProcessPtr(
                        new GarmanKohlagenProcess(s0, foreignRiskFreeTS,
                                                  domesticRiskFreeTS, volTS));
      }

using QuantLib::Merton76Process;
typedef boost::shared_ptr<StochasticProcess> Merton76ProcessPtr;

SWIGINTERN Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }

using QuantLib::StochasticProcessArray;
typedef boost::shared_ptr<StochasticProcess> StochasticProcessArrayPtr;

SWIGINTERN StochasticProcessArrayPtr *new_StochasticProcessArrayPtr(std::vector<boost::shared_ptr<StochasticProcess > > const &array,Matrix const &correlation){
          std::vector<boost::shared_ptr<StochasticProcess1D> > in_array;
          for (Size j=0; j < array.size(); j++)
              in_array.push_back(
                  boost::dynamic_pointer_cast<StochasticProcess1D>(array[j]));
          return new StochasticProcessArrayPtr(
                           new StochasticProcessArray(in_array, correlation));
      }
SWIGINTERN std::vector<boost::shared_ptr<StochasticProcess > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__get(std::vector<boost::shared_ptr<StochasticProcess > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__set(std::vector<boost::shared_ptr<StochasticProcess > > *self,int i,std::vector<boost::shared_ptr<StochasticProcess > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::PricingEngine;

SWIGINTERN bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }

using QuantLib::Instrument;

SWIGINTERN bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr<Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

SWIGINTERN StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }

using QuantLib::CompositeInstrument;
typedef boost::shared_ptr<Instrument> CompositeInstrumentPtr;

SWIGINTERN CompositeInstrumentPtr *new_CompositeInstrumentPtr(){
            return new CompositeInstrumentPtr(new CompositeInstrument);
        }
SWIGINTERN void CompositeInstrumentPtr_add__SWIG_0(CompositeInstrumentPtr *self,boost::shared_ptr<Instrument > const &instrument,Real multiplier=1.0){
            boost::dynamic_pointer_cast<CompositeInstrument>(*self)
                ->add(instrument, multiplier);
        }
SWIGINTERN void CompositeInstrumentPtr_subtract__SWIG_0(CompositeInstrumentPtr *self,boost::shared_ptr<Instrument > const &instrument,Real multiplier=1.0){
            boost::dynamic_pointer_cast<CompositeInstrument>(*self)
                ->subtract(instrument, multiplier);
        }

using QuantLib::Option;
using QuantLib::Barrier;


using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

SWIGINTERN bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }

using QuantLib::VanillaOption;
using QuantLib::ForwardVanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;
typedef boost::shared_ptr<Instrument> MultiAssetOptionPtr;

SWIGINTERN VanillaOptionPtr *new_VanillaOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(new VanillaOption(stPayoff,exercise));
        }
SWIGINTERN Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
SWIGINTERN Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
SWIGINTERN Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
SWIGINTERN Real VanillaOptionPtr_thetaPerDay(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->thetaPerDay();
        }
SWIGINTERN Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
SWIGINTERN Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
SWIGINTERN Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve VanillaOptionPtr_priceCurve(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->impliedVolatility(targetValue, bsProcess, accuracy,
                                    maxEvaluations, minVol, maxVol);
        }

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

SWIGINTERN EuropeanOptionPtr *new_EuropeanOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(new EuropeanOption(stPayoff,exercise));
        }

using QuantLib::ForwardVanillaOption;
typedef boost::shared_ptr<Instrument> ForwardVanillaOptionPtr;

SWIGINTERN ForwardVanillaOptionPtr *new_ForwardVanillaOptionPtr(Real moneyness,Date resetDate,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new ForwardVanillaOptionPtr(
                                new ForwardVanillaOption(moneyness, resetDate,
                                                         stPayoff, exercise));
        }

using QuantLib::QuantoVanillaOption;
typedef boost::shared_ptr<Instrument> QuantoVanillaOptionPtr;

SWIGINTERN QuantoVanillaOptionPtr *new_QuantoVanillaOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoVanillaOptionPtr(
                                 new QuantoVanillaOption(stPayoff, exercise));
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qvega(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qvega();
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qrho(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qrho();
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qlambda(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qlambda();
        }

using QuantLib::QuantoForwardVanillaOption;
typedef boost::shared_ptr<Instrument> QuantoForwardVanillaOptionPtr;

SWIGINTERN QuantoForwardVanillaOptionPtr *new_QuantoForwardVanillaOptionPtr(Real moneyness,Date resetDate,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoForwardVanillaOptionPtr(
                          new QuantoForwardVanillaOption(moneyness, resetDate,
                                                         stPayoff, exercise));
        }

using QuantLib::MultiAssetOption;

SWIGINTERN Real MultiAssetOptionPtr_delta(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->delta();
        }
SWIGINTERN Real MultiAssetOptionPtr_gamma(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->gamma();
        }
SWIGINTERN Real MultiAssetOptionPtr_theta(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->theta();
        }
SWIGINTERN Real MultiAssetOptionPtr_vega(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)->vega();
        }
SWIGINTERN Real MultiAssetOptionPtr_rho(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)->rho();
        }
SWIGINTERN Real MultiAssetOptionPtr_dividendRho(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->dividendRho();
        }

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

SWIGINTERN AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticEuropeanEnginePtr(
                                       new AnalyticEuropeanEngine(bsProcess));
        }

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

SWIGINTERN IntegralEnginePtr *new_IntegralEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new IntegralEnginePtr(new IntegralEngine(bsProcess));
        }

using QuantLib::FDBermudanEngine;
typedef boost::shared_ptr<PricingEngine> FDBermudanEnginePtr;

SWIGINTERN FDBermudanEnginePtr *new_FDBermudanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDBermudanEnginePtr(
                              new FDBermudanEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

SWIGINTERN FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDEuropeanEnginePtr(
                              new FDEuropeanEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
using QuantLib::Joshi4;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

SWIGINTERN BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(
                                                            bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(bsProcess,steps));
            else if (s == "eqp" || s == "additiveeqpbinomialtree")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(
                                                            bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(bsProcess,steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Joshi4>(bsProcess,steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

SWIGINTERN MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,intOrNull timeSteps=Null<Size >(),intOrNull timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(bsProcess,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(bsProcess,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

SWIGINTERN FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDAmericanEnginePtr(
                              new FDAmericanEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }
SWIGINTERN FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDShoutEnginePtr(
                                 new FDShoutEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

SWIGINTERN BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                         new BaroneAdesiWhaleyApproximationEngine(bsProcess));
        }

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

SWIGINTERN BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new BjerksundStenslandApproximationEnginePtr(
                        new BjerksundStenslandApproximationEngine(bsProcess));
        }

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

SWIGINTERN AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDigitalAmericanEnginePtr(
                                new AnalyticDigitalAmericanEngine(bsProcess));
        }

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

SWIGINTERN DividendVanillaOptionPtr *new_DividendVanillaOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                          new DividendVanillaOption(stPayoff,exercise,
                                                    dividendDates,dividends));
        }
SWIGINTERN Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
SWIGINTERN Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
SWIGINTERN Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
SWIGINTERN Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
SWIGINTERN Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
SWIGINTERN Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve DividendVanillaOptionPtr_priceCurve(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->impliedVolatility(targetValue, bsProcess, accuracy,
                                    maxEvaluations, minVol, maxVol);
        }

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

SWIGINTERN AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDividendEuropeanEnginePtr(
                               new AnalyticDividendEuropeanEngine(bsProcess));
        }

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

SWIGINTERN FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDDividendEuropeanEnginePtr(
                     new FDDividendEuropeanEngine(bsProcess,timeSteps,
                                                  gridPoints, timeDependent));
        }
SWIGINTERN FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDDividendAmericanEnginePtr(
                     new FDDividendAmericanEngine(bsProcess,timeSteps,
                                                  gridPoints, timeDependent));
        }

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

SWIGINTERN BarrierOptionPtr *new_BarrierOptionPtr(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                               new BarrierOption(barrierType, barrier, rebate,
                                                 stPayoff,exercise));
        }
SWIGINTERN Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
SWIGINTERN Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
SWIGINTERN Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
SWIGINTERN Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
SWIGINTERN Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
SWIGINTERN Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve BarrierOptionPtr_priceCurve(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue, bsProcess, accuracy,
                                     maxEvaluations, minVol, maxVol);
        }

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

SWIGINTERN AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticBarrierEnginePtr(
                                        new AnalyticBarrierEngine(bsProcess));
        }

using QuantLib::MCBarrierEngine;
typedef boost::shared_ptr<PricingEngine> MCBarrierEnginePtr;

SWIGINTERN MCBarrierEnginePtr *new_MCBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),bool isBiased=false,BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCBarrierEnginePtr(
                         new MCBarrierEngine<PseudoRandom>(bsProcess,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCBarrierEnginePtr(
                       new MCBarrierEngine<LowDiscrepancy>(bsProcess,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::QuantoEngine;
using QuantLib::ForwardVanillaEngine;
typedef boost::shared_ptr<PricingEngine> ForwardEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> QuantoEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> QuantoForwardEuropeanEnginePtr;

SWIGINTERN ForwardEuropeanEnginePtr *new_ForwardEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new ForwardEuropeanEnginePtr(
                 new ForwardVanillaEngine<AnalyticEuropeanEngine>(bsProcess));
        }
SWIGINTERN QuantoEuropeanEnginePtr *new_QuantoEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle<YieldTermStructure > const &foreignRiskFreeRate,Handle<BlackVolTermStructure > const &exchangeRateVolatility,Handle<Quote > const &correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new QuantoEuropeanEnginePtr(
                new QuantoEngine<VanillaOption,AnalyticEuropeanEngine>(
                                                       bsProcess,
                                                       foreignRiskFreeRate,
                                                       exchangeRateVolatility,
                                                       correlation));
        }
SWIGINTERN QuantoForwardEuropeanEnginePtr *new_QuantoForwardEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle<YieldTermStructure > const &foreignRiskFreeRate,Handle<BlackVolTermStructure > const &exchangeRateVolatility,Handle<Quote > const &correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new QuantoForwardEuropeanEnginePtr(
                new QuantoEngine<ForwardVanillaOption,AnalyticEuropeanEngine>(
                                                       bsProcess,
                                                       foreignRiskFreeRate,
                                                       exchangeRateVolatility,
                                                       correlation));
        }

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
using QuantLib::GapPayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;
typedef boost::shared_ptr<Payoff> GapPayoffPtr;

SWIGINTERN PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
SWIGINTERN PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
SWIGINTERN CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
SWIGINTERN AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
SWIGINTERN SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }
SWIGINTERN GapPayoffPtr *new_GapPayoffPtr(Option::Type type,Real strike,Real strikePayoff){
            return new GapPayoffPtr(
                               new GapPayoff(type, strike, strikePayoff));
        }

using QuantLib::BasketOption;
using QuantLib::BasketPayoff;
using QuantLib::MinBasketPayoff;
using QuantLib::MaxBasketPayoff;
using QuantLib::AverageBasketPayoff;
typedef boost::shared_ptr<Instrument> BasketOptionPtr;
typedef boost::shared_ptr<Payoff> BasketPayoffPtr;
typedef boost::shared_ptr<Payoff> MinBasketPayoffPtr;
typedef boost::shared_ptr<Payoff> MaxBasketPayoffPtr;
typedef boost::shared_ptr<Payoff> AverageBasketPayoffPtr;

SWIGINTERN MinBasketPayoffPtr *new_MinBasketPayoffPtr(boost::shared_ptr<Payoff > const p){
            return new MinBasketPayoffPtr(new MinBasketPayoff(p));
        }
SWIGINTERN MaxBasketPayoffPtr *new_MaxBasketPayoffPtr(boost::shared_ptr<Payoff > const p){
            return new MaxBasketPayoffPtr(new MaxBasketPayoff(p));
        }
SWIGINTERN AverageBasketPayoffPtr *new_AverageBasketPayoffPtr__SWIG_0(boost::shared_ptr<Payoff > const p,Array const &a){
            return new AverageBasketPayoffPtr(new AverageBasketPayoff(p, a));
        }
SWIGINTERN AverageBasketPayoffPtr *new_AverageBasketPayoffPtr__SWIG_1(boost::shared_ptr<Payoff > const p,Size n){
            return new AverageBasketPayoffPtr(new AverageBasketPayoff(p, n));
        }
SWIGINTERN BasketOptionPtr *new_BasketOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<BasketPayoff> stPayoff =
                 boost::dynamic_pointer_cast<BasketPayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BasketOptionPtr(new BasketOption(stPayoff,exercise));
        }

using QuantLib::MCBasketEngine;
typedef boost::shared_ptr<PricingEngine> MCBasketEnginePtr;

SWIGINTERN MCBasketEnginePtr *new_MCBasketEnginePtr(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCBasketEnginePtr(
                         new MCBasketEngine<PseudoRandom>(processes,
                                                          timeStepsPerYear,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          controlVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCBasketEnginePtr(
                       new MCBasketEngine<LowDiscrepancy>(processes,
                                                          timeStepsPerYear,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          controlVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::MCAmericanBasketEngine;
typedef boost::shared_ptr<PricingEngine> MCAmericanBasketEnginePtr;

SWIGINTERN MCAmericanBasketEnginePtr *new_MCAmericanBasketEnginePtr(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeSteps=Null<Size >(),Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                  return new MCAmericanBasketEnginePtr(
                  new MCAmericanBasketEngine<PseudoRandom>(processes,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCAmericanBasketEnginePtr(
                new MCAmericanBasketEngine<LowDiscrepancy>(processes,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::StulzEngine;
typedef boost::shared_ptr<PricingEngine> StulzEnginePtr;

SWIGINTERN StulzEnginePtr *new_StulzEnginePtr(GeneralizedBlackScholesProcessPtr const &process1,GeneralizedBlackScholesProcessPtr const &process2,Real correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess1 =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                    process1);
            QL_REQUIRE(bsProcess1, "Black-Scholes process required");
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess2 =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                    process2);
            QL_REQUIRE(bsProcess2, "Black-Scholes process required");
            return new StulzEnginePtr(
                          new StulzEngine(bsProcess1,bsProcess2,correlation));
        }

using QuantLib::TimeSeries;
using QuantLib::IntervalPrice;

SWIGINTERN TimeSeries<Real > *new_TimeSeries_Sl_Real_Sg___SWIG_1(std::vector<Date > const &d,std::vector<double > const &v){
            return new TimeSeries<double>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN TimeSeries<IntervalPrice > *new_TimeSeries_Sl_IntervalPrice_Sg___SWIG_1(std::vector<Date > const &d,std::vector<IntervalPrice > const &v){
            return new TimeSeries<IntervalPrice>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN std::vector<IntervalPrice >::const_reference std_vector_Sl_IntervalPrice_Sg__get(std::vector<IntervalPrice > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__set(std::vector<IntervalPrice > *self,int i,std::vector<IntervalPrice >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::IndexManager;


using QuantLib::Index;

SWIGINTERN bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr<Index > *self){
                return !(*self);
            }
SWIGINTERN void boost_shared_ptr_Sl_Index_Sg__addFixings(boost::shared_ptr<Index > *self,std::vector<Date > const &fixingDates,std::vector<Rate > const &fixings){
        (*self)->addFixings(fixingDates.begin(),fixingDates.end(),
                            fixings.begin());
    }
SWIGINTERN std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Index_Sg__asObservable(boost::shared_ptr<Index > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::InterestRateIndex;
typedef boost::shared_ptr<Index> InterestRateIndexPtr;

SWIGINTERN std::string InterestRateIndexPtr_familyName(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->familyName();
        }
SWIGINTERN Period InterestRateIndexPtr_tenor(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->tenor();
        }
SWIGINTERN Natural InterestRateIndexPtr_fixingDays(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->fixingDays();
        }
SWIGINTERN Date InterestRateIndexPtr_fixingDate(InterestRateIndexPtr *self,Date const &valueDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->fixingDate(valueDate);
        }
SWIGINTERN Currency InterestRateIndexPtr_currency(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->currency();
        }
SWIGINTERN DayCounter InterestRateIndexPtr_dayCounter(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->dayCounter();
        }
SWIGINTERN Handle<YieldTermStructure > InterestRateIndexPtr_termStructure(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->termStructure();
        }
SWIGINTERN Date InterestRateIndexPtr_maturityDate(InterestRateIndexPtr *self,Date const &valueDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->maturityDate(valueDate);
        }
SWIGINTERN Date InterestRateIndexPtr_valueDate(InterestRateIndexPtr *self,Date const &fixingDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->valueDate(fixingDate);
        }

using QuantLib::IborIndex;
typedef boost::shared_ptr<Index> IborIndexPtr;

SWIGINTERN IborIndexPtr *new_IborIndexPtr__SWIG_0(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
            return new IborIndexPtr(new IborIndex(familyName, tenor,
                                                  settlementDays,
                                                  currency, calendar,
                                                  convention,
                                                  endOfMonth,
                                                  dayCounter, h));
        }
SWIGINTERN BusinessDayConvention IborIndexPtr_businessDayConvention(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)
                ->businessDayConvention();
        }
SWIGINTERN bool IborIndexPtr_endOfMonth(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)->endOfMonth();
        }

using QuantLib::SwapIndex;
typedef boost::shared_ptr<Index> SwapIndexPtr;

SWIGINTERN SwapIndexPtr *new_SwapIndexPtr(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency &currency,Calendar const &calendar,Period const &fixedLegTenor,BusinessDayConvention fixedLegConvention,DayCounter const &fixedLegDayCounter,IborIndexPtr const &iborIndex){
            boost::shared_ptr<IborIndex> xibor =
                boost::dynamic_pointer_cast<IborIndex>(iborIndex);
            return new SwapIndexPtr(new SwapIndex(familyName,
                                                  tenor, settlementDays,
                                                  currency, calendar,
                                                  fixedLegTenor,
                                                  fixedLegConvention,
                                                  fixedLegDayCounter,
                                                  xibor));
        }
SWIGINTERN Period SwapIndexPtr_fixedLegTenor(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->fixedLegTenor();
        }
SWIGINTERN BusinessDayConvention SwapIndexPtr_fixedLegConvention(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                 ->fixedLegConvention();
        }
SWIGINTERN IborIndexPtr SwapIndexPtr_iborIndex(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->iborIndex();
        }

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

SWIGINTERN AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new AUDLiborPtr(new AUDLibor(tenor,h));
      }

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

SWIGINTERN CADLiborPtr *new_CADLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new CADLiborPtr(new CADLibor(tenor,h));
      }

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

SWIGINTERN CdorPtr *new_CdorPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new CdorPtr(new Cdor(tenor,h));
      }

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

SWIGINTERN CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new CHFLiborPtr(new CHFLibor(tenor,h));
      }

using QuantLib::DKKLibor;
typedef boost::shared_ptr<Index> DKKLiborPtr;

SWIGINTERN DKKLiborPtr *new_DKKLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new DKKLiborPtr(new DKKLibor(tenor,h));
      }

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

SWIGINTERN EuriborPtr *new_EuriborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborPtr(new Euribor(tenor,h));
      }

using QuantLib::EuriborSW;
typedef boost::shared_ptr<Index> EuriborSWPtr;

SWIGINTERN EuriborSWPtr *new_EuriborSWPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSWPtr(new EuriborSW(h));
      }

using QuantLib::Euribor2W;
typedef boost::shared_ptr<Index> Euribor2WPtr;

SWIGINTERN Euribor2WPtr *new_Euribor2WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor2WPtr(new Euribor2W(h));
      }

using QuantLib::Euribor3W;
typedef boost::shared_ptr<Index> Euribor3WPtr;

SWIGINTERN Euribor3WPtr *new_Euribor3WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor3WPtr(new Euribor3W(h));
      }

using QuantLib::Euribor1M;
typedef boost::shared_ptr<Index> Euribor1MPtr;

SWIGINTERN Euribor1MPtr *new_Euribor1MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor1MPtr(new Euribor1M(h));
      }

using QuantLib::Euribor2M;
typedef boost::shared_ptr<Index> Euribor2MPtr;

SWIGINTERN Euribor2MPtr *new_Euribor2MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor2MPtr(new Euribor2M(h));
      }

using QuantLib::Euribor3M;
typedef boost::shared_ptr<Index> Euribor3MPtr;

SWIGINTERN Euribor3MPtr *new_Euribor3MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor3MPtr(new Euribor3M(h));
      }

using QuantLib::Euribor4M;
typedef boost::shared_ptr<Index> Euribor4MPtr;

SWIGINTERN Euribor4MPtr *new_Euribor4MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor4MPtr(new Euribor4M(h));
      }

using QuantLib::Euribor5M;
typedef boost::shared_ptr<Index> Euribor5MPtr;

SWIGINTERN Euribor5MPtr *new_Euribor5MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor5MPtr(new Euribor5M(h));
      }

using QuantLib::Euribor6M;
typedef boost::shared_ptr<Index> Euribor6MPtr;

SWIGINTERN Euribor6MPtr *new_Euribor6MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor6MPtr(new Euribor6M(h));
      }

using QuantLib::Euribor7M;
typedef boost::shared_ptr<Index> Euribor7MPtr;

SWIGINTERN Euribor7MPtr *new_Euribor7MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor7MPtr(new Euribor7M(h));
      }

using QuantLib::Euribor8M;
typedef boost::shared_ptr<Index> Euribor8MPtr;

SWIGINTERN Euribor8MPtr *new_Euribor8MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor8MPtr(new Euribor8M(h));
      }

using QuantLib::Euribor9M;
typedef boost::shared_ptr<Index> Euribor9MPtr;

SWIGINTERN Euribor9MPtr *new_Euribor9MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor9MPtr(new Euribor9M(h));
      }

using QuantLib::Euribor10M;
typedef boost::shared_ptr<Index> Euribor10MPtr;

SWIGINTERN Euribor10MPtr *new_Euribor10MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor10MPtr(new Euribor10M(h));
      }

using QuantLib::Euribor11M;
typedef boost::shared_ptr<Index> Euribor11MPtr;

SWIGINTERN Euribor11MPtr *new_Euribor11MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor11MPtr(new Euribor11M(h));
      }

using QuantLib::Euribor1Y;
typedef boost::shared_ptr<Index> Euribor1YPtr;

SWIGINTERN Euribor1YPtr *new_Euribor1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor1YPtr(new Euribor1Y(h));
      }

using QuantLib::Euribor365;
typedef boost::shared_ptr<Index> Euribor365Ptr;

SWIGINTERN Euribor365Ptr *new_Euribor365Ptr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365Ptr(new Euribor365(tenor,h));
      }

using QuantLib::Euribor365_SW;
typedef boost::shared_ptr<Index> Euribor365_SWPtr;

SWIGINTERN Euribor365_SWPtr *new_Euribor365_SWPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_SWPtr(new Euribor365_SW(h));
      }

using QuantLib::Euribor365_2W;
typedef boost::shared_ptr<Index> Euribor365_2WPtr;

SWIGINTERN Euribor365_2WPtr *new_Euribor365_2WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_2WPtr(new Euribor365_2W(h));
      }

using QuantLib::Euribor365_3W;
typedef boost::shared_ptr<Index> Euribor365_3WPtr;

SWIGINTERN Euribor365_3WPtr *new_Euribor365_3WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_3WPtr(new Euribor365_3W(h));
      }

using QuantLib::Euribor365_1M;
typedef boost::shared_ptr<Index> Euribor365_1MPtr;

SWIGINTERN Euribor365_1MPtr *new_Euribor365_1MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_1MPtr(new Euribor365_1M(h));
      }

using QuantLib::Euribor365_2M;
typedef boost::shared_ptr<Index> Euribor365_2MPtr;

SWIGINTERN Euribor365_2MPtr *new_Euribor365_2MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_2MPtr(new Euribor365_2M(h));
      }

using QuantLib::Euribor365_3M;
typedef boost::shared_ptr<Index> Euribor365_3MPtr;

SWIGINTERN Euribor365_3MPtr *new_Euribor365_3MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_3MPtr(new Euribor365_3M(h));
      }

using QuantLib::Euribor365_4M;
typedef boost::shared_ptr<Index> Euribor365_4MPtr;

SWIGINTERN Euribor365_4MPtr *new_Euribor365_4MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_4MPtr(new Euribor365_4M(h));
      }

using QuantLib::Euribor365_5M;
typedef boost::shared_ptr<Index> Euribor365_5MPtr;

SWIGINTERN Euribor365_5MPtr *new_Euribor365_5MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_5MPtr(new Euribor365_5M(h));
      }

using QuantLib::Euribor365_6M;
typedef boost::shared_ptr<Index> Euribor365_6MPtr;

SWIGINTERN Euribor365_6MPtr *new_Euribor365_6MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_6MPtr(new Euribor365_6M(h));
      }

using QuantLib::Euribor365_7M;
typedef boost::shared_ptr<Index> Euribor365_7MPtr;

SWIGINTERN Euribor365_7MPtr *new_Euribor365_7MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_7MPtr(new Euribor365_7M(h));
      }

using QuantLib::Euribor365_8M;
typedef boost::shared_ptr<Index> Euribor365_8MPtr;

SWIGINTERN Euribor365_8MPtr *new_Euribor365_8MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_8MPtr(new Euribor365_8M(h));
      }

using QuantLib::Euribor365_9M;
typedef boost::shared_ptr<Index> Euribor365_9MPtr;

SWIGINTERN Euribor365_9MPtr *new_Euribor365_9MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_9MPtr(new Euribor365_9M(h));
      }

using QuantLib::Euribor365_10M;
typedef boost::shared_ptr<Index> Euribor365_10MPtr;

SWIGINTERN Euribor365_10MPtr *new_Euribor365_10MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_10MPtr(new Euribor365_10M(h));
      }

using QuantLib::Euribor365_11M;
typedef boost::shared_ptr<Index> Euribor365_11MPtr;

SWIGINTERN Euribor365_11MPtr *new_Euribor365_11MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_11MPtr(new Euribor365_11M(h));
      }

using QuantLib::Euribor365_1Y;
typedef boost::shared_ptr<Index> Euribor365_1YPtr;

SWIGINTERN Euribor365_1YPtr *new_Euribor365_1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_1YPtr(new Euribor365_1Y(h));
      }

using QuantLib::EURLibor;
typedef boost::shared_ptr<Index> EURLiborPtr;

SWIGINTERN EURLiborPtr *new_EURLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLiborPtr(new EURLibor(tenor,h));
      }

using QuantLib::EURLiborSW;
typedef boost::shared_ptr<Index> EURLiborSWPtr;

SWIGINTERN EURLiborSWPtr *new_EURLiborSWPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLiborSWPtr(new EURLiborSW(h));
      }

using QuantLib::EURLibor2W;
typedef boost::shared_ptr<Index> EURLibor2WPtr;

SWIGINTERN EURLibor2WPtr *new_EURLibor2WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor2WPtr(new EURLibor2W(h));
      }

using QuantLib::EURLibor1M;
typedef boost::shared_ptr<Index> EURLibor1MPtr;

SWIGINTERN EURLibor1MPtr *new_EURLibor1MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor1MPtr(new EURLibor1M(h));
      }

using QuantLib::EURLibor2M;
typedef boost::shared_ptr<Index> EURLibor2MPtr;

SWIGINTERN EURLibor2MPtr *new_EURLibor2MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor2MPtr(new EURLibor2M(h));
      }

using QuantLib::EURLibor3M;
typedef boost::shared_ptr<Index> EURLibor3MPtr;

SWIGINTERN EURLibor3MPtr *new_EURLibor3MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor3MPtr(new EURLibor3M(h));
      }

using QuantLib::EURLibor4M;
typedef boost::shared_ptr<Index> EURLibor4MPtr;

SWIGINTERN EURLibor4MPtr *new_EURLibor4MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor4MPtr(new EURLibor4M(h));
      }

using QuantLib::EURLibor5M;
typedef boost::shared_ptr<Index> EURLibor5MPtr;

SWIGINTERN EURLibor5MPtr *new_EURLibor5MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor5MPtr(new EURLibor5M(h));
      }

using QuantLib::EURLibor6M;
typedef boost::shared_ptr<Index> EURLibor6MPtr;

SWIGINTERN EURLibor6MPtr *new_EURLibor6MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor6MPtr(new EURLibor6M(h));
      }

using QuantLib::EURLibor7M;
typedef boost::shared_ptr<Index> EURLibor7MPtr;

SWIGINTERN EURLibor7MPtr *new_EURLibor7MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor7MPtr(new EURLibor7M(h));
      }

using QuantLib::EURLibor8M;
typedef boost::shared_ptr<Index> EURLibor8MPtr;

SWIGINTERN EURLibor8MPtr *new_EURLibor8MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor8MPtr(new EURLibor8M(h));
      }

using QuantLib::EURLibor9M;
typedef boost::shared_ptr<Index> EURLibor9MPtr;

SWIGINTERN EURLibor9MPtr *new_EURLibor9MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor9MPtr(new EURLibor9M(h));
      }

using QuantLib::EURLibor10M;
typedef boost::shared_ptr<Index> EURLibor10MPtr;

SWIGINTERN EURLibor10MPtr *new_EURLibor10MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor10MPtr(new EURLibor10M(h));
      }

using QuantLib::EURLibor11M;
typedef boost::shared_ptr<Index> EURLibor11MPtr;

SWIGINTERN EURLibor11MPtr *new_EURLibor11MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor11MPtr(new EURLibor11M(h));
      }

using QuantLib::EURLibor1Y;
typedef boost::shared_ptr<Index> EURLibor1YPtr;

SWIGINTERN EURLibor1YPtr *new_EURLibor1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor1YPtr(new EURLibor1Y(h));
      }

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

SWIGINTERN GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new GBPLiborPtr(new GBPLibor(tenor,h));
      }

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

SWIGINTERN JibarPtr *new_JibarPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new JibarPtr(new Jibar(tenor,h));
      }

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

SWIGINTERN JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new JPYLiborPtr(new JPYLibor(tenor,h));
      }

using QuantLib::NZDLibor;
typedef boost::shared_ptr<Index> NZDLiborPtr;

SWIGINTERN NZDLiborPtr *new_NZDLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new NZDLiborPtr(new NZDLibor(tenor,h));
      }

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

SWIGINTERN TiborPtr *new_TiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new TiborPtr(new Tibor(tenor,h));
      }

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

SWIGINTERN TRLiborPtr *new_TRLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new TRLiborPtr(new TRLibor(tenor,h));
      }

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

SWIGINTERN USDLiborPtr *new_USDLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new USDLiborPtr(new USDLibor(tenor,h));
      }

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

SWIGINTERN ZiborPtr *new_ZiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new ZiborPtr(new Zibor(tenor,h));
      }

using QuantLib::EuriborSwapFixA;
typedef boost::shared_ptr<Index> EuriborSwapFixAPtr;

SWIGINTERN EuriborSwapFixAPtr *new_EuriborSwapFixAPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixAPtr(new EuriborSwapFixA(tenor,h));
      }

using QuantLib::EuriborSwapFixA1Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA1YPtr;

SWIGINTERN EuriborSwapFixA1YPtr *new_EuriborSwapFixA1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA1YPtr(new EuriborSwapFixA1Y(h));
      }

using QuantLib::EuriborSwapFixA2Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA2YPtr;

SWIGINTERN EuriborSwapFixA2YPtr *new_EuriborSwapFixA2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA2YPtr(new EuriborSwapFixA2Y(h));
      }

using QuantLib::EuriborSwapFixA3Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA3YPtr;

SWIGINTERN EuriborSwapFixA3YPtr *new_EuriborSwapFixA3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA3YPtr(new EuriborSwapFixA3Y(h));
      }

using QuantLib::EuriborSwapFixA4Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA4YPtr;

SWIGINTERN EuriborSwapFixA4YPtr *new_EuriborSwapFixA4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA4YPtr(new EuriborSwapFixA4Y(h));
      }

using QuantLib::EuriborSwapFixA5Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA5YPtr;

SWIGINTERN EuriborSwapFixA5YPtr *new_EuriborSwapFixA5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA5YPtr(new EuriborSwapFixA5Y(h));
      }

using QuantLib::EuriborSwapFixA6Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA6YPtr;

SWIGINTERN EuriborSwapFixA6YPtr *new_EuriborSwapFixA6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA6YPtr(new EuriborSwapFixA6Y(h));
      }

using QuantLib::EuriborSwapFixA7Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA7YPtr;

SWIGINTERN EuriborSwapFixA7YPtr *new_EuriborSwapFixA7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA7YPtr(new EuriborSwapFixA7Y(h));
      }

using QuantLib::EuriborSwapFixA8Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA8YPtr;

SWIGINTERN EuriborSwapFixA8YPtr *new_EuriborSwapFixA8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA8YPtr(new EuriborSwapFixA8Y(h));
      }

using QuantLib::EuriborSwapFixA9Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA9YPtr;

SWIGINTERN EuriborSwapFixA9YPtr *new_EuriborSwapFixA9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA9YPtr(new EuriborSwapFixA9Y(h));
      }

using QuantLib::EuriborSwapFixA10Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA10YPtr;

SWIGINTERN EuriborSwapFixA10YPtr *new_EuriborSwapFixA10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA10YPtr(new EuriborSwapFixA10Y(h));
      }

using QuantLib::EuriborSwapFixA12Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA12YPtr;

SWIGINTERN EuriborSwapFixA12YPtr *new_EuriborSwapFixA12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA12YPtr(new EuriborSwapFixA12Y(h));
      }

using QuantLib::EuriborSwapFixA15Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA15YPtr;

SWIGINTERN EuriborSwapFixA15YPtr *new_EuriborSwapFixA15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA15YPtr(new EuriborSwapFixA15Y(h));
      }

using QuantLib::EuriborSwapFixA20Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA20YPtr;

SWIGINTERN EuriborSwapFixA20YPtr *new_EuriborSwapFixA20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA20YPtr(new EuriborSwapFixA20Y(h));
      }

using QuantLib::EuriborSwapFixA25Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA25YPtr;

SWIGINTERN EuriborSwapFixA25YPtr *new_EuriborSwapFixA25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA25YPtr(new EuriborSwapFixA25Y(h));
      }

using QuantLib::EuriborSwapFixA30Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA30YPtr;

SWIGINTERN EuriborSwapFixA30YPtr *new_EuriborSwapFixA30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA30YPtr(new EuriborSwapFixA30Y(h));
      }

using QuantLib::EuriborSwapFixIFR;
typedef boost::shared_ptr<Index> EuriborSwapFixIFRPtr;

SWIGINTERN EuriborSwapFixIFRPtr *new_EuriborSwapFixIFRPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFRPtr(new EuriborSwapFixIFR(tenor,h));
      }

using QuantLib::EuriborSwapFixIFR1Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR1YPtr;

SWIGINTERN EuriborSwapFixIFR1YPtr *new_EuriborSwapFixIFR1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR1YPtr(new EuriborSwapFixIFR1Y(h));
      }

using QuantLib::EuriborSwapFixIFR2Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR2YPtr;

SWIGINTERN EuriborSwapFixIFR2YPtr *new_EuriborSwapFixIFR2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR2YPtr(new EuriborSwapFixIFR2Y(h));
      }

using QuantLib::EuriborSwapFixIFR3Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR3YPtr;

SWIGINTERN EuriborSwapFixIFR3YPtr *new_EuriborSwapFixIFR3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR3YPtr(new EuriborSwapFixIFR3Y(h));
      }

using QuantLib::EuriborSwapFixIFR4Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR4YPtr;

SWIGINTERN EuriborSwapFixIFR4YPtr *new_EuriborSwapFixIFR4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR4YPtr(new EuriborSwapFixIFR4Y(h));
      }

using QuantLib::EuriborSwapFixIFR5Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR5YPtr;

SWIGINTERN EuriborSwapFixIFR5YPtr *new_EuriborSwapFixIFR5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR5YPtr(new EuriborSwapFixIFR5Y(h));
      }

using QuantLib::EuriborSwapFixIFR6Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR6YPtr;

SWIGINTERN EuriborSwapFixIFR6YPtr *new_EuriborSwapFixIFR6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR6YPtr(new EuriborSwapFixIFR6Y(h));
      }

using QuantLib::EuriborSwapFixIFR7Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR7YPtr;

SWIGINTERN EuriborSwapFixIFR7YPtr *new_EuriborSwapFixIFR7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR7YPtr(new EuriborSwapFixIFR7Y(h));
      }

using QuantLib::EuriborSwapFixIFR8Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR8YPtr;

SWIGINTERN EuriborSwapFixIFR8YPtr *new_EuriborSwapFixIFR8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR8YPtr(new EuriborSwapFixIFR8Y(h));
      }

using QuantLib::EuriborSwapFixIFR9Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR9YPtr;

SWIGINTERN EuriborSwapFixIFR9YPtr *new_EuriborSwapFixIFR9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR9YPtr(new EuriborSwapFixIFR9Y(h));
      }

using QuantLib::EuriborSwapFixIFR10Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR10YPtr;

SWIGINTERN EuriborSwapFixIFR10YPtr *new_EuriborSwapFixIFR10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR10YPtr(new EuriborSwapFixIFR10Y(h));
      }

using QuantLib::EuriborSwapFixIFR12Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR12YPtr;

SWIGINTERN EuriborSwapFixIFR12YPtr *new_EuriborSwapFixIFR12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR12YPtr(new EuriborSwapFixIFR12Y(h));
      }

using QuantLib::EuriborSwapFixIFR15Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR15YPtr;

SWIGINTERN EuriborSwapFixIFR15YPtr *new_EuriborSwapFixIFR15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR15YPtr(new EuriborSwapFixIFR15Y(h));
      }

using QuantLib::EuriborSwapFixIFR20Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR20YPtr;

SWIGINTERN EuriborSwapFixIFR20YPtr *new_EuriborSwapFixIFR20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR20YPtr(new EuriborSwapFixIFR20Y(h));
      }

using QuantLib::EuriborSwapFixIFR25Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR25YPtr;

SWIGINTERN EuriborSwapFixIFR25YPtr *new_EuriborSwapFixIFR25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR25YPtr(new EuriborSwapFixIFR25Y(h));
      }

using QuantLib::EuriborSwapFixIFR30Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR30YPtr;

SWIGINTERN EuriborSwapFixIFR30YPtr *new_EuriborSwapFixIFR30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR30YPtr(new EuriborSwapFixIFR30Y(h));
      }

using QuantLib::EurliborSwapFixA;
typedef boost::shared_ptr<Index> EurliborSwapFixAPtr;

SWIGINTERN EurliborSwapFixAPtr *new_EurliborSwapFixAPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixAPtr(new EurliborSwapFixA(tenor,h));
      }

using QuantLib::EurliborSwapFixA1Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA1YPtr;

SWIGINTERN EurliborSwapFixA1YPtr *new_EurliborSwapFixA1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA1YPtr(new EurliborSwapFixA1Y(h));
      }

using QuantLib::EurliborSwapFixA2Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA2YPtr;

SWIGINTERN EurliborSwapFixA2YPtr *new_EurliborSwapFixA2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA2YPtr(new EurliborSwapFixA2Y(h));
      }

using QuantLib::EurliborSwapFixA3Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA3YPtr;

SWIGINTERN EurliborSwapFixA3YPtr *new_EurliborSwapFixA3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA3YPtr(new EurliborSwapFixA3Y(h));
      }

using QuantLib::EurliborSwapFixA4Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA4YPtr;

SWIGINTERN EurliborSwapFixA4YPtr *new_EurliborSwapFixA4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA4YPtr(new EurliborSwapFixA4Y(h));
      }

using QuantLib::EurliborSwapFixA5Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA5YPtr;

SWIGINTERN EurliborSwapFixA5YPtr *new_EurliborSwapFixA5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA5YPtr(new EurliborSwapFixA5Y(h));
      }

using QuantLib::EurliborSwapFixA6Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA6YPtr;

SWIGINTERN EurliborSwapFixA6YPtr *new_EurliborSwapFixA6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA6YPtr(new EurliborSwapFixA6Y(h));
      }

using QuantLib::EurliborSwapFixA7Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA7YPtr;

SWIGINTERN EurliborSwapFixA7YPtr *new_EurliborSwapFixA7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA7YPtr(new EurliborSwapFixA7Y(h));
      }

using QuantLib::EurliborSwapFixA8Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA8YPtr;

SWIGINTERN EurliborSwapFixA8YPtr *new_EurliborSwapFixA8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA8YPtr(new EurliborSwapFixA8Y(h));
      }

using QuantLib::EurliborSwapFixA9Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA9YPtr;

SWIGINTERN EurliborSwapFixA9YPtr *new_EurliborSwapFixA9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA9YPtr(new EurliborSwapFixA9Y(h));
      }

using QuantLib::EurliborSwapFixA10Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA10YPtr;

SWIGINTERN EurliborSwapFixA10YPtr *new_EurliborSwapFixA10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA10YPtr(new EurliborSwapFixA10Y(h));
      }

using QuantLib::EurliborSwapFixA12Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA12YPtr;

SWIGINTERN EurliborSwapFixA12YPtr *new_EurliborSwapFixA12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA12YPtr(new EurliborSwapFixA12Y(h));
      }

using QuantLib::EurliborSwapFixA15Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA15YPtr;

SWIGINTERN EurliborSwapFixA15YPtr *new_EurliborSwapFixA15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA15YPtr(new EurliborSwapFixA15Y(h));
      }

using QuantLib::EurliborSwapFixA20Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA20YPtr;

SWIGINTERN EurliborSwapFixA20YPtr *new_EurliborSwapFixA20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA20YPtr(new EurliborSwapFixA20Y(h));
      }

using QuantLib::EurliborSwapFixA25Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA25YPtr;

SWIGINTERN EurliborSwapFixA25YPtr *new_EurliborSwapFixA25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA25YPtr(new EurliborSwapFixA25Y(h));
      }

using QuantLib::EurliborSwapFixA30Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA30YPtr;

SWIGINTERN EurliborSwapFixA30YPtr *new_EurliborSwapFixA30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA30YPtr(new EurliborSwapFixA30Y(h));
      }

using QuantLib::EurliborSwapFixB;
typedef boost::shared_ptr<Index> EurliborSwapFixBPtr;

SWIGINTERN EurliborSwapFixBPtr *new_EurliborSwapFixBPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixBPtr(new EurliborSwapFixB(tenor,h));
      }

using QuantLib::EurliborSwapFixB1Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB1YPtr;

SWIGINTERN EurliborSwapFixB1YPtr *new_EurliborSwapFixB1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB1YPtr(new EurliborSwapFixB1Y(h));
      }

using QuantLib::EurliborSwapFixB2Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB2YPtr;

SWIGINTERN EurliborSwapFixB2YPtr *new_EurliborSwapFixB2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB2YPtr(new EurliborSwapFixB2Y(h));
      }

using QuantLib::EurliborSwapFixB3Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB3YPtr;

SWIGINTERN EurliborSwapFixB3YPtr *new_EurliborSwapFixB3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB3YPtr(new EurliborSwapFixB3Y(h));
      }

using QuantLib::EurliborSwapFixB4Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB4YPtr;

SWIGINTERN EurliborSwapFixB4YPtr *new_EurliborSwapFixB4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB4YPtr(new EurliborSwapFixB4Y(h));
      }

using QuantLib::EurliborSwapFixB5Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB5YPtr;

SWIGINTERN EurliborSwapFixB5YPtr *new_EurliborSwapFixB5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB5YPtr(new EurliborSwapFixB5Y(h));
      }

using QuantLib::EurliborSwapFixB6Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB6YPtr;

SWIGINTERN EurliborSwapFixB6YPtr *new_EurliborSwapFixB6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB6YPtr(new EurliborSwapFixB6Y(h));
      }

using QuantLib::EurliborSwapFixB7Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB7YPtr;

SWIGINTERN EurliborSwapFixB7YPtr *new_EurliborSwapFixB7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB7YPtr(new EurliborSwapFixB7Y(h));
      }

using QuantLib::EurliborSwapFixB8Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB8YPtr;

SWIGINTERN EurliborSwapFixB8YPtr *new_EurliborSwapFixB8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB8YPtr(new EurliborSwapFixB8Y(h));
      }

using QuantLib::EurliborSwapFixB9Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB9YPtr;

SWIGINTERN EurliborSwapFixB9YPtr *new_EurliborSwapFixB9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB9YPtr(new EurliborSwapFixB9Y(h));
      }

using QuantLib::EurliborSwapFixB10Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB10YPtr;

SWIGINTERN EurliborSwapFixB10YPtr *new_EurliborSwapFixB10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB10YPtr(new EurliborSwapFixB10Y(h));
      }

using QuantLib::EurliborSwapFixB12Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB12YPtr;

SWIGINTERN EurliborSwapFixB12YPtr *new_EurliborSwapFixB12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB12YPtr(new EurliborSwapFixB12Y(h));
      }

using QuantLib::EurliborSwapFixB15Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB15YPtr;

SWIGINTERN EurliborSwapFixB15YPtr *new_EurliborSwapFixB15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB15YPtr(new EurliborSwapFixB15Y(h));
      }

using QuantLib::EurliborSwapFixB20Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB20YPtr;

SWIGINTERN EurliborSwapFixB20YPtr *new_EurliborSwapFixB20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB20YPtr(new EurliborSwapFixB20Y(h));
      }

using QuantLib::EurliborSwapFixB25Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB25YPtr;

SWIGINTERN EurliborSwapFixB25YPtr *new_EurliborSwapFixB25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB25YPtr(new EurliborSwapFixB25Y(h));
      }

using QuantLib::EurliborSwapFixB30Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB30YPtr;

SWIGINTERN EurliborSwapFixB30YPtr *new_EurliborSwapFixB30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB30YPtr(new EurliborSwapFixB30Y(h));
      }

using QuantLib::EurliborSwapFixIFR;
typedef boost::shared_ptr<Index> EurliborSwapFixIFRPtr;

SWIGINTERN EurliborSwapFixIFRPtr *new_EurliborSwapFixIFRPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFRPtr(new EurliborSwapFixIFR(tenor,h));
      }

using QuantLib::EurliborSwapFixIFR1Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR1YPtr;

SWIGINTERN EurliborSwapFixIFR1YPtr *new_EurliborSwapFixIFR1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR1YPtr(new EurliborSwapFixIFR1Y(h));
      }

using QuantLib::EurliborSwapFixIFR2Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR2YPtr;

SWIGINTERN EurliborSwapFixIFR2YPtr *new_EurliborSwapFixIFR2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR2YPtr(new EurliborSwapFixIFR2Y(h));
      }

using QuantLib::EurliborSwapFixIFR3Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR3YPtr;

SWIGINTERN EurliborSwapFixIFR3YPtr *new_EurliborSwapFixIFR3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR3YPtr(new EurliborSwapFixIFR3Y(h));
      }

using QuantLib::EurliborSwapFixIFR4Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR4YPtr;

SWIGINTERN EurliborSwapFixIFR4YPtr *new_EurliborSwapFixIFR4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR4YPtr(new EurliborSwapFixIFR4Y(h));
      }

using QuantLib::EurliborSwapFixIFR5Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR5YPtr;

SWIGINTERN EurliborSwapFixIFR5YPtr *new_EurliborSwapFixIFR5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR5YPtr(new EurliborSwapFixIFR5Y(h));
      }

using QuantLib::EurliborSwapFixIFR6Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR6YPtr;

SWIGINTERN EurliborSwapFixIFR6YPtr *new_EurliborSwapFixIFR6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR6YPtr(new EurliborSwapFixIFR6Y(h));
      }

using QuantLib::EurliborSwapFixIFR7Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR7YPtr;

SWIGINTERN EurliborSwapFixIFR7YPtr *new_EurliborSwapFixIFR7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR7YPtr(new EurliborSwapFixIFR7Y(h));
      }

using QuantLib::EurliborSwapFixIFR8Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR8YPtr;

SWIGINTERN EurliborSwapFixIFR8YPtr *new_EurliborSwapFixIFR8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR8YPtr(new EurliborSwapFixIFR8Y(h));
      }

using QuantLib::EurliborSwapFixIFR9Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR9YPtr;

SWIGINTERN EurliborSwapFixIFR9YPtr *new_EurliborSwapFixIFR9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR9YPtr(new EurliborSwapFixIFR9Y(h));
      }

using QuantLib::EurliborSwapFixIFR10Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR10YPtr;

SWIGINTERN EurliborSwapFixIFR10YPtr *new_EurliborSwapFixIFR10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR10YPtr(new EurliborSwapFixIFR10Y(h));
      }

using QuantLib::EurliborSwapFixIFR12Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR12YPtr;

SWIGINTERN EurliborSwapFixIFR12YPtr *new_EurliborSwapFixIFR12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR12YPtr(new EurliborSwapFixIFR12Y(h));
      }

using QuantLib::EurliborSwapFixIFR15Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR15YPtr;

SWIGINTERN EurliborSwapFixIFR15YPtr *new_EurliborSwapFixIFR15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR15YPtr(new EurliborSwapFixIFR15Y(h));
      }

using QuantLib::EurliborSwapFixIFR20Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR20YPtr;

SWIGINTERN EurliborSwapFixIFR20YPtr *new_EurliborSwapFixIFR20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR20YPtr(new EurliborSwapFixIFR20Y(h));
      }

using QuantLib::EurliborSwapFixIFR25Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR25YPtr;

SWIGINTERN EurliborSwapFixIFR25YPtr *new_EurliborSwapFixIFR25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR25YPtr(new EurliborSwapFixIFR25Y(h));
      }

using QuantLib::EurliborSwapFixIFR30Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR30YPtr;

SWIGINTERN EurliborSwapFixIFR30YPtr *new_EurliborSwapFixIFR30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR30YPtr(new EurliborSwapFixIFR30Y(h));
      }

using QuantLib::Schedule;
using QuantLib::DateGeneration;


using QuantLib::CashFlow;

SWIGINTERN bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr<CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::IborCoupon;
using QuantLib::Leg;
using QuantLib::FloatingRateCoupon;

typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> IborCouponPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> FloatingRateCouponPtr;

SWIGINTERN SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
SWIGINTERN FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }
SWIGINTERN IborCouponPtr *new_IborCouponPtr__SWIG_0(Date const &paymentDate,Real nominal,Date const &startDate,Date const &endDate,Integer fixingDays,InterestRateIndexPtr &index,Real gearing=1.0,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter()){
            const boost::shared_ptr<IborIndex> iri =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new IborCouponPtr(
                new IborCoupon(paymentDate, nominal, startDate, endDate,
                              fixingDays, iri, gearing, spread,
                              refPeriodStart, refPeriodEnd, dayCounter));
        }
SWIGINTERN Rate IborCouponPtr_rate(IborCouponPtr *self){
            return boost::dynamic_pointer_cast<IborCoupon>(*self)->rate();
        }
SWIGINTERN Rate IborCouponPtr_indexFixing(IborCouponPtr *self){
            return boost::dynamic_pointer_cast<IborCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Real IborCouponPtr_nominal(IborCouponPtr *self){
            return boost::dynamic_pointer_cast<IborCoupon>(*self)->nominal();
        }
SWIGINTERN Rate FloatingRateCouponPtr_rate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->rate();
        }
SWIGINTERN Integer FloatingRateCouponPtr_fixingDays(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDays();
        }
SWIGINTERN Rate FloatingRateCouponPtr_spread(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->spread();
        }
SWIGINTERN Rate FloatingRateCouponPtr_indexFixing(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Date FloatingRateCouponPtr_fixingDate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDate();
        }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__get(std::vector<boost::shared_ptr<CashFlow > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__set(std::vector<boost::shared_ptr<CashFlow > > *self,int i,std::vector<boost::shared_ptr<CashFlow > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

Leg _FixedRateLeg(const Schedule& schedule,
                  const DayCounter& dayCount,
                  const std::vector<Real>& nominals,
                  const std::vector<Rate>& couponRates,
                  BusinessDayConvention paymentAdjustment = Following,
                  const DayCounter& firstPeriodDayCount = DayCounter()) {
    return QuantLib::FixedRateLeg(schedule,dayCount)
        .withNotionals(nominals)
        .withCouponRates(couponRates)
        .withPaymentAdjustment(paymentAdjustment)
        .withFirstPeriodDayCounter(firstPeriodDayCount);
}


Leg _IborLeg(const std::vector<Real>& nominals,
             const Schedule& schedule,
             const boost::shared_ptr<Index>& index,
             const DayCounter& paymentDayCounter = DayCounter(),
             const BusinessDayConvention paymentConvention = Following,
             const std::vector<Natural>& fixingDays = std::vector<Natural>(),
             const std::vector<Real>& gearings = std::vector<Real>(),
             const std::vector<Spread>& spreads = std::vector<Spread>(),
             const std::vector<Rate>& caps = std::vector<Rate>(),
             const std::vector<Rate>& floors = std::vector<Rate>(),
             bool isInArrears = false) {
    boost::shared_ptr<IborIndex> libor =
        boost::dynamic_pointer_cast<IborIndex>(index);
    return QuantLib::IborLeg(schedule, libor)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const boost::shared_ptr<Index>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsZeroLeg(const std::vector<Real>& nominals,
                const Schedule& schedule,
                const boost::shared_ptr<Index>& index,
                const DayCounter& paymentDayCounter = DayCounter(),
                const BusinessDayConvention paymentConvention = Following,
                const std::vector<Natural>& fixingDays = std::vector<Natural>(),
                const std::vector<Real>& gearings = std::vector<Real>(),
                const std::vector<Spread>& spreads = std::vector<Spread>(),
                const std::vector<Rate>& caps = std::vector<Rate>(),
                const std::vector<Rate>& floors = std::vector<Rate>()) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withZeroPayments();
}


using QuantLib::CashFlows;
using QuantLib::Duration;


using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedRateBond;
using QuantLib::FloatingRateBond;
using QuantLib::DiscountingBondEngine;

typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedRateBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> DiscountingBondEnginePtr;

SWIGINTERN Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
SWIGINTERN boost::shared_ptr<CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
SWIGINTERN Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,DayCounter const &dc,Compounding compounding,Frequency frequency,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,dc, compounding, frequency, settlement);
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,DayCounter const &dc,Compounding compounding,Frequency frequency,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,dc, compounding,
        frequency,
        settlement);
        }
SWIGINTERN Real BondPtr_yield__SWIG_0(BondPtr *self,DayCounter const &dc,Compounding compounding,Frequency freq,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(dc,compounding,freq,accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,DayCounter const &dc,Compounding compounding,Frequency freq,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,dc,compounding,freq,
            settlement,
                        accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
SWIGINTERN ZeroCouponBondPtr *new_ZeroCouponBondPtr(Natural settlementDays,Calendar const &calendar,Real faceAmount,Date const &maturityDate,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date const &issueDate=Date()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(settlementDays, calendar, faceAmount,
                                   maturityDate,
                                   paymentConvention, redemption,
                                   issueDate));
        }
SWIGINTERN FixedRateBondPtr *new_FixedRateBondPtr(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector<Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date issueDate=Date()){
            return new FixedRateBondPtr(
                new FixedRateBond(settlementDays, faceAmount,
                                  schedule, coupons, paymentDayCounter,
                                  paymentConvention, redemption,
                                  issueDate));
        }
SWIGINTERN FloatingRateBondPtr *new_FloatingRateBondPtr(Size settlementDays,Real faceAmount,Schedule const &schedule,IborIndexPtr const &index,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention,Size fixingDays,std::vector<Real > const &gearings,std::vector<Spread > const &spreads,std::vector<Rate > const &caps,std::vector<Rate > const &floors,bool inArrears,Real redemption,Date const &issueDate){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(settlementDays,
                                     faceAmount,
                                     schedule,
                                     libor,
                                     paymentDayCounter,
                                     paymentConvention,
                                     fixingDays,
                                     gearings,
                                     spreads,
                                     caps,
                                     floors,
                                     inArrears,
                                     redemption,
                                     issueDate));
        }
SWIGINTERN DiscountingBondEnginePtr *new_DiscountingBondEnginePtr(Handle<YieldTermStructure > const &discountCurve){
            return new DiscountingBondEnginePtr(
                                    new DiscountingBondEngine(discountCurve));
        }

using QuantLib::Callability;
using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> CallabilityPtr;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;
typedef Callability::Price CallabilityPrice;
using QuantLib::CallabilitySchedule;

SWIGINTERN bool boost_shared_ptr_Sl_Callability_Sg__isNull(boost::shared_ptr<Callability > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Callability > *new_boost_shared_ptr_Sl_Callability_Sg_(CallabilityPrice const &price,Callability::Type type,Date const &date){
        return new boost::shared_ptr<Callability>(
                                            new Callability(price,type,date));
    }

using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;

SWIGINTERN SoftCallabilityPtr *new_SoftCallabilityPtr(CallabilityPrice const &price,Date const &date,Real trigger){
            return new SoftCallabilityPtr(new SoftCallability(price,date,
                                                              trigger));
        }
SWIGINTERN std::vector<boost::shared_ptr<Callability > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__get(std::vector<boost::shared_ptr<Callability > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__set(std::vector<boost::shared_ptr<Callability > > *self,int i,std::vector<boost::shared_ptr<Callability > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::CapFloor;
using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;

typedef boost::shared_ptr<Instrument> CapFloorPtr;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

SWIGINTERN Volatility CapFloorPtr_impliedVolatility__SWIG_0(CapFloorPtr const *self,Real price,Handle<YieldTermStructure > const &curve,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-7,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->
                impliedVolatility(price, curve, accuracy, maxEvaluations,
                                  minVol, maxVol);
        }
SWIGINTERN CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates){
            return new CapPtr(new Cap(leg,capRates));
        }
SWIGINTERN FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates){
            return new FloorPtr(new Floor(leg,floorRates));
        }
SWIGINTERN CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates){
            return new CollarPtr(new Collar(leg,capRates,floorRates));
        }

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Handle<Quote > const &vol){
            return new BlackCapFloorEnginePtr(
                                  new BlackCapFloorEngine(termStructure,vol));
        }
SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr__SWIG_1(Handle<YieldTermStructure > const &termStructure,Handle<OptionletVolatilityStructure > const &vol){
            return new BlackCapFloorEnginePtr(
                                  new BlackCapFloorEngine(termStructure,vol));
        }

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

SWIGINTERN CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
            return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
SWIGINTERN std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }
SWIGINTERN Rate CompoundForwardPtr_compoundForward__SWIG_0(CompoundForwardPtr const *self,Date const &d,Integer f,bool extrapolate=false){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                ->compoundForward(d, f, extrapolate);
        }
SWIGINTERN Rate CompoundForwardPtr_compoundForward__SWIG_2(CompoundForwardPtr const *self,Time const t,Integer f,bool extrapolate=false){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                ->compoundForward(t, f, extrapolate);
        }

using QuantLib::Dividend;

SWIGINTERN bool boost_shared_ptr_Sl_Dividend_Sg__isNull(boost::shared_ptr<Dividend > *self){
                return !(*self);
            }

using QuantLib::FixedDividend;
using QuantLib::FractionalDividend;

typedef boost::shared_ptr<Dividend> FixedDividendPtr;
typedef boost::shared_ptr<Dividend> FractionalDividendPtr;

SWIGINTERN FixedDividendPtr *new_FixedDividendPtr(Real amount,Date const &date){
            return new FixedDividendPtr(new FixedDividend(amount,date));
        }
SWIGINTERN FractionalDividendPtr *new_FractionalDividendPtr(Rate rate,Date const &date){
            return new FractionalDividendPtr(
                                     new FractionalDividend(rate,date));
        }
SWIGINTERN std::vector<boost::shared_ptr<Dividend > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__get(std::vector<boost::shared_ptr<Dividend > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__set(std::vector<boost::shared_ptr<Dividend > > *self,int i,std::vector<boost::shared_ptr<Dividend > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::ConvertibleZeroCouponBond;
using QuantLib::ConvertibleFixedCouponBond;
using QuantLib::ConvertibleFloatingRateBond;
using QuantLib::BinomialConvertibleEngine;
typedef boost::shared_ptr<Instrument> ConvertibleZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> BinomialConvertibleEnginePtr;

SWIGINTERN ConvertibleZeroCouponBondPtr *new_ConvertibleZeroCouponBondPtr__SWIG_0(boost::shared_ptr<Exercise > const &exercise,Real conversionRatio,std::vector<boost::shared_ptr<Dividend > > const &dividends,std::vector<boost::shared_ptr<Callability > > const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            return new ConvertibleZeroCouponBondPtr(
                     new ConvertibleZeroCouponBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN ConvertibleFixedCouponBondPtr *new_ConvertibleFixedCouponBondPtr__SWIG_0(boost::shared_ptr<Exercise > const &exercise,Real conversionRatio,std::vector<boost::shared_ptr<Dividend > > const &dividends,std::vector<boost::shared_ptr<Callability > > const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,std::vector<Rate > const &coupons,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            return new ConvertibleFixedCouponBondPtr(
                    new ConvertibleFixedCouponBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   coupons, dayCounter,
                                                   schedule, redemption));
        }
SWIGINTERN ConvertibleFloatingRateBondPtr *new_ConvertibleFloatingRateBondPtr__SWIG_0(boost::shared_ptr<Exercise > const &exercise,Real conversionRatio,std::vector<boost::shared_ptr<Dividend > > const &dividends,std::vector<boost::shared_ptr<Callability > > const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,IborIndexPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new ConvertibleFloatingRateBondPtr(
                   new ConvertibleFloatingRateBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   libor, fixingDays, spreads,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN BinomialConvertibleEnginePtr *new_BinomialConvertibleEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<CoxRossRubinstein>(
                                                            bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<JarrowRudd>(
                                                            bsProcess,steps));
            else if (s == "eqp")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<AdditiveEQPBinomialTree>(
                                                            bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Trigeorgis>(
                                                            bsProcess,steps));
            else if (s == "tian")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Tian>(bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<LeisenReimer>(
                                                            bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Joshi4>(bsProcess,steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::InterpolatedDiscountCurve;


typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;

SWIGINTERN DiscountCurvePtr *new_DiscountCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),LogLinear const &i=LogLinear()){
            return new DiscountCurvePtr(
                new InterpolatedDiscountCurve<LogLinear>(dates,discounts,
                                                            dayCounter,
                                                            calendar,i));
        }
SWIGINTERN std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
SWIGINTERN std::vector<DiscountFactor > const &DiscountCurvePtr_discounts(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->discounts();
        }
SWIGINTERN std::vector<std::pair<Date,DiscountFactor > > DiscountCurvePtr_nodes(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->nodes();
        }

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;
using QuantLib::BivariateCumulativeNormalDistribution;


using QuantLib::Money;

SWIGINTERN Money Money_operator_Sa___SWIG_1(Money *self,Money const &m){ return *self+m; }
SWIGINTERN Money Money_operator_Ss___SWIG_1(Money *self,Money const &m){ return *self-m; }
SWIGINTERN Money Money_operator_Sm_(Money *self,Decimal x){ return *self*x; }
SWIGINTERN Money Money_operator_Sd___SWIG_0(Money *self,Decimal x){ return *self/x; }
SWIGINTERN Decimal Money_operator_Sd___SWIG_1(Money *self,Money const &m){ return *self/m; }
SWIGINTERN int Money___cmp__(Money *self,Money const &other){
            if (*self < other)
                return -1;
            else if (*self == other)
                return 0;
            else
                return 1;
        }
SWIGINTERN std::string Money___str__(Money *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
SWIGINTERN void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::InterpolatedForwardCurve;


typedef boost::shared_ptr<YieldTermStructure> ForwardCurvePtr;

SWIGINTERN ForwardCurvePtr *new_ForwardCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<Rate > const &forwards,DayCounter const &dayCounter,BackwardFlat const &i=BackwardFlat()){
            return new ForwardCurvePtr(
                new InterpolatedForwardCurve<BackwardFlat>(dates,forwards,
                                                           dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &ForwardCurvePtr_dates(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->dates();
        }
SWIGINTERN std::vector<Rate > const &ForwardCurvePtr_forwards(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->forwards();
        }
SWIGINTERN std::vector<std::pair<Date,Rate > > ForwardCurvePtr_nodes(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->nodes();
        }

using QuantLib::TimeGrid;

SWIGINTERN TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
SWIGINTERN TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }
SWIGINTERN Time TimeGrid_ref(TimeGrid *self,Size i){
            if (i<self->size())
                return (*self)[i];
            else
                throw std::out_of_range("time-grid index out of range");
        }
SWIGINTERN Time TimeGrid_dt(TimeGrid *self,Size i){
            if (i<self->size())
                return self->dt(i);
            else
                throw std::out_of_range("time-grid index out of range");
        }

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::Default;
using QuantLib::MidPoint;
using QuantLib::SimpsonIntegral;
using QuantLib::GaussKronrodAdaptive;
using QuantLib::GaussKronrodNonAdaptive;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

SWIGINTERN double Sample_Sl_Real_Sg__value(Sample<Real > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Real_Sg__weight(Sample<Real > *self){ return self->weight; }
SWIGINTERN Array Sample_Sl_Array_Sg__value(Sample<Array > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Array_Sg__weight(Sample<Array > *self){ return self->weight; }
SWIGINTERN std::vector<double > Sample_Sl_std_vector_Sl_Real_Sg__Sg__value(Sample<std::vector<Real > > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_std_vector_Sl_Real_Sg__Sg__weight(Sample<std::vector<Real > > *self){ return self->weight; }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;


typedef QuantLib::PathGenerator<GaussianRandomSequenceGenerator>
    GaussianPathGenerator;

SWIGINTERN Path Sample_Sl_Path_Sg__value(Sample<Path > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Path_Sg__weight(Sample<Path > *self){ return self->weight; }
SWIGINTERN GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }

using QuantLib::MultiPath;


typedef QuantLib::MultiPathGenerator<GaussianRandomSequenceGenerator>
    GaussianMultiPathGenerator;

SWIGINTERN MultiPath Sample_Sl_MultiPath_Sg__value(Sample<MultiPath > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_MultiPath_Sg__weight(Sample<MultiPath > *self){ return self->weight; }
SWIGINTERN GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
        DefaultBoundaryCondition;

SWIGINTERN bool boost_shared_ptr_Sl_DefaultBoundaryCondition_Sg__isNull(boost::shared_ptr<DefaultBoundaryCondition > *self){
                return !(*self);
            }

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<DefaultBoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<DefaultBoundaryCondition> DirichletBCPtr;

SWIGINTERN NeumannBCPtr *new_NeumannBCPtr(Real value,DefaultBoundaryCondition::Side side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
SWIGINTERN DirichletBCPtr *new_DirichletBCPtr(Real value,DefaultBoundaryCondition::Side side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;


using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


using QuantLib::Problem;


    class Optimizer {};


using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
using QuantLib::FixedRateBondHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FixedRateBondHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Period const &tenor,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,settlementDays,
                                      calendar,convention,
                                      endOfMonth, fixingDays,
                                      dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Period const &tenor,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,settlementDays,
                                      calendar,convention,
                                      endOfMonth, fixingDays,
                                      dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Natural monthsToStart,Natural monthsToEnd,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  endOfMonth, fixingDays,
                                  dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Natural monthsToStart,Natural monthsToEnd,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  endOfMonth, fixingDays,
                                  dayCounter));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<Quote > const &convexityAdjustment){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Handle<Quote > const &price,Date const &immDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate convexityAdjustment=0.0){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_3(Real price,Date const &immDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate convexityAdjustment=0.0){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Period const &tenor,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, calendar,
                                   fixedFrequency, fixedConvention,
                                   fixedDayCount, libor));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Period const &tenor,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, calendar,
                                   fixedFrequency, fixedConvention,
                                   fixedDayCount, libor));
        }
SWIGINTERN FixedRateBondHelperPtr *new_FixedRateBondHelperPtr__SWIG_0(Handle<Quote > const &cleanPrice,Size settlementDays,Schedule const &schedule,std::vector<Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Date const &issueDate=Date()){
            return new FixedRateBondHelperPtr(
                new FixedRateBondHelper(cleanPrice, settlementDays,
                                        schedule, coupons, paymentDayCounter,
                                        paymentConvention, redemption,
                                        issueDate));
        }
SWIGINTERN std::vector<boost::shared_ptr<RateHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__get(std::vector<boost::shared_ptr<RateHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__set(std::vector<boost::shared_ptr<RateHelper > > *self,int i,std::vector<boost::shared_ptr<RateHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::Discount;
using QuantLib::ZeroYield;
using QuantLib::ForwardRate;


using QuantLib::PiecewiseYieldCurve;


typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,BackwardFlat>(
                                                    referenceDate,instruments,
                                                    dayCounter,accuracy,i));
        }
SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,BackwardFlat>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, accuracy, i));
        }
SWIGINTERN std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->dates();
        }
SWIGINTERN std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->times();
        }
SWIGINTERN std::vector<std::pair<Date,Real > > PiecewiseFlatForwardPtr_nodes(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->nodes();
        }

using QuantLib::Settings;

SWIGINTERN Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
SWIGINTERN void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }
SWIGINTERN SwaptionHelperPtr *new_SwaptionHelperPtr__SWIG_0(Period const &maturity,Period const &length,Handle<Quote > const &volatility,IborIndexPtr const &index,Period const &fixedLegTenor,DayCounter const &fixedLegDayCounter,DayCounter const &floatingLegDayCounter,Handle<YieldTermStructure > const &termStructure,bool calibrateVolatility=false){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegTenor,
                                   fixedLegDayCounter,
                                   floatingLegDayCounter,
                                   termStructure,
                                   calibrateVolatility));
        }
SWIGINTERN std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,IborIndexPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
SWIGINTERN std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN std::vector<boost::shared_ptr<CalibrationHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__get(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__set(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

using QuantLib::ShortRateModel;

SWIGINTERN bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_ShortRateModel_Sg__asObservable(Handle<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

    using QuantLib::Vasicek;
    using QuantLib::HullWhite;
    using QuantLib::BlackKarasinski;
    using QuantLib::G2;
    typedef boost::shared_ptr<ShortRateModel> VasicekPtr;
    typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
    typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
    typedef boost::shared_ptr<ShortRateModel> G2Ptr;

SWIGINTERN VasicekPtr *new_VasicekPtr__SWIG_0(Rate r0=0.05,Real a=0.1,Real b=0.05,Real sigma=0.01,Real lambda=0.0){
            return new VasicekPtr(new Vasicek(r0, a, b, sigma, lambda));
        }
SWIGINTERN DiscountFactor VasicekPtr_discount(VasicekPtr const *self,Time t){
            return boost::dynamic_pointer_cast<Vasicek>(*self)->discount(t);
        }
SWIGINTERN HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
            return new HullWhitePtr(
                new HullWhite(termStructure, a, sigma));
        }
SWIGINTERN DiscountFactor HullWhitePtr_discount(HullWhitePtr const *self,Time t){
            return boost::dynamic_pointer_cast<HullWhite>(*self)->discount(t);
        }
SWIGINTERN BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
            return new BlackKarasinskiPtr(
                new BlackKarasinski(termStructure, a, sigma));
        }
SWIGINTERN G2Ptr *new_G2Ptr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
            return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }
SWIGINTERN DiscountFactor G2Ptr_discount(G2Ptr const *self,Time t){
            return boost::dynamic_pointer_cast<G2>(*self)->discount(t);
        }

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;

SWIGINTERN JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                               new JamshidianSwaptionEngine(m,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                       new TreeSwaptionEngine(model,timeSteps,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_2(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                            new TreeSwaptionEngine(model,grid,termStructure));
        }
SWIGINTERN AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                 new AnalyticCapFloorEngine(m,termStructure));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeCapFloorEnginePtr(
                       new TreeCapFloorEngine(model,timeSteps,termStructure));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_2(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeCapFloorEnginePtr(
                            new TreeCapFloorEngine(model,grid,termStructure));
        }
SWIGINTERN G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::GenericSequenceStatistics;

SWIGINTERN void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void Statistics_add__SWIG_3(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::VanillaSwap;
using QuantLib::DiscountingSwapEngine;

typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> VanillaSwapPtr;
typedef boost::shared_ptr<PricingEngine> DiscountingSwapEnginePtr;

SWIGINTERN SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg){
            return new SwapPtr(new Swap(firstLeg, secondLeg));
        }
SWIGINTERN Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
SWIGINTERN Date SwapPtr_maturityDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturityDate();
        }
SWIGINTERN VanillaSwapPtr *new_VanillaSwapPtr(VanillaSwap::Type type,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,IborIndexPtr const &index,Spread spread,DayCounter const &floatingDayCount){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new VanillaSwapPtr(
                    new VanillaSwap(type, nominal,fixedSchedule,fixedRate,
                                    fixedDayCount,floatSchedule,libor,
                                    spread, floatingDayCount));
        }
SWIGINTERN Rate VanillaSwapPtr_fairRate(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)->fairRate();
        }
SWIGINTERN Spread VanillaSwapPtr_fairSpread(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fairSpread();
        }
SWIGINTERN Real VanillaSwapPtr_fixedLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fixedLegBPS();
        }
SWIGINTERN Real VanillaSwapPtr_floatingLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->floatingLegBPS();
        }
SWIGINTERN DiscountingSwapEnginePtr *new_DiscountingSwapEnginePtr(Handle<YieldTermStructure > const &discountCurve){
            return new DiscountingSwapEnginePtr(
                                    new DiscountingSwapEngine(discountCurve));
        }

using QuantLib::CapFloorTermVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_CapFloorTermVolatilityStructure_Sg__isNull(boost::shared_ptr<CapFloorTermVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(Handle<CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::CapFloorTermVolCurve;
typedef boost::shared_ptr<CapFloorTermVolatilityStructure> CapFloorTermVolCurvePtr;

SWIGINTERN CapFloorTermVolCurvePtr *new_CapFloorTermVolCurvePtr__SWIG_0(Date const &referenceDate,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,BusinessDayConvention bdc=Following,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolCurvePtr(
                new CapFloorTermVolCurve(referenceDate,calendar,
                                          lengths,vols,bdc,dc));
        }
SWIGINTERN CapFloorTermVolCurvePtr *new_CapFloorTermVolCurvePtr__SWIG_3(Natural settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,BusinessDayConvention bdc=Following,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolCurvePtr(
                new CapFloorTermVolCurve(settlementDays,calendar,
                                          lengths,vols,bdc,dc));
        }

using QuantLib::Swaption;
using QuantLib::Settlement;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

SWIGINTERN SwaptionPtr *new_SwaptionPtr__SWIG_0(VanillaSwapPtr const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Settlement::Type type=Settlement::Physical){
            boost::shared_ptr<VanillaSwap> swap =
                 boost::dynamic_pointer_cast<VanillaSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,type));
        }

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr__SWIG_0(Handle<YieldTermStructure > const &discountCurve,Handle<Quote > const &vol){
            return new BlackSwaptionEnginePtr(
                                 new BlackSwaptionEngine(discountCurve, vol));
        }
SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr__SWIG_1(Handle<YieldTermStructure > const &discountCurve,Handle<SwaptionVolatilityStructure > const &v){
            return new BlackSwaptionEnginePtr(
                                   new BlackSwaptionEngine(discountCurve, v));
        }

using QuantLib::Surface;
using QuantLib::Domain;

SWIGINTERN bool boost_shared_ptr_Sl_Surface_Sg__isNull(boost::shared_ptr<Surface > *self){
                return !(*self);
            }

using QuantLib::TestSurface;
typedef boost::shared_ptr<Surface> TestSurfacePtr;

SWIGINTERN TestSurfacePtr *new_TestSurfacePtr(){
            return new TestSurfacePtr(new TestSurface);
        }

using QuantLib::ConstantEstimator;
using QuantLib::SimpleLocalEstimator;
using QuantLib::GarmanKlassSigma1;
using QuantLib::ParkinsonSigma;
using QuantLib::GarmanKlassSigma3;
using QuantLib::GarmanKlassSigma4;
using QuantLib::GarmanKlassSigma5;
using QuantLib::GarmanKlassSigma6;


using QuantLib::InterpolatedZeroCurve;


typedef boost::shared_ptr<YieldTermStructure> ZeroCurvePtr;

SWIGINTERN ZeroCurvePtr *new_ZeroCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<Rate > const &yields,DayCounter const &dayCounter,Linear const &i=Linear()){
            return new ZeroCurvePtr(
                new InterpolatedZeroCurve<Linear>(dates,yields,
                                                        dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &ZeroCurvePtr_dates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector<Rate > const &ZeroCurvePtr_zeroRates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector<std::pair<Date,Rate > > ZeroCurvePtr_nodes(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->nodes();
        }

using QuantLib::DiscreteGeometricASO;


// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;

SWIGINTERN std::vector<Handle<YieldTermStructure > >::const_reference std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__get(std::vector<Handle<YieldTermStructure > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__set(std::vector<Handle<YieldTermStructure > > *self,int i,std::vector<Handle<YieldTermStructure > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector<Handle<BlackVolTermStructure > >::const_reference std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__get(std::vector<Handle<BlackVolTermStructure > > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__set(std::vector<Handle<BlackVolTermStructure > > *self,int i,std::vector<Handle<BlackVolTermStructure > >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Period *)new Period();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  {
    try {
      result = (Period *)new Period(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Frequency arg1 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Frequency)jarg1; 
  {
    try {
      result = (Period *)new Period(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1length(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (Integer)((Period const *)arg1)->length();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1units(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  TimeUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (TimeUnit)((Period const *)arg1)->units();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Period_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  Frequency result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = (Frequency)((Period const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Period_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Period *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Period *)new_Period__SWIG_3((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = Period___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Period_1repr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      result = Period___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Period(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Period *arg1 = (Period *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Period **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<Period >::size_type arg1 ;
  std::vector<Period > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<Period >::size_type)jarg1; 
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Period > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  {
    try {
      result = ((std::vector<Period > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  {
    try {
      result = ((std::vector<Period > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  arg2 = (std::vector<Period >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<Period > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  arg2 = *(std::vector<Period >::value_type **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Period >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<Period >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<Period >::const_reference _result_ref = std_vector_Sl_Period_Sg__get(arg1,arg2);
          result = (std::vector<Period >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Period >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_PeriodVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector<Period > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector<Period >::value_type **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Period >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__set(arg1,arg2,(Period const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<Period > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Date *)new Date();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  {
    try {
      result = (Date *)new Date(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  BigInteger arg1 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (BigInteger)jarg1; 
  {
    try {
      result = (Date *)new Date(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Weekday result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Weekday)((Date const *)arg1)->weekday();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfMonth();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1dayOfYear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfYear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1month(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Month result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Month)((Date const *)arg1)->month();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1year(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Year result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Year)((Date const *)arg1)->year();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1serialNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (BigInteger)((Date const *)arg1)->serialNumber();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isLeap(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  Year arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Year)jarg1; 
  {
    try {
      result = (bool)Date::isLeap(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1minDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::minDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1maxDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1todaysDate(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Date::todaysDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1endOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = Date::endOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Date_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Date::isEndOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nextWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Weekday arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = Date::nextWeekday((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1nthWeekday(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Size arg1 ;
  Weekday arg2 ;
  Month arg3 ;
  Year arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Weekday)jarg2; 
  arg3 = (Month)jarg3; 
  arg4 = (Year)jarg4; 
  {
    try {
      result = Date::nthWeekday(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator +(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  BigInteger arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  arg2 = (BigInteger)jarg2; 
  {
    try {
      result = ((Date const *)arg1)->operator -(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1add_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1; 
  arg2 = *(Period **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator +((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Date_1subtract_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Period *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1; 
  arg2 = *(Period **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Date const *)arg1)->operator -((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Date_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Date_1weekdayNumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = (Integer)Date_weekdayNumber(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Date_1ISO(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      result = Date_ISO(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Date(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Date *arg1 = (Date *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Date **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parse(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = DateParser::parse((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateParser_1parseISO(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = DateParser::parseISO((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  DateParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (DateParser *)new DateParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DateParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DateParser *arg1 = (DateParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DateParser **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_PeriodParser_1parse(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Period result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = PeriodParser::parse((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Period **)&jresult = new Period((Period &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PeriodParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  PeriodParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (PeriodParser *)new PeriodParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(PeriodParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PeriodParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  PeriodParser *arg1 = (PeriodParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(PeriodParser **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DateVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<Date >::size_type arg1 ;
  std::vector<Date > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<Date >::size_type)jarg1; 
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Date > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  {
    try {
      result = ((std::vector<Date > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  {
    try {
      result = ((std::vector<Date > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  arg2 = (std::vector<Date >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<Date > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  arg2 = *(std::vector<Date >::value_type **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Date >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<Date >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<Date >::const_reference _result_ref = std_vector_Sl_Date_Sg__get(arg1,arg2);
          result = (std::vector<Date >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Date >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DateVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector<Date > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector<Date >::value_type **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Date >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__set(arg1,arg2,(Date const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DateVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<Date > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1F_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::F;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1G_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::G;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1H_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::H;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1J_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::J;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1K_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::K;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1M_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::M;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1N_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::N;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1Q_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::Q;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1U_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::U;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1V_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::V;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1X_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::X;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IMM_1Z_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  IMM::Month result;
  
  (void)jenv;
  (void)jcls;
  result = (IMM::Month)IMM::Z;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Date *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMcode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IMM_1isIMMcode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  std::string *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (bool)IMM::isIMMcode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1date_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::date((std::string const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1date_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::date((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = IMM::nextDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextDate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::nextDate((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Date *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_12(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = IMM::nextCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_IMM_1nextCode_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = IMM::nextCode((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IMM(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  IMM *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (IMM *)new IMM();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(IMM **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IMM(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  IMM *arg1 = (IMM *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(IMM **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<int > *)new std::vector<int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IntVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<int >::size_type arg1 ;
  std::vector<int > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<int >::size_type)jarg1; 
  {
    try {
      result = (std::vector<int > *)new std::vector<int >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<int > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  {
    try {
      result = ((std::vector<int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  {
    try {
      result = ((std::vector<int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  arg2 = (std::vector<int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<int > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::value_type *arg2 = 0 ;
  std::vector<int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  temp2 = (std::vector<int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector<int >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<int >::const_reference _result_ref = std_vector_Sl_int_Sg__get(arg1,arg2);
          result = (std::vector<int >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_IntVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int >::value_type *arg3 = 0 ;
  std::vector<int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<int > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector<int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__set(arg1,arg2,(int const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IntVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<int > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<double > *)new std::vector<double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DoubleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<double >::size_type arg1 ;
  std::vector<double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<double >::size_type)jarg1; 
  {
    try {
      result = (std::vector<double > *)new std::vector<double >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  {
    try {
      result = ((std::vector<double > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  {
    try {
      result = ((std::vector<double > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  arg2 = (std::vector<double >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<double > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::value_type *arg2 = 0 ;
  std::vector<double >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  temp2 = (std::vector<double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector<double >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<double >::const_reference _result_ref = std_vector_Sl_double_Sg__get(arg1,arg2);
          result = (std::vector<double >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_DoubleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double >::value_type *arg3 = 0 ;
  std::vector<double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<double > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector<double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__set(arg1,arg2,(double const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DoubleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<double > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<std::string > *)new std::vector<std::string >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1StrVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<std::string >::size_type arg1 ;
  std::vector<std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<std::string >::size_type)jarg1; 
  {
    try {
      result = (std::vector<std::string > *)new std::vector<std::string >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector<std::string > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector<std::string > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  arg2 = (std::vector<std::string >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<std::string > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->push_back((std::vector<std::string >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<std::string >::const_reference _result_ref = std_vector_Sl_std_string_Sg__get(arg1,arg2);
          result = (std::vector<std::string >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_StrVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  arg2 = (int)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null std::string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__set(arg1,arg2,(std::string const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1StrVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<std::string > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair<Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair<Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  Date arg1 ;
  double arg2 ;
  std::pair<Date,double > *result = 0 ;
  Date *argp1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(Date **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair<Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodePair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair<Date,double > *arg1 = 0 ;
  std::pair<Date,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair<Date,double > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair<Date,double > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >((std::pair<Date,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::pair<Date,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  Date *arg2 = (Date *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::pair<Date,double > **)&jarg1; 
  arg2 = *(Date **)&jarg2; 
  if (arg1) (arg1)->first = *arg2;
  
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  Date *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair<Date,double > **)&jarg1; 
  result = (Date *)& ((arg1)->first);
  *(Date **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair<Date,double > **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
  
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_NodePair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair<Date,double > **)&jarg1; 
  result = (double) ((arg1)->second);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NodePair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair<Date,double > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<std::pair<Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NodeVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<std::pair<Date,double > >::size_type arg1 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<std::pair<Date,double > >::size_type)jarg1; 
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<std::pair<Date,double > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  {
    try {
      result = ((std::vector<std::pair<Date,double > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  {
    try {
      result = ((std::vector<std::pair<Date,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<std::pair<Date,double > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  arg2 = *(std::vector<std::pair<Date,double > >::value_type **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<std::pair<Date,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<std::pair<Date,double > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<std::pair<Date,double > >::const_reference _result_ref = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__get(arg1,arg2);
          result = (std::vector<std::pair<Date,double > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<std::pair<Date,double > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_NodeVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector<std::pair<Date,double > >::value_type **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<std::pair<Date,double > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__set(arg1,arg2,(std::pair<Date,double > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NodeVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<std::pair<Date,double > > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI__1Exercise_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      result = (Exercise::Type)((Exercise const *)arg1)->type();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI__1Exercise_1dates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Exercise *arg1 = (Exercise *) 0 ;
  std::vector<Date > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      result = ((Exercise const *)arg1)->dates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Date > **)&jresult = new std::vector<Date >((std::vector<Date > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1_1Exercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Exercise *arg1 = (Exercise *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Exercise **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  Exercise *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Exercise > **)&jarg1; 
  {
    try {
      result = (Exercise *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Exercise **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Exercise > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Exercise_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1American_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  enum Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  result = (enum Exercise::Type)Exercise::American;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1Bermudan_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  enum Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  result = (enum Exercise::Type)Exercise::Bermudan;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1European_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  enum Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  result = (enum Exercise::Type)Exercise::European;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Exercise(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<Exercise > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<Exercise > *)new boost::shared_ptr<Exercise >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Exercise > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Exercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<Exercise > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  Exercise::Type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Exercise > **)&jarg1; 
  {
    try {
      result = (Exercise::Type)(*arg1)->type();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Exercise_1dates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  std::vector<Date > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Exercise > **)&jarg1; 
  {
    try {
      result = (*arg1)->dates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Date > **)&jresult = new std::vector<Date >((std::vector<Date > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EuropeanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  EuropeanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (EuropeanExercisePtr *)new_EuropeanExercisePtr((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(EuropeanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EuropeanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  EuropeanExercisePtr *arg1 = (EuropeanExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(EuropeanExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AmericanExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  AmericanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (AmericanExercisePtr *)new_AmericanExercisePtr__SWIG_0((Date const &)*arg1,(Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(AmericanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AmericanExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  AmericanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (AmericanExercisePtr *)new_AmericanExercisePtr__SWIG_0((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(AmericanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1AmericanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  AmericanExercisePtr *arg1 = (AmericanExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(AmericanExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BermudanExercise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  std::vector<Date > *arg1 = 0 ;
  bool arg2 ;
  BermudanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Date > const & reference is null");
    return 0;
  } 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (BermudanExercisePtr *)new_BermudanExercisePtr__SWIG_0((std::vector<Date > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BermudanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BermudanExercise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Date > *arg1 = 0 ;
  BermudanExercisePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Date > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Date > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BermudanExercisePtr *)new_BermudanExercisePtr__SWIG_0((std::vector<Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BermudanExercisePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BermudanExercise(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BermudanExercisePtr *arg1 = (BermudanExercisePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BermudanExercisePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Observable_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  Observable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Observable > **)&jarg1; 
  {
    try {
      result = (Observable *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Observable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Observable_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Observable > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Observable(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<Observable > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Observable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<Observable > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Array *)new Array();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  Size arg1 ;
  Real arg2 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Array *)new Array(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  Size arg1 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  {
    try {
      result = (Array *)new Array(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Array_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Array *)new Array((Array const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Array_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      result = ((Array const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Array_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      result = Array___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Array_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Real)Array_get(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Array_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Array *arg1 = (Array *) 0 ;
  Size arg2 ;
  Real arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      Array_set(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Array(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Array *arg1 = (Array *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Array **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1xSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->xSize();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1ySize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->ySize();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Size arg2 ;
  DefaultLexicographicalView *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array & reference is null");
    return 0;
  } 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (DefaultLexicographicalView *)new_DefaultLexicographicalView(*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DefaultLexicographicalView **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_LexicographicalView_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      result = DefaultLexicographicalView___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LexicographicalView(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DefaultLexicographicalView **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Matrix *)new Matrix();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  Size arg1 ;
  Size arg2 ;
  Real arg3 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  Size arg1 ;
  Size arg2 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Matrix_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Matrix *)new Matrix((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1rows(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->rows();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1columns(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->columns();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      result = Matrix___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  {
    try {
      result = (Real)Matrix_get(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Matrix_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jdouble jarg4) {
  Matrix *arg1 = (Matrix *) 0 ;
  Size arg2 ;
  Size arg3 ;
  Real arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Size)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      Matrix_set(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Matrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Matrix *arg1 = (Matrix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Matrix **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SalvagingAlgorithm *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SalvagingAlgorithm **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SalvagingAlgorithm(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SalvagingAlgorithm **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_transpose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = transpose((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_outerProduct(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_pseudoSqrt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  SalvagingAlgorithm::Type arg2 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  arg2 = (SalvagingAlgorithm::Type)jarg2; 
  {
    try {
      result = pseudoSqrt((Matrix const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Matrix *arg1 = 0 ;
  SVD *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Matrix **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SVD *)new SVD((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SVD **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1U(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      {
        Matrix const &_result_ref = ((SVD const *)arg1)->U();
        result = (Matrix *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1V(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      {
        Matrix const &_result_ref = ((SVD const *)arg1)->V();
        result = (Matrix *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1S(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      result = ((SVD const *)arg1)->S();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Matrix **)&jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_SVD_1singularValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  SVD *arg1 = (SVD *) 0 ;
  Array *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      {
        Array const &_result_ref = ((SVD const *)arg1)->singularValues();
        result = (Array *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Array **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SVD(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SVD *arg1 = (SVD *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SVD **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Quote_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  Quote *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1; 
  {
    try {
      result = (Quote *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Quote **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Quote_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Quote_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Quote(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Quote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Quote_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Quote > *arg1 = 0 ;
  Handle<Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle<Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle<Quote > *)new Handle<Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Quote > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<Quote > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Quote > **)&jresult = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<Quote > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<Quote > **)&jarg1; 
  {
    try {
      result = Handle_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle<Quote > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandle_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<Quote > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<Quote > *arg1 = 0 ;
  RelinkableHandle<Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<Quote > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RelinkableHandle<Quote > *)new RelinkableHandle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RelinkableHandle<Quote > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (RelinkableHandle<Quote > *)new RelinkableHandle<Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<Quote > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
  boost::shared_ptr<Quote > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RelinkableHandle<Quote > **)&jarg1; 
  arg2 = *(boost::shared_ptr<Quote > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<Quote > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RelinkableHandle<Quote > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleQuote(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  Real arg1 ;
  SimpleQuotePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Real)jarg1; 
  {
    try {
      result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SimpleQuotePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_SimpleQuote_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  Real arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SimpleQuotePtr **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      SimpleQuotePtr_setValue(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleQuote(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SimpleQuotePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<boost::shared_ptr<Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type arg1 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<boost::shared_ptr<Quote > >::size_type)jarg1; 
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<boost::shared_ptr<Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector<boost::shared_ptr<Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  arg2 = *(std::vector<boost::shared_ptr<Quote > >::value_type **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<boost::shared_ptr<Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<boost::shared_ptr<Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<boost::shared_ptr<Quote > >::const_reference _result_ref = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__get(arg1,arg2);
          result = (std::vector<boost::shared_ptr<Quote > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<boost::shared_ptr<Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector<boost::shared_ptr<Quote > >::value_type **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<boost::shared_ptr<Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<boost::shared_ptr<Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Handle<Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1QuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<Handle<Quote > >::size_type arg1 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<Handle<Quote > >::size_type)jarg1; 
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Handle<Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector<Handle<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector<Handle<Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  arg2 = (std::vector<Handle<Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<Handle<Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  arg2 = *(std::vector<Handle<Quote > >::value_type **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Handle<Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<Handle<Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<Handle<Quote > >::const_reference _result_ref = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__get(arg1,arg2);
          result = (std::vector<Handle<Quote > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<Handle<Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_QuoteHandleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector<Handle<Quote > >::value_type **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<Handle<Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(arg1,arg2,(Handle<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1QuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<Handle<Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<RelinkableHandle<Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableQuoteHandleVector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector<RelinkableHandle<Quote > >::size_type arg1 ;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector<RelinkableHandle<Quote > >::size_type)jarg1; 
  {
    try {
      result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<RelinkableHandle<Quote > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  std::vector<RelinkableHandle<Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector<RelinkableHandle<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  std::vector<RelinkableHandle<Quote > >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  {
    try {
      result = ((std::vector<RelinkableHandle<Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  std::vector<RelinkableHandle<Quote > >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  arg2 = (std::vector<RelinkableHandle<Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector<RelinkableHandle<Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  std::vector<RelinkableHandle<Quote > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  arg2 = *(std::vector<RelinkableHandle<Quote > >::value_type **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<RelinkableHandle<Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<RelinkableHandle<Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<RelinkableHandle<Quote > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<RelinkableHandle<Quote > >::const_reference _result_ref = std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__get(arg1,arg2);
          result = (std::vector<RelinkableHandle<Quote > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(std::vector<RelinkableHandle<Quote > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableQuoteHandleVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<RelinkableHandle<Quote > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector<RelinkableHandle<Quote > >::value_type **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector<RelinkableHandle<Quote > >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__set(arg1,arg2,(RelinkableHandle<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableQuoteHandleVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector<RelinkableHandle<Quote > > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_nullInt(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (int)nullInt();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_nullDouble(JNIEnv *jenv, jclass jcls) {
  jdouble jresult = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (double)nullDouble();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1dayCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jdouble jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg5 = *(Date **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jdouble jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(Date **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1yearFraction_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DayCounter **)&jarg1; 
  {
    try {
      result = DayCounter___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  DayCounter *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)DayCounter___eq__(arg1,(DayCounter const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_DayCounter_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  DayCounter *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(DayCounter **)&jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)DayCounter___ne__(arg1,(DayCounter const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DayCounter *arg1 = (DayCounter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DayCounter **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual360(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Actual360 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Actual360 *)new QuantLib::Actual360();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Actual360 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Actual360(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Actual360 **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Actual365Fixed(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Actual365Fixed *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Actual365Fixed **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Actual365Fixed(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Actual365Fixed **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Thirty360_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Thirty360::Convention arg1 ;
  QuantLib::Thirty360 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Thirty360::Convention)jarg1; 
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Thirty360 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Thirty360_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Thirty360 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Thirty360 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Thirty360(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Thirty360 **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::ActualActual::Convention arg1 ;
  QuantLib::ActualActual *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::ActualActual::Convention)jarg1; 
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ActualActual **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ActualActual_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ActualActual *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ActualActual **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ActualActual(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ActualActual **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1OneDayCounter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::OneDayCounter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::OneDayCounter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1OneDayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::OneDayCounter **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SimpleDayCounter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SimpleDayCounter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SimpleDayCounter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SimpleDayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SimpleDayCounter **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  InterestRate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (InterestRate *)new InterestRate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Rate)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1InterestRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  InterestRate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Rate)jarg1; 
  arg2 = *(DayCounter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1rate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Rate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = (Rate)((InterestRate const *)arg1)->rate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = ((InterestRate const *)arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compounding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Compounding result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = (Compounding)((InterestRate const *)arg1)->compounding();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1frequency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Frequency result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = (Frequency)((InterestRate const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1discountFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date arg2 ;
  Date arg3 ;
  DiscountFactor result;
  Date *argp2 ;
  Date *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(InterestRate **)&jarg1; 
  argp2 = *(Date **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg2 = *argp2; 
  argp3 = *(Date **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg3 = *argp3; 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1compoundFactor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date arg2 ;
  Date arg3 ;
  Real result;
  Date *argp2 ;
  Date *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(InterestRate **)&jarg1; 
  argp2 = *(Date **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg2 = *argp2; 
  argp3 = *(Date **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null Date");
    return 0;
  }
  arg3 = *argp3; 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Real arg1 ;
  Time arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (Real)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Real arg1 ;
  Time arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (Real)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  Real arg1 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (Real)jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1impliedRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Real arg1 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (Real)jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1equivalentRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(InterestRate **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_InterestRate_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      result = InterestRate___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1InterestRate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  InterestRate *arg1 = (InterestRate *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(InterestRate **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isBusinessDay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1isEndOfMonth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1addHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->addHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1removeHoliday(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->removeHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1adjust_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  bool arg6 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  bool arg5 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1advance_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Period **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Period const & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  bool arg5 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1businessDaysBetween_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      result = Calendar___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Calendar *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Calendar___eq__(arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Calendar_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Calendar *arg1 = (Calendar *) 0 ;
  Calendar *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Calendar___ne__(arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Calendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Calendar *arg1 = (Calendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Calendar **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Argentina_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Argentina::Market arg1 ;
  QuantLib::Argentina *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Argentina::Market)jarg1; 
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Argentina **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Argentina_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Argentina *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Argentina **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Argentina(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Argentina *arg1 = (QuantLib::Argentina *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Argentina **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Australia(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Australia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Australia *)new QuantLib::Australia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Australia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Australia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Australia *arg1 = (QuantLib::Australia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Australia **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Brazil_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Brazil::Market arg1 ;
  QuantLib::Brazil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Brazil::Market)jarg1; 
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Brazil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Brazil_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Brazil *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Brazil **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Brazil(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Brazil *arg1 = (QuantLib::Brazil *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Brazil **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Canada_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Canada::Market arg1 ;
  QuantLib::Canada *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Canada::Market)jarg1; 
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Canada **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Canada_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Canada *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Canada **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Canada(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Canada *arg1 = (QuantLib::Canada *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Canada **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1China(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::China *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::China *)new QuantLib::China();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::China **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1China(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::China *arg1 = (QuantLib::China *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::China **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CzechRepublic_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::CzechRepublic::Market arg1 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::CzechRepublic::Market)jarg1; 
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CzechRepublic **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CzechRepublic_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CzechRepublic **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CzechRepublic(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CzechRepublic *arg1 = (QuantLib::CzechRepublic *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CzechRepublic **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Denmark(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Denmark *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Denmark *)new QuantLib::Denmark();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Denmark **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Denmark(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Denmark *arg1 = (QuantLib::Denmark *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Denmark **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Finland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Finland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Finland *)new QuantLib::Finland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Finland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Finland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Finland *arg1 = (QuantLib::Finland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Finland **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Germany::Market arg1 ;
  QuantLib::Germany *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Germany::Market)jarg1; 
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Germany **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Germany_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Germany *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Germany **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Germany(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Germany **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::HongKong::Market arg1 ;
  QuantLib::HongKong *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::HongKong::Market)jarg1; 
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HongKong **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HongKong_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::HongKong *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HongKong **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HongKong(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::HongKong **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Hungary(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Hungary *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Hungary *)new QuantLib::Hungary();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Hungary **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Hungary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Hungary *arg1 = (QuantLib::Hungary *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Hungary **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Iceland_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Iceland::Market arg1 ;
  QuantLib::Iceland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Iceland::Market)jarg1; 
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Iceland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Iceland_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Iceland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Iceland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Iceland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Iceland *arg1 = (QuantLib::Iceland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Iceland **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1India_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::India::Market arg1 ;
  QuantLib::India *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::India::Market)jarg1; 
  {
    try {
      result = (QuantLib::India *)new QuantLib::India(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::India **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1India_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::India *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::India *)new QuantLib::India();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::India **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1India(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::India *arg1 = (QuantLib::India *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::India **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Indonesia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Indonesia::Market arg1 ;
  QuantLib::Indonesia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Indonesia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Indonesia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Indonesia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Indonesia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Indonesia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Indonesia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Indonesia *arg1 = (QuantLib::Indonesia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Indonesia **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Italy::Market arg1 ;
  QuantLib::Italy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Italy::Market)jarg1; 
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Italy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Italy_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Italy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Italy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Italy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Italy **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Japan(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Japan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Japan *)new QuantLib::Japan();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Japan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Japan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Japan *arg1 = (QuantLib::Japan *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Japan **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Mexico_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Mexico::Market arg1 ;
  QuantLib::Mexico *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Mexico::Market)jarg1; 
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Mexico **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Mexico_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Mexico *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Mexico **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Mexico(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Mexico *arg1 = (QuantLib::Mexico *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Mexico **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NewZealand(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NewZealand *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NewZealand *)new QuantLib::NewZealand();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NewZealand **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NewZealand(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NewZealand *arg1 = (QuantLib::NewZealand *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NewZealand **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Norway(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Norway *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Norway *)new QuantLib::Norway();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Norway **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Norway(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Norway *arg1 = (QuantLib::Norway *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Norway **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Poland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Poland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Poland *)new QuantLib::Poland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Poland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Poland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Poland *arg1 = (QuantLib::Poland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Poland **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SaudiArabia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::SaudiArabia::Market arg1 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::SaudiArabia::Market)jarg1; 
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SaudiArabia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SaudiArabia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SaudiArabia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SaudiArabia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SaudiArabia *arg1 = (QuantLib::SaudiArabia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SaudiArabia **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Singapore::Market arg1 ;
  QuantLib::Singapore *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Singapore::Market)jarg1; 
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Singapore **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Singapore_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Singapore *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Singapore **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Singapore(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Singapore **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Slovakia_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Slovakia::Market arg1 ;
  QuantLib::Slovakia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Slovakia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Slovakia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Slovakia_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Slovakia *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Slovakia **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Slovakia(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Slovakia *arg1 = (QuantLib::Slovakia *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Slovakia **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthAfrica(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SouthAfrica *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SouthAfrica *)new QuantLib::SouthAfrica();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthAfrica **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SouthAfrica(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SouthAfrica *arg1 = (QuantLib::SouthAfrica *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SouthAfrica **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthKorea_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::SouthKorea::Market arg1 ;
  QuantLib::SouthKorea *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::SouthKorea::Market)jarg1; 
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthKorea **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SouthKorea_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SouthKorea *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SouthKorea **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SouthKorea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SouthKorea *arg1 = (QuantLib::SouthKorea *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SouthKorea **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Sweden(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Sweden *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Sweden *)new QuantLib::Sweden();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Sweden **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Sweden(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Sweden *arg1 = (QuantLib::Sweden *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Sweden **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Switzerland(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Switzerland *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Switzerland *)new QuantLib::Switzerland();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Switzerland **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Switzerland(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Switzerland *arg1 = (QuantLib::Switzerland *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Switzerland **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Taiwan_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Taiwan::Market arg1 ;
  QuantLib::Taiwan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Taiwan::Market)jarg1; 
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Taiwan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Taiwan_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Taiwan *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Taiwan **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Taiwan(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Taiwan **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TARGET(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::TARGET *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::TARGET *)new QuantLib::TARGET();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::TARGET **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TARGET(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::TARGET **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Turkey(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Turkey *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Turkey *)new QuantLib::Turkey();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Turkey **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Turkey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Turkey *arg1 = (QuantLib::Turkey *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Turkey **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Ukraine_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::Ukraine::Market arg1 ;
  QuantLib::Ukraine *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::Ukraine::Market)jarg1; 
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Ukraine **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Ukraine_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::Ukraine *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::Ukraine **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Ukraine(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::Ukraine *arg1 = (QuantLib::Ukraine *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::Ukraine **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedKingdom_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::UnitedKingdom::Market arg1 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::UnitedKingdom::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedKingdom **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedKingdom_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedKingdom **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnitedKingdom(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::UnitedKingdom **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedStates_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  QuantLib::UnitedStates::Market arg1 ;
  QuantLib::UnitedStates *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (QuantLib::UnitedStates::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedStates **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UnitedStates_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::UnitedStates *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::UnitedStates **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UnitedStates(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::UnitedStates **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NullCalendar(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NullCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NullCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NullCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NullCalendar **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  JointCalendarRule arg3 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = (JointCalendarRule)jarg3; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Calendar **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  JointCalendarRule arg4 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg4 = (JointCalendarRule)jarg4; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Calendar **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  JointCalendarRule arg5 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Calendar **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg4 = *(Calendar **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg5 = (JointCalendarRule)jarg5; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JointCalendar_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Calendar **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Calendar **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg4 = *(Calendar **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JointCalendar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JointCalendar(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::JointCalendar **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Rounding(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Rounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Rounding *)new Rounding();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Rounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_Rounding_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Rounding *arg1 = (Rounding *) 0 ;
  Decimal arg2 ;
  Decimal result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Rounding **)&jarg1; 
  arg2 = (Decimal)jarg2; 
  {
    try {
      result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Rounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Rounding *arg1 = (Rounding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Rounding **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UpRounding_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Integer arg2 ;
  UpRounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (UpRounding *)new UpRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(UpRounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1UpRounding_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Integer arg1 ;
  UpRounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (UpRounding *)new UpRounding(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(UpRounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1UpRounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  UpRounding *arg1 = (UpRounding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(UpRounding **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DownRounding_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Integer arg2 ;
  DownRounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (DownRounding *)new DownRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DownRounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DownRounding_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Integer arg1 ;
  DownRounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (DownRounding *)new DownRounding(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DownRounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DownRounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  DownRounding *arg1 = (DownRounding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DownRounding **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ClosestRounding_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Integer arg2 ;
  ClosestRounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ClosestRounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ClosestRounding_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Integer arg1 ;
  ClosestRounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (ClosestRounding *)new ClosestRounding(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ClosestRounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ClosestRounding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ClosestRounding *arg1 = (ClosestRounding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ClosestRounding **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CeilingTruncation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Integer arg2 ;
  CeilingTruncation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(CeilingTruncation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CeilingTruncation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Integer arg1 ;
  CeilingTruncation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (CeilingTruncation *)new CeilingTruncation(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(CeilingTruncation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CeilingTruncation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CeilingTruncation *arg1 = (CeilingTruncation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CeilingTruncation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FloorTruncation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Integer arg2 ;
  FloorTruncation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FloorTruncation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FloorTruncation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Integer arg1 ;
  FloorTruncation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (FloorTruncation *)new FloorTruncation(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FloorTruncation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FloorTruncation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  FloorTruncation *arg1 = (FloorTruncation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FloorTruncation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->name();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1code(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->code();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Currency_1numericCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      result = (Integer)((Currency const *)arg1)->numericCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1symbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->symbol();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1fractionSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_quantlib_QuantLibJNI_Currency_1fractionsPerUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  Integer result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Currency_1rounding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  Rounding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      {
        Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
        result = (Rounding *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Rounding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1format(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      result = ((Currency const *)arg1)->format();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Currency_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      result = (bool)((Currency const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_Currency_1triangulationCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  Currency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      {
        Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
        result = (Currency *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Currency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_quantlib_QuantLibJNI_Currency_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      result = Currency___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Currency_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  Currency *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Currency **)&jarg1; 
  arg2 = *(Currency **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Currency const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Currency___eq__(arg1,(Currency const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_Currency_1unEquals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Currency *arg1 = (Currency *) 0 ;
  Currency *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Currency **)&jarg1; 
  arg2 = *(Currency **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Currency const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Currency___ne__(arg1,(Currency const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Currency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Currency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Currency *)new Currency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Currency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Currency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Currency *arg1 = (Currency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Currency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ARSCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ARSCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ARSCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ARSCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ARSCurrency *arg1 = (QuantLib::ARSCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ARSCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ATSCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ATSCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ATSCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ATSCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ATSCurrency *arg1 = (QuantLib::ATSCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ATSCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1AUDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::AUDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::AUDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1AUDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::AUDCurrency *arg1 = (QuantLib::AUDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::AUDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BDTCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::BDTCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::BDTCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BDTCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::BDTCurrency *arg1 = (QuantLib::BDTCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::BDTCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BEFCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::BEFCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::BEFCurrency *)new QuantLib::BEFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::BEFCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BEFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::BEFCurrency *arg1 = (QuantLib::BEFCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::BEFCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BGLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::BGLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::BGLCurrency *)new QuantLib::BGLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::BGLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BGLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::BGLCurrency *arg1 = (QuantLib::BGLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::BGLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BRLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::BRLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::BRLCurrency *)new QuantLib::BRLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::BRLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BRLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::BRLCurrency *arg1 = (QuantLib::BRLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::BRLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BYRCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::BYRCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::BYRCurrency *)new QuantLib::BYRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::BYRCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BYRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::BYRCurrency *arg1 = (QuantLib::BYRCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::BYRCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CADCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CADCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CADCurrency *)new QuantLib::CADCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CADCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CADCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CADCurrency *arg1 = (QuantLib::CADCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CADCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CHFCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CHFCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CHFCurrency *)new QuantLib::CHFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CHFCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CHFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CHFCurrency *arg1 = (QuantLib::CHFCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CHFCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CLPCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CLPCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CLPCurrency *)new QuantLib::CLPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CLPCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CLPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CLPCurrency *arg1 = (QuantLib::CLPCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CLPCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CNYCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CNYCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CNYCurrency *)new QuantLib::CNYCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CNYCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CNYCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CNYCurrency *arg1 = (QuantLib::CNYCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CNYCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1COPCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::COPCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::COPCurrency *)new QuantLib::COPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::COPCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1COPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::COPCurrency *arg1 = (QuantLib::COPCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::COPCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CYPCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CYPCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CYPCurrency *)new QuantLib::CYPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CYPCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CYPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CYPCurrency *arg1 = (QuantLib::CYPCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CYPCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CZKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::CZKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::CZKCurrency *)new QuantLib::CZKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::CZKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CZKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::CZKCurrency *arg1 = (QuantLib::CZKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::CZKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DEMCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::DEMCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::DEMCurrency *)new QuantLib::DEMCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::DEMCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DEMCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::DEMCurrency *arg1 = (QuantLib::DEMCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::DEMCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1DKKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::DKKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::DKKCurrency *)new QuantLib::DKKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::DKKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1DKKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::DKKCurrency *arg1 = (QuantLib::DKKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::DKKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EEKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::EEKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::EEKCurrency *)new QuantLib::EEKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::EEKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EEKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::EEKCurrency *arg1 = (QuantLib::EEKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::EEKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ESPCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ESPCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ESPCurrency *)new QuantLib::ESPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ESPCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ESPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ESPCurrency *arg1 = (QuantLib::ESPCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ESPCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1EURCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::EURCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::EURCurrency *)new QuantLib::EURCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::EURCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1EURCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::EURCurrency *arg1 = (QuantLib::EURCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::EURCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FIMCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::FIMCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::FIMCurrency *)new QuantLib::FIMCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::FIMCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FIMCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::FIMCurrency *arg1 = (QuantLib::FIMCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::FIMCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FRFCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::FRFCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::FRFCurrency *)new QuantLib::FRFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::FRFCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FRFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::FRFCurrency *arg1 = (QuantLib::FRFCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::FRFCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GBPCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::GBPCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::GBPCurrency *)new QuantLib::GBPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::GBPCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1GBPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::GBPCurrency *arg1 = (QuantLib::GBPCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::GBPCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1GRDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::GRDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::GRDCurrency *)new QuantLib::GRDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::GRDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1GRDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::GRDCurrency *arg1 = (QuantLib::GRDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::GRDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HKDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::HKDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::HKDCurrency *)new QuantLib::HKDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HKDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HKDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::HKDCurrency *arg1 = (QuantLib::HKDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::HKDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1HUFCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::HUFCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::HUFCurrency *)new QuantLib::HUFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::HUFCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1HUFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::HUFCurrency *arg1 = (QuantLib::HUFCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::HUFCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IEPCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::IEPCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::IEPCurrency *)new QuantLib::IEPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::IEPCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IEPCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::IEPCurrency *arg1 = (QuantLib::IEPCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::IEPCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ILSCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ILSCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ILSCurrency *)new QuantLib::ILSCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ILSCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ILSCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ILSCurrency *arg1 = (QuantLib::ILSCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ILSCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1INRCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::INRCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::INRCurrency *)new QuantLib::INRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::INRCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1INRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::INRCurrency *arg1 = (QuantLib::INRCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::INRCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IQDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::IQDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::IQDCurrency *)new QuantLib::IQDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::IQDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IQDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::IQDCurrency *arg1 = (QuantLib::IQDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::IQDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1IRRCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::IRRCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::IRRCurrency *)new QuantLib::IRRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::IRRCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1IRRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::IRRCurrency *arg1 = (QuantLib::IRRCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::IRRCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ISKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ISKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ISKCurrency *)new QuantLib::ISKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ISKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ISKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ISKCurrency *arg1 = (QuantLib::ISKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ISKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ITLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ITLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ITLCurrency *)new QuantLib::ITLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ITLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ITLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ITLCurrency *arg1 = (QuantLib::ITLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ITLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1JPYCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::JPYCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::JPYCurrency *)new QuantLib::JPYCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::JPYCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1JPYCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::JPYCurrency *arg1 = (QuantLib::JPYCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::JPYCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1KRWCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::KRWCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::KRWCurrency *)new QuantLib::KRWCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::KRWCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1KRWCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::KRWCurrency *arg1 = (QuantLib::KRWCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::KRWCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1KWDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::KWDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::KWDCurrency *)new QuantLib::KWDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::KWDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1KWDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::KWDCurrency *arg1 = (QuantLib::KWDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::KWDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LTLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::LTLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::LTLCurrency *)new QuantLib::LTLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::LTLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LTLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::LTLCurrency *arg1 = (QuantLib::LTLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::LTLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LUFCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::LUFCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::LUFCurrency *)new QuantLib::LUFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::LUFCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LUFCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::LUFCurrency *arg1 = (QuantLib::LUFCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::LUFCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LVLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::LVLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::LVLCurrency *)new QuantLib::LVLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::LVLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LVLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::LVLCurrency *arg1 = (QuantLib::LVLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::LVLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MTLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::MTLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::MTLCurrency *)new QuantLib::MTLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::MTLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MTLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::MTLCurrency *arg1 = (QuantLib::MTLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::MTLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MXNCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::MXNCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::MXNCurrency *)new QuantLib::MXNCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::MXNCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MXNCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::MXNCurrency *arg1 = (QuantLib::MXNCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::MXNCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NLGCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NLGCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NLGCurrency *)new QuantLib::NLGCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NLGCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NLGCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NLGCurrency *arg1 = (QuantLib::NLGCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NLGCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NOKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NOKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NOKCurrency *)new QuantLib::NOKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NOKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NOKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NOKCurrency *arg1 = (QuantLib::NOKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NOKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NPRCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NPRCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NPRCurrency *)new QuantLib::NPRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NPRCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NPRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NPRCurrency *arg1 = (QuantLib::NPRCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NPRCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1NZDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::NZDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::NZDCurrency *)new QuantLib::NZDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::NZDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1NZDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::NZDCurrency *arg1 = (QuantLib::NZDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::NZDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PKRCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::PKRCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::PKRCurrency *)new QuantLib::PKRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::PKRCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PKRCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::PKRCurrency *arg1 = (QuantLib::PKRCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::PKRCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PLNCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::PLNCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::PLNCurrency *)new QuantLib::PLNCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::PLNCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PLNCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::PLNCurrency *arg1 = (QuantLib::PLNCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::PLNCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1PTECurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::PTECurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::PTECurrency *)new QuantLib::PTECurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::PTECurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1PTECurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::PTECurrency *arg1 = (QuantLib::PTECurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::PTECurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ROLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ROLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ROLCurrency *)new QuantLib::ROLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ROLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ROLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ROLCurrency *arg1 = (QuantLib::ROLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ROLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RONCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::RONCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::RONCurrency *)new QuantLib::RONCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::RONCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RONCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::RONCurrency *arg1 = (QuantLib::RONCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::RONCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SARCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SARCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SARCurrency *)new QuantLib::SARCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SARCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SARCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SARCurrency *arg1 = (QuantLib::SARCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SARCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SEKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SEKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SEKCurrency *)new QuantLib::SEKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SEKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SEKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SEKCurrency *arg1 = (QuantLib::SEKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SEKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SGDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SGDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SGDCurrency *)new QuantLib::SGDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SGDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SGDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SGDCurrency *arg1 = (QuantLib::SGDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SGDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SITCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SITCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SITCurrency *)new QuantLib::SITCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SITCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SITCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SITCurrency *arg1 = (QuantLib::SITCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SITCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1SKKCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::SKKCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::SKKCurrency *)new QuantLib::SKKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::SKKCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1SKKCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::SKKCurrency *arg1 = (QuantLib::SKKCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::SKKCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1THBCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::THBCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::THBCurrency *)new QuantLib::THBCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::THBCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1THBCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::THBCurrency *arg1 = (QuantLib::THBCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::THBCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TRLCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::TRLCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::TRLCurrency *)new QuantLib::TRLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::TRLCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TRLCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::TRLCurrency *arg1 = (QuantLib::TRLCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::TRLCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TRYCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::TRYCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::TRYCurrency *)new QuantLib::TRYCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::TRYCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TRYCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::TRYCurrency *arg1 = (QuantLib::TRYCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::TRYCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TTDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::TTDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::TTDCurrency *)new QuantLib::TTDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::TTDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TTDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::TTDCurrency *arg1 = (QuantLib::TTDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::TTDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1TWDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::TWDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::TWDCurrency *)new QuantLib::TWDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::TWDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1TWDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::TWDCurrency *arg1 = (QuantLib::TWDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::TWDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1USDCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::USDCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::USDCurrency *)new QuantLib::USDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::USDCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1USDCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::USDCurrency *arg1 = (QuantLib::USDCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::USDCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1VEBCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::VEBCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::VEBCurrency *)new QuantLib::VEBCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::VEBCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1VEBCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::VEBCurrency *arg1 = (QuantLib::VEBCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::VEBCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ZARCurrency(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  QuantLib::ZARCurrency *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (QuantLib::ZARCurrency *)new QuantLib::ZARCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(QuantLib::ZARCurrency **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ZARCurrency(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  QuantLib::ZARCurrency *arg1 = (QuantLib::ZARCurrency *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(QuantLib::ZARCurrency **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeLinearInterpolation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeLinearInterpolation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LinearInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeLinearInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LinearInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeLinearInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeLinearInterpolation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LogLinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeLogLinearInterpolation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeLogLinearInterpolation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LogLinearInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeLogLinearInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LogLinearInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeLogLinearInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LogLinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeLogLinearInterpolation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BackwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeBackwardFlatInterpolation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeBackwardFlatInterpolation *)new SafeBackwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeBackwardFlatInterpolation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BackwardFlatInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeBackwardFlatInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BackwardFlatInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeBackwardFlatInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BackwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeBackwardFlatInterpolation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ForwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeForwardFlatInterpolation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeForwardFlatInterpolation *)new SafeForwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeForwardFlatInterpolation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_ForwardFlatInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeForwardFlatInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_ForwardFlatInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeForwardFlatInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ForwardFlatInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeForwardFlatInterpolation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CubicSplineInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeNaturalCubicSpline *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeNaturalCubicSpline **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSplineInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSplineInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSplineInterpolation_1derivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSplineInterpolation_1derivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSplineInterpolation_1secondDerivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_CubicSplineInterpolation_1secondDerivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CubicSplineInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeNaturalCubicSpline **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1MonotonicCubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeNaturalMonotonicCubicSpline *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeNaturalMonotonicCubicSpline **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1derivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1derivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1secondDerivative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_MonotonicCubicSpline_1secondDerivative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1MonotonicCubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeNaturalMonotonicCubicSpline **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BilinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix *arg3 = 0 ;
  SafeBilinearInterpolation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg3 = *(Matrix **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeBilinearInterpolation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BilinearInterpolation_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
  Real arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeBilinearInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BilinearInterpolation_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeBilinearInterpolation **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BilinearInterpolation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeBilinearInterpolation **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BicubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix *arg3 = 0 ;
  SafeBicubicSpline *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Array **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg2 = *(Array **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Array const & reference is null");
    return 0;
  } 
  arg3 = *(Matrix **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Matrix const & reference is null");
    return 0;
  } 
  {
    try {
      result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(SafeBicubicSpline **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BicubicSpline_1getValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
  Real arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeBicubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BicubicSpline_1getValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(SafeBicubicSpline **)&jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BicubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(SafeBicubicSpline **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BackwardFlat(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  BackwardFlat *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (BackwardFlat *)new BackwardFlat();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BackwardFlat **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BackwardFlat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  BackwardFlat *arg1 = (BackwardFlat *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BackwardFlat **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ForwardFlat(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ForwardFlat *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (ForwardFlat *)new ForwardFlat();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ForwardFlat **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ForwardFlat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ForwardFlat *arg1 = (ForwardFlat *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ForwardFlat **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1Linear(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Linear *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Linear *)new Linear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Linear **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1Linear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Linear *arg1 = (Linear *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Linear **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LogLinear(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  LogLinear *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (LogLinear *)new LogLinear();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(LogLinear **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LogLinear(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LogLinear *arg1 = (LogLinear *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LogLinear **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1CubicSpline(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CubicSpline *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (CubicSpline *)new CubicSpline();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(CubicSpline **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1CubicSpline(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CubicSpline *arg1 = (CubicSpline *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CubicSpline **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  YieldTermStructure *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (YieldTermStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(YieldTermStructure **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1YieldTermStructure(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<YieldTermStructure > *)new boost::shared_ptr<YieldTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<YieldTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1YieldTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  bool arg3 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1discount_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  bool arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1zeroRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6, jboolean jarg7) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  bool arg7 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  arg7 = jarg7 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1forwardRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructure_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1YieldTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = 0 ;
  Handle<YieldTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<YieldTermStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<YieldTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1YieldTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<YieldTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  boost::shared_ptr<YieldTermStructure > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<YieldTermStructure > **)&jresult = new boost::shared_ptr<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = Handle_Sl_YieldTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1YieldTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jdouble jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jdouble jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  bool arg3 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1discount_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3, jint jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  bool arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1zeroRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6, jboolean jarg7) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  bool arg7 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  arg7 = jarg7 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1forwardRate_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  InterestRate result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(InterestRate **)&jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_YieldTermStructureHandle_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableYieldTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<YieldTermStructure > *arg1 = 0 ;
  RelinkableHandle<YieldTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<YieldTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<YieldTermStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RelinkableHandle<YieldTermStructure > *)new RelinkableHandle<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<YieldTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableYieldTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RelinkableHandle<YieldTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (RelinkableHandle<YieldTermStructure > *)new RelinkableHandle<YieldTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<YieldTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableYieldTermStructureHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RelinkableHandle<YieldTermStructure > *arg1 = (RelinkableHandle<YieldTermStructure > *) 0 ;
  boost::shared_ptr<YieldTermStructure > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RelinkableHandle<YieldTermStructure > **)&jarg1; 
  arg2 = *(boost::shared_ptr<YieldTermStructure > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<YieldTermStructure > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<YieldTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableYieldTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RelinkableHandle<YieldTermStructure > *arg1 = (RelinkableHandle<YieldTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RelinkableHandle<YieldTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ImpliedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = 0 ;
  Date *arg2 = 0 ;
  ImpliedTermStructurePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
    return 0;
  } 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  {
    try {
      result = (ImpliedTermStructurePtr *)new_ImpliedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ImpliedTermStructurePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ImpliedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ImpliedTermStructurePtr *arg1 = (ImpliedTermStructurePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ImpliedTermStructurePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ZeroSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  ZeroSpreadedTermStructurePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
    return 0;
  } 
  arg2 = *(Handle<Quote > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (ZeroSpreadedTermStructurePtr *)new_ZeroSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ZeroSpreadedTermStructurePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ZeroSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ZeroSpreadedTermStructurePtr *arg1 = (ZeroSpreadedTermStructurePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ZeroSpreadedTermStructurePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1ForwardSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Handle<YieldTermStructure > *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  ForwardSpreadedTermStructurePtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<YieldTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<YieldTermStructure > const & reference is null");
    return 0;
  } 
  arg2 = *(Handle<Quote > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (ForwardSpreadedTermStructurePtr *)new_ForwardSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(ForwardSpreadedTermStructurePtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1ForwardSpreadedTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ForwardSpreadedTermStructurePtr *arg1 = (ForwardSpreadedTermStructurePtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ForwardSpreadedTermStructurePtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Handle<Quote > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Handle<Quote > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = *(Handle<Quote > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Rate arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = (Rate)jarg2; 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Rate arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = (Rate)jarg2; 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Date *arg1 = 0 ;
  Rate arg2 ;
  DayCounter *arg3 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Date **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg2 = (Rate)jarg2; 
  arg3 = *(DayCounter **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Handle<Quote > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (Integer)jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Handle<Quote > **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Handle<Quote > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (Integer)jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Handle<Quote > **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Handle<Quote > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (Integer)jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = *(Handle<Quote > **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Handle<Quote > const & reference is null");
    return 0;
  } 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Rate arg3 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = (Integer)jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Rate arg3 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = (Integer)jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1FlatForward_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Rate arg3 ;
  DayCounter *arg4 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = (Integer)jarg1; 
  arg2 = *(Calendar **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Calendar const & reference is null");
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = *(DayCounter **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "DayCounter const & reference is null");
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(FlatForwardPtr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1FlatForward(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  FlatForwardPtr *arg1 = (FlatForwardPtr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FlatForwardPtr **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  BlackVolTermStructure *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (BlackVolTermStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(BlackVolTermStructure **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BlackVolTermStructure(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<BlackVolTermStructure > *)new boost::shared_ptr<BlackVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<BlackVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BlackVolTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1minStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1maxStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVol_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVol_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVariance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVariance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVariance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackVariance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVol_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVol_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVariance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVariance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVariance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1blackForwardVariance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructure_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BlackVolTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = 0 ;
  Handle<BlackVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<BlackVolTermStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Handle<BlackVolTermStructure > *)new Handle<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<BlackVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1BlackVolTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle<BlackVolTermStructure > *)new Handle<BlackVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<BlackVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<BlackVolTermStructure > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<BlackVolTermStructure > **)&jresult = new boost::shared_ptr<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = Handle_Sl_BlackVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1BlackVolTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1minStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1maxStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVol_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVol_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVariance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVariance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVariance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackVariance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVol_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVol_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVariance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVariance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = *(Date **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVariance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jboolean jarg5) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1blackForwardVariance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  jdouble jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_BlackVolTermStructureHandle_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableBlackVolTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = 0 ;
  RelinkableHandle<BlackVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<BlackVolTermStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RelinkableHandle<BlackVolTermStructure > *)new RelinkableHandle<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<BlackVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableBlackVolTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RelinkableHandle<BlackVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (RelinkableHandle<BlackVolTermStructure > *)new RelinkableHandle<BlackVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<BlackVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableBlackVolTermStructureHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RelinkableHandle<BlackVolTermStructure > **)&jarg1; 
  arg2 = *(boost::shared_ptr<BlackVolTermStructure > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<BlackVolTermStructure > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<BlackVolTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableBlackVolTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RelinkableHandle<BlackVolTermStructure > *arg1 = (RelinkableHandle<BlackVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RelinkableHandle<BlackVolTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  LocalVolTermStructure *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (LocalVolTermStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(LocalVolTermStructure **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LocalVolTermStructure(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<LocalVolTermStructure > *)new boost::shared_ptr<LocalVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<LocalVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LocalVolTermStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1minStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1maxStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1localVol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1localVol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1localVol_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1localVol_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructure_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LocalVolTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = 0 ;
  Handle<LocalVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<LocalVolTermStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Handle<LocalVolTermStructure > *)new Handle<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<LocalVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1LocalVolTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle<LocalVolTermStructure > *)new Handle<LocalVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<LocalVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<LocalVolTermStructure > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<LocalVolTermStructure > **)&jresult = new boost::shared_ptr<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = Handle_Sl_LocalVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1LocalVolTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1minStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1maxStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1localVol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1localVol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1localVol_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1localVol_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_LocalVolTermStructureHandle_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableLocalVolTermStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = 0 ;
  RelinkableHandle<LocalVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<LocalVolTermStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (RelinkableHandle<LocalVolTermStructure > *)new RelinkableHandle<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<LocalVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1RelinkableLocalVolTermStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  RelinkableHandle<LocalVolTermStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (RelinkableHandle<LocalVolTermStructure > *)new RelinkableHandle<LocalVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(RelinkableHandle<LocalVolTermStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_RelinkableLocalVolTermStructureHandle_1linkTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(RelinkableHandle<LocalVolTermStructure > **)&jarg1; 
  arg2 = *(boost::shared_ptr<LocalVolTermStructure > **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<LocalVolTermStructure > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<LocalVolTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1RelinkableLocalVolTermStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RelinkableHandle<LocalVolTermStructure > *arg1 = (RelinkableHandle<LocalVolTermStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RelinkableHandle<LocalVolTermStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  OptionletVolatilityStructure *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (OptionletVolatilityStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(OptionletVolatilityStructure **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1OptionletVolatilityStructure(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (boost::shared_ptr<OptionletVolatilityStructure > *)new boost::shared_ptr<OptionletVolatilityStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<OptionletVolatilityStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1OptionletVolatilityStructure(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1minStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1maxStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1volatility_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->volatility((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1volatility_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->volatility((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1volatility_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->volatility(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1volatility_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->volatility(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1blackVariance_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Date *arg2 = 0 ;
  Rate arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1blackVariance_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Date *arg2 = 0 ;
  Rate arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1blackVariance_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Time arg2 ;
  Rate arg3 ;
  bool arg4 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Rate)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1blackVariance_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  Time arg2 ;
  Rate arg3 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Rate)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1enableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1disableExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructure_1allowsExtrapolation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = (boost::shared_ptr<OptionletVolatilityStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1OptionletVolatilityStructureHandle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > *arg1 = 0 ;
  Handle<OptionletVolatilityStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(boost::shared_ptr<OptionletVolatilityStructure > **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "boost::shared_ptr<OptionletVolatilityStructure > const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Handle<OptionletVolatilityStructure > *)new Handle<OptionletVolatilityStructure >((boost::shared_ptr<OptionletVolatilityStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<OptionletVolatilityStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_new_1OptionletVolatilityStructureHandle_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Handle<OptionletVolatilityStructure > *)new Handle<OptionletVolatilityStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Handle<OptionletVolatilityStructure > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1_1_1deref_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  boost::shared_ptr<OptionletVolatilityStructure > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<OptionletVolatilityStructure > **)&jresult = new boost::shared_ptr<OptionletVolatilityStructure >((boost::shared_ptr<OptionletVolatilityStructure > &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1asObservable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = Handle_Sl_OptionletVolatilityStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(boost::shared_ptr<Observable > **)&jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_quantlib_QuantLibJNI_delete_1OptionletVolatilityStructureHandle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1referenceDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1dayCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(DayCounter **)&jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1calendar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  SwigValueWrapper< Calendar > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Calendar **)&jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1maxDate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Date result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  *(Date **)&jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1maxTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Time result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1minStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1maxStrike(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Real result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1volatility_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->volatility((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1volatility_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = *(Date **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Date const & reference is null");
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->volatility((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1volatility_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jboolean jarg4) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->volatility(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_quantlib_QuantLibJNI_OptionletVolatilityStructureHandle_1volatility_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  Handle<OptionletVolatilityStructure > *arg1 = (Handle<OptionletVolatilityStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Handle<OptionletVolatilityStructure > **)&jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->volatility(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_JavaException(jenv, SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      }