/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74                                           *
 *   francesco.b74@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "schedastazione.h"

//questo widget si occupa di presentare all'utente una lista delle stazioni proposte da viaggiatreno per
//risolvere l'ambiguità del nome inserito dall'utente
WidgetDisambiguaNome::WidgetDisambiguaNome(const QString& rispostaVT, SchedaStazione *parent): QWidget(parent)
{
	QDomDocument docDom;
	QString msg;
	int riga, col;
//imposta il layout del dialogo
	QVBoxLayout *vbox = new QVBoxLayout;
	setLayout(vbox);
	QLabel *messaggio = new QLabel(this);
	messaggio->setWordWrap(true);
	messaggio->setText(QString::fromUtf8("Il nome della stazione ('<b>%1</b>') è ambiguo. Per risolvere"
		" questa ambiguità ViaggiaTreno ha proposto una lista di possibili stazioni. <br/>Scegliere dalla lista sottostante"
		" la stazione desiderata oppure il pulsante di chiusura se desiderate semplicemente chiudere questa scheda").arg(parent->nomeStazione()));
	vbox->addWidget(messaggio);
	QHBoxLayout *hbox = new QHBoxLayout;
	listaNomi = new QListWidget(this);
	QPushButton *btnSceltaStazione = new QPushButton(QString::fromUtf8("Scelta stazione"), this);

	hbox->addWidget(listaNomi);
	hbox->addWidget(btnSceltaStazione, 0, Qt::AlignCenter);
	vbox->addLayout(hbox);
	//ottiene la lista di tutti gli elementi figli del tag "select"
	//ogni nodo è un elemento "option" che contiene il nome della stazione e nell'attributo "value" il codice della stazione
	docDom.setContent(rispostaVT, &msg, &riga, &col);
	QDomElement body = docDom.documentElement().firstChildElement("body");
	QDomElement corpocentrale = body.firstChildElement("div").nextSiblingElement("div");
	QDomElement form = corpocentrale.firstChildElement("form");
	QDomElement select = form.firstChildElement("p").firstChildElement("select");
	QDomNodeList nodi = select.childNodes();
	//scorre la lista dei nodi
	//per ogni elemento "option" crea un item nel listwidget, il cui testo è il nome della stazione
	//mentre il codice è memorizzato tra i dati dell'item
	for (int j = 0; j < nodi.count(); j++)
	{
		QListWidgetItem *item = new QListWidgetItem(nodi.at(j).toElement().text());
		item->setData(Qt::UserRole, nodi.at(j).toElement().attribute("value"));
		listaNomi->addItem(item);
	}

	listaNomi->setSelectionMode(QAbstractItemView::SingleSelection);
	listaNomi->setAlternatingRowColors(true);
	listaNomi->setCurrentRow(0);

	//connessioni
	connect(btnSceltaStazione, SIGNAL(clicked()), this, SLOT(sceltaNomeStazione()));
	connect(this, SIGNAL(nomeDisambiguato(const QString&)), parent, SLOT(cambiaCodiceStazione(const QString&)));

}

//slot
//è stato scelto il nome della stazione dalla lista proposta, viene comunicato alla scheda con un segnale
void WidgetDisambiguaNome::sceltaNomeStazione()
{
	QListWidgetItem *item = listaNomi->currentItem();

	emit nomeDisambiguato(item->data(Qt::UserRole).toString());
}


TabellaStazione::TabellaStazione(QWidget *parent) : QTableWidget(parent)
{
	setAlternatingRowColors(true);
	setSelectionMode(QAbstractItemView::NoSelection);
	setEditTriggers(QAbstractItemView::NoEditTriggers);
	verticalHeader()->setVisible(false);
	setMouseTracking(true);
	horizontalHeader()->setMouseTracking(true);
	horizontalHeader()->setStretchLastSection(true);
}

void TabellaStazione::mouseMoveEvent(QMouseEvent *event)
{

	int col = columnAt(event->x());
	if ( (col == Stazione::colNumero )|| (col==Stazione::colStazione) )
		setCursor(Qt::PointingHandCursor);
	else
		setCursor(Qt::ArrowCursor);

	event->accept();
}
