% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make.R
\name{make_chordal_ring}
\alias{chordal_ring}
\alias{graph.extended.chordal.ring}
\alias{make_chordal_ring}
\title{Create an extended chordal ring graph}
\usage{
make_chordal_ring(n, w)

chordal_ring(...)
}
\arguments{
\item{n}{The number of vertices.}

\item{w}{A matrix which specifies the extended chordal ring. See
details below.}

\item{...}{Passed to \code{make_chordal_ring}.}
}
\value{
An igraph graph.
}
\description{
\code{make_chordal_ring} creates an extended chordal ring.
An extended chordal ring is regular graph, each node has the same
degree. It can be obtained from a simple ring by adding some extra
edges specified by a matrix. Let p denote the number of columns in
the \sQuote{\code{W}} matrix. The extra edges of vertex \code{i}
are added according to column \code{i mod p} in
\sQuote{\code{W}}. The number of extra edges is the number
of rows in \sQuote{\code{W}}: for each row \code{j} an edge
\code{i->i+w[ij]} is added if \code{i+w[ij]} is less than the number
of total nodes. See also Kotsis, G: Interconnection Topologies for
Parallel Processing Systems, PARS Mitteilungen 11, 1-6, 1993.
}
\examples{
chord <- make_chordal_ring(15,
    matrix(c(3, 12, 4, 7, 8, 11), nr = 2))
}
\seealso{
Other determimistic constructors: \code{\link{atlas}},
  \code{\link{graph.atlas}},
  \code{\link{graph_from_atlas}};
  \code{\link{directed_graph}}, \code{\link{graph}},
  \code{\link{graph.famous}},
  \code{\link{make_directed_graph}},
  \code{\link{make_graph}},
  \code{\link{make_undirected_graph}},
  \code{\link{undirected_graph}};
  \code{\link{empty_graph}}, \code{\link{graph.empty}},
  \code{\link{make_empty_graph}};
  \code{\link{from_edgelist}},
  \code{\link{graph.edgelist}},
  \code{\link{graph_from_edgelist}};
  \code{\link{from_literal}}, \code{\link{graph.formula}},
  \code{\link{graph_from_literal}};
  \code{\link{full_citation_graph}},
  \code{\link{graph.full.citation}},
  \code{\link{make_full_citation_graph}};
  \code{\link{full_graph}}, \code{\link{graph.full}},
  \code{\link{make_full_graph}};
  \code{\link{graph.lattice}}, \code{\link{lattice}},
  \code{\link{make_lattice}}; \code{\link{graph.ring}},
  \code{\link{make_ring}}, \code{\link{ring}};
  \code{\link{graph.star}}, \code{\link{make_star}},
  \code{\link{star}}; \code{\link{graph.tree}},
  \code{\link{make_tree}}, \code{\link{tree}}
}

