% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{subgraph}
\alias{induced.subgraph}
\alias{induced_subgraph}
\alias{subgraph}
\alias{subgraph.edges}
\title{Subgraph of a graph}
\usage{
subgraph(graph, v)

induced_subgraph(graph, vids, impl = c("auto", "copy_and_delete",
  "create_from_scratch"))

subgraph.edges(graph, eids, delete.vertices = TRUE)
}
\arguments{
\item{graph}{The original graph.}

\item{v}{Numeric vector, the vertices of the original graph which will
form the subgraph.}

\item{vids}{Numeric vector, the vertices of the original graph which will
form the subgraph.}

\item{impl}{Character scalar, to choose between two implementation of the
subgraph calculation. \sQuote{\code{copy_and_delete}} copies the graph
first, and then deletes the vertices and edges that are not included in the
result graph. \sQuote{\code{create_from_scratch}} searches for all vertices
and edges that must be kept and then uses them to create the graph from
scratch. \sQuote{\code{auto}} chooses between the two implementations
automatically, using heuristics based on the size of the original and the
result graph.}

\item{eids}{The edge ids of the edges that will be kept in the result graph.}

\item{delete.vertices}{Logical scalar, whether to remove vertices that do
not have any adjacent edges in \code{eids}.}
}
\value{
A new graph object.
}
\description{
\code{subgraph} creates a subgraph of a graph, containing only the specified
vertices and all the edges among them.
}
\details{
\code{induced_subgraph} calculates the induced subgraph of a set of vertices
in a graph. This means that exactly the specified vertices and all the edges
between then will be kept in the result graph.

\code{subgraph.edges} calculates the subgraph of a graph. For this function
one can specify the vertices and edges to keep. This function will be
renamed to \code{subgraph} in the next major version of igraph.

The \code{subgraph} function does the same as \code{induced.graph} currently
(assuming \sQuote{\code{auto}} as the \code{impl} argument), but it is
deprecated and will be removed in the next major version of igraph.
}
\examples{
g <- make_ring(10)
g2 <- induced_subgraph(g, 1:7)
g3 <- subgraph.edges(g, 1:5, 1:5)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}

