% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{add_layout_}
\alias{add_layout_}
\title{Add layout to graph}
\usage{
add_layout_(graph, ..., overwrite = TRUE)
}
\arguments{
\item{graph}{The input graph.}

\item{...}{Additional arguments are passed to \code{\link{layout_}}.}

\item{overwrite}{Whether to overwrite the layout of the graph,
if it already has one.}
}
\value{
The input graph, with the layout added.
}
\description{
Add layout to graph
}
\examples{
(make_star(11) + make_star(11)) \%>\%
  add_layout_(as_star(), component_wise()) \%>\%
  plot()
}
\seealso{
\code{\link{layout_}} for a description of the layout API.

Other graph layouts: 
\code{\link{component_wise}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{layout_}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\concept{graph layouts}
