#ifndef menu_result_menu
#define menu_result_menu

#include <ClanLib/gui.h>

class ResultEntry;

class ResultMenu : public CL_Component
{
 public:
	ResultMenu(CL_Component *parent, CL_StyleManager *style, bool final);
	~ResultMenu();

	static void show(bool final=false);
	
 private:
	void on_paint();
	void on_continue();
	
	void play_music();
	void make_entries();
	void show_results();
	void show_final_results();
	
	CL_SlotContainer slots;
	CL_Button btn_continue;
	
	std::vector<ResultEntry> results;
	
	bool final;
};

class ResultEntry
{
 public:
	ResultEntry( unsigned short _p, unsigned char _id )
	{
		id = _id;
		points = _p;
	}

	bool operator< ( const ResultEntry &r ) const
	{
		return points > r.points;
	}

	bool operator== ( const ResultEntry &r ) const
	{
		return points == r.points;
	}

	unsigned char id;
	unsigned short points;
};

#endif
