#include <iostream>

using namespace std;

#define BUFSIZE 2048

#define TK_Dlit 192
#define TK_Slit 193
#define TK_Float 194
#define TK_Id 195
#define TK_NameSep 197
#define TK_Arrow 211
#define TK_PlusPlus 212
#define TK_MinusMinus 213
#define TK_ArrowStar 214
#define TK_DotStar 215
#define TK_ShiftLeft 216
#define TK_ShiftRight 217
#define TK_IntegerDecimal 218
#define TK_IntegerOctal 219
#define TK_IntegerHex 220
#define TK_EqualsEquals 223
#define TK_NotEquals 224
#define TK_AndAnd 225
#define TK_OrOr 226
#define TK_MultAssign 227
#define TK_DivAssign 228
#define TK_PercentAssign 229
#define TK_PlusAssign 230
#define TK_MinusAssign 231
#define TK_AmpAssign 232
#define TK_CaretAssign 233
#define TK_BarAssign 234
#define TK_DotDotDot 240

/* A growable buffer for collecting headers. */
struct Buffer
{
	Buffer() : data(0), allocated(0), length(0) { }
	Buffer( const Buffer &other ) {
		data = (char*)malloc( other.allocated );
		memcpy( data, other.data, other.length );
		allocated = other.allocated;
		length = other.length;
	}
	~Buffer() { empty(); }

	void append( char p ) {
		if ( ++length > allocated )
			upAllocate( length*2 );
		data[length-1] = p;
	}
	void append( char *str, int len ) {
		if ( (length += len) > allocated )
			upAllocate( length*2 );
		memcpy( data+length-len, str, len );
	}
		
	void clear() { length = 0; }
	void upAllocate( int len );
	void empty();

	char *data;
	int allocated;
	int length;
};



%% Scanner

	struct {
		Scanner( std::ostream &out )
			: out(out) { }

		std::ostream &out;

		int line, col;
		int tokStart;
		int inlineDepth;
		int count;
		Buffer tokBuf;
		Buffer nonTokBuf;

		void pass(char c) { nonTokBuf.append(c); }
		void buf(char c) { tokBuf.append(c); }
		void token( int id );
	};

	init {
		/* A count of the number of characters in 
		 * a token. Used for % sequences. */
		count = 0;
		line = 1;
		col = 1;
	}

	action pass { pass(fc); }
	action buf { buf(fc); }

	action emit_slit { token( TK_Slit ); }
	action emit_dlit { token( TK_Dlit ); }
	action emit_id { token( TK_Id ); }
	action emit_integer_decimal { token( TK_IntegerDecimal ); }
	action emit_integer_octal { token( TK_IntegerOctal ); }
	action emit_integer_hex { token( TK_IntegerHex ); }
	action emit_float { token( TK_Float ); }
	action emit_symbol { token( tokBuf.data[0] ); }
	action tokst { tokStart = col; }

	# Single and double literals.
	slit = ( 'L'? ( "'" ( [^'\\\n] | /\\./ )* "'" ) $buf ) >tokst %emit_slit;
	dlit = ( 'L'? ( '"' ( [^"\\\n] | /\\./ )* '"' ) $buf ) >tokst %emit_dlit;

	# Identifiers
	id = ( [a-zA-Z_] [a-zA-Z0-9_]* ) >tokst $buf %emit_id;

	# Floating literals.
	fract_const = digit* '.' digit+ | digit+ '.';
	exponent = [eE] [+\-]? digit+;
	float_suffix = [flFL];
	float = 
		( fract_const exponent? float_suffix? |
		digit+ exponent float_suffix? ) >tokst $buf %emit_float;
	
	# Integer decimal. Leading part buffered by float.
	integer_decimal = ( ( '0' | [1-9] [0-9]* ) [ulUL]{0,3} $buf ) %emit_integer_decimal;

	# Integer octal. Leading part buffered by float.
	integer_octal = ( '0' [0-9]+ [ulUL]{0,2} $buf ) %emit_integer_octal;

	# Integer hex. Leading 0 buffered by float.
	integer_hex = ( '0' ( 'x' [0-9a-fA-F]+ [ulUL]{0,2} ) $buf ) %emit_integer_hex;

	# Only buffer the second item, first buffered by symbol. */
	namesep = '::' @buf %{token( TK_NameSep );};
	deqs = '==' @buf %{token( TK_EqualsEquals );};
	neqs = '!=' @buf %{token( TK_NotEquals );};
	and_and = '&&' @buf %{token( TK_AndAnd );};
	or_or = '||' @buf %{token( TK_OrOr );};
	mult_assign = '*=' @buf %{token( TK_MultAssign );};
	percent_assign = '%=' @buf %{token( TK_PercentAssign );};
	plus_assign = '+=' @buf %{token( TK_PlusAssign );};
	minus_assign = '-=' @buf %{token( TK_MinusAssign );};
	amp_assign = '&=' @buf %{token( TK_AmpAssign );};
	caret_assign = '^=' @buf %{token( TK_CaretAssign );};
	bar_assign = '|=' @buf %{token( TK_BarAssign );};
	plus_plus = '++' @buf %{token( TK_PlusPlus );};
	minus_minus = '--' @buf %{token( TK_MinusMinus );};
	arrow = '->' @buf %{token( TK_Arrow );};
	arrow_star = '->*' @buf %{token( TK_ArrowStar );};
	dot_star = '.*' @buf %{token( TK_DotStar );};

	# Buffer both items. *
	div_assign = '/=' @{buf('/');buf(fc);} %{token( TK_DivAssign );};

	# Double dot is sent as two dots.
	dot_dot = '..' %{token('.'); buf('.'); token('.');};

	# Three char compounds, first item already buffered. */
	dot_dot_dot = '...' %{buf('.'); buf('.'); token( TK_DotDotDot );};

	# All compunds
	compound = namesep | deqs | neqs | and_and | or_or | mult_assign |
			div_assign | percent_assign | plus_assign | minus_assign |
			amp_assign | caret_assign | bar_assign | plus_plus | minus_minus |
			arrow | arrow_star | dot_star | dot_dot | dot_dot_dot;

	# Single char symbols.
	symbol = 
		( punct - [./_"'] ) >tokst $buf %emit_symbol |
		# Do not immediately buffer slash, may be start of comment.
		'/' >tokst %{ buf('/'); token( '/' ); } |
		# Dot covered by float.
		'.' %emit_symbol;

	# Comments and whitespace.
	commc = '/*' @{pass('/'); pass('*');} ( any* $0 '*/' @1 ) $pass;
	commcc = '//' @{pass('/'); pass('/');} ( any* $0 '\n' @1 ) $pass;
	whitespace = ( any - 33..126 )+ $pass;

	# All outside code tokens.
	tokens = ( 
		id | slit | dlit | float | integer_decimal | 
		integer_octal | integer_hex | compound | symbol );
	nontok = ( commc | commcc | whitespace );

	action success {
		nonTokBuf.append(0);
		cout << nonTokBuf.data;
		cout.flush();
	}

	position = (
		'\n' @{ line += 1; col = 1; } |
		[^\n] @{ col += 1; } )*;

	main := ( ( tokens | nontok )** %success ) & position;
%%

void Scanner::token( int id )
{
	/* Leader. */
	if ( nonTokBuf.length > 0 ) {
		nonTokBuf.append(0);
		cout << nonTokBuf.data;
		nonTokBuf.clear();
	}

	/* Token data. */
	tokBuf.append(0);
	cout << '<' << id << '>' << tokBuf.data;
	tokBuf.clear();
}

void Buffer::empty()
{
	if ( data != 0 ) {
		free( data );

		data = 0;
		length = 0;
		allocated = 0;
	}
}

void Buffer::upAllocate( int len )
{
	if ( data == 0 )
		data = (char*) malloc( len );
	else
		data = (char*) realloc( data, len );
	allocated = len;
}

int main()
{
	std::ios::sync_with_stdio(false);
	Scanner scanner(cout);
	static char buffer[BUFSIZE];

	istream &input = cin;
	scanner.init();
	while ( ! input.eof() ) {
		input.read( buffer, BUFSIZE );
		scanner.execute( buffer, input.gcount() );
	}

	if ( scanner.finish() <= 0 ) {
		cerr << "cppscan: scan failed" << endl;
		return 1;
	}
	
	return 0;
}
