/******************************************************************************
*		       							      *
* console/readline.h (part of rcalc)				       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* A wrapper around the GNU readline library. Readline provides
** command-line editing, persistant command history, tab-completion
** and all the rest. See readline(3) for a user-level guide to
** readline's features.
*/

#ifndef __RC_READLINE_H__
#define __RC_READLINE_H__

#include <glib.h>


typedef struct _RcReadline RcReadline;


RcReadline*	rcc_readline_new	( const gchar *prompt );
void		rcc_readline_delete	( RcReadline  *rl );
const gchar*    rcc_readline_read_line	( RcReadline  *rl );


#endif /* __RC_READLINE_H__ */
