/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PREFERENCES_H__
#define __PREFERENCES_H__

#include <glib/gmacros.h>

G_BEGIN_DECLS

#include <sys/types.h>
#include <regex.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtkliststore.h>
#include <bonobo/bonobo-ui-component.h>

typedef struct {
    int     normal_size_x;
    int     normal_size_y;
    int     panel_size_x;
    
    char angle_unit;

} MCPreferences;


/* Defaults */
#define MC_DEFAULT_NORMAL_SIZE_X                150
#define MC_DEFAULT_NORMAL_SIZE_Y                48

#include "rcalc_applet.h"

void       rca_load_preferences (MCData            *mc);
void       rca_show_preferences (BonoboUIComponent *uic,
				MCData            *mc,
				const char        *verbname);

G_END_DECLS

#endif
