#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

void RCUI_clean_state (GtkListStore *list_store)
{
  gchar *name;
  gchar *genexpr;
  gboolean valid;
  GtkTreeIter iter;
  
  /* remove all existing lines */
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &iter);
  while (valid)
  {
    gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, NAME_COLUMN, &name, -1);
    valid = gtk_list_store_remove(list_store, &iter);
  
    /* generate 'rm' command if it's a var/func */
    if (strlen(name) > 0) {
      genexpr = g_strdup_printf("rm %s", name);
      rc_engine_execute( RC_engine, genexpr );
    if (genexpr) g_free (genexpr);
    }
  
    if (name) g_free (name);
  }
  
  RCUI_update_varw_lists();  
}

void RCUI_fill_with_saved_state (GtkListStore *list_store)
{
  int i=0;
  gchar *in_expr;
  gchar *value;
  
  for( i=0; i < RC_engine->nVariables; i++ )
	{
		if (!g_ascii_strncasecmp(RC_engine->variables[i].name,"Ans",3)==0) {
      in_expr = g_strdup_printf("%s=%.12f",RC_engine->variables[i].name, RC_engine->variables[i].value);
      value = g_strdup_printf("%.12f", RC_engine->variables[i].value);
      RCUI_append_expr (list_store, 
                      RC_engine->variables[i].name, 
                      value, 
                      value,
                      in_expr);
      g_free(in_expr);
      g_free(value);
    }
    		
	}
  for( i=NUM_DEFAULT_FUNCTIONS; i < RC_engine->nFunctions; i++ )
  {
  	in_expr = g_strdup_printf("func %s(x)=%s",
      RC_engine->functions[i].name, RC_engine->functions[i].expression);
    RCUI_append_expr (list_store, 
                      RC_engine->functions[i].name, 
                      RC_engine->functions[i].expression, 
                      "",
                      in_expr);
    g_free(in_expr);		
  }
}

void RCUI_clean_state_from (GtkListStore *list_store, GtkTreeIter fromiter)
{
  gboolean valid = TRUE;
  GtkTreeIter iter = fromiter, first_iter;
  
  if (!gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &first_iter))
    /* Tree is empty */
    valid = FALSE;
      
  while (valid)
  {
    RCUI_remove_var_at_iter (list_store, iter);
    valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
  }
}

void RCUI_update_state_from (GtkListStore *list_store, GtkTreeIter fromiter)
{
  gboolean valid = TRUE;
  GtkTreeIter iter = fromiter, first_iter;
  gchar *in_expr, *name, *expr;
  gboolean quit_flag;
  gboolean is_active;
  
  RcLastRes RC_result;
  
  if (!gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &first_iter))
    /* Tree is empty */
    valid = FALSE;
  
  RCUI_clean_state_from (list_store, fromiter);
  
  /* from_iter is valid */    
  while (valid)
  {
      gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, NAME_COLUMN, &name, 
        EXPR_COLUMN, &expr, RUN_COLUMN, &is_active, INPUT_COLUMN, &in_expr, -1);
      
      
      if (is_active == TRUE) {
        /* launch rc engine with current line */
        quit_flag = rc_engine_execute( RC_engine, in_expr );
        RC_result = rc_import_lastres();
      
         /* modify line if expression is invalid */
        if (RC_result.expType == RC_EXP_ERROR) {
          /*valid = gtk_list_store_remove (list_store, &iter);*/
          gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, name,
                    EXPR_COLUMN, expr,
                    VALUE_COLUMN, _("undefined"),
		                INPUT_COLUMN, in_expr,
                    -1); 
          /* remove the variable (invalidate previous occurences */
          RCUI_remove_var_at_iter (list_store, iter);
          valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);  
        }
      
        /* or keep it if still valid */
        else {
          gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, RC_result.name,
                    EXPR_COLUMN, RC_result.expr,
                    VALUE_COLUMN, RC_result.value,
		                INPUT_COLUMN, in_expr,
                    -1); 
          valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
        }
      
        if (in_expr) g_free (in_expr);
        if (name) g_free (name);
      }
      
      else /* line is inactive, go to next line */
        valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
    
    }
  
    RCUI_update_varw_lists();
}

void RCUI_update_state_all (GtkListStore *list_store)
{
  GtkTreeIter first_iter;
  
  gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &first_iter);
  RCUI_update_state_from (list_store, first_iter);
}

void RCUI_remove_var_at_iter (GtkListStore *list_store, GtkTreeIter fromiter)
{
  GtkTreeIter iter = fromiter;
  gchar *name, *genexpr;
  
  gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, NAME_COLUMN, &name, -1);
  
  /* generate 'rm' command if it's a var/func */
  if (strlen(name) > 0) {
    genexpr = g_strdup_printf("rm %s", name);
    rc_engine_execute( RC_engine, genexpr );
    if (genexpr) g_free (genexpr);
  } 
  if (name) g_free (name); 
}


void RCUI_remove_undefined (GtkListStore *list_store)
{
  GtkTreeIter iter;
  gboolean valid = TRUE;
  gchar *in_expr, *name, *expr;
  RcLastRes RC_result;
  gboolean is_active;
  
  if (!gtk_tree_model_get_iter_first (GTK_TREE_MODEL(list_store), &iter))
    valid = FALSE;  
  
  RCUI_clean_state_from (list_store, iter);
  
  /* from_iter is valid */    
  while (valid)
  {
      gtk_tree_model_get (GTK_TREE_MODEL(list_store), &iter, NAME_COLUMN, &name, 
        EXPR_COLUMN, &expr, RUN_COLUMN, &is_active, INPUT_COLUMN, &in_expr, -1);
      
      if (is_active == TRUE) {
        /* launch rc engine with current line */
        rc_engine_execute( RC_engine, in_expr );
        RC_result = rc_import_lastres();
      
        /* modify line if expression is invalid */
        if (RC_result.expType == RC_EXP_ERROR) {
          valid = gtk_list_store_remove(list_store, &iter);
        }
      
        /* or keep it if still valid */
        else {
          gtk_list_store_set (list_store, &iter,
                    NAME_COLUMN, RC_result.name,
                    EXPR_COLUMN, RC_result.expr,
                    VALUE_COLUMN, RC_result.value,
		                INPUT_COLUMN, in_expr,
                    -1); 
          valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
        }
      
        if (in_expr) g_free (in_expr);
        if (name) g_free (name);
    }
    else 
      valid = gtk_tree_model_iter_next (GTK_TREE_MODEL(list_store), &iter);
  }
  
  RCUI_update_varw_lists();

}

