/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "OXConnectionDetails.h"
#include "OXConnectionOptions.h"

#include "version.h"

#include <xclass/OXClient.h>
#include <xclass/OXMsgBox.h>
#include <xclass/OXTransientFrame.h>
#include <xclass/OXButton.h>
#include <xclass/OXTextButton.h>
#include <xclass/OXCheckButton.h>
#include <xclass/OXRadioButton.h>
#include <xclass/OXComboBox.h>
#include <xclass/OXLabel.h>
#include <xclass/OString.h>
#include <xclass/OXFont.h>
#include <xclass/OXIcon.h>
#include <xclass/OPicture.h>
#include <xclass/OIniFile.h>
#include <xclass/OXFileDialog.h>                                                

namespace rfb {

class OXConnectionDetails : public OXTransientFrame {
public:
  OXConnectionDetails( ConnectionInfo &info, int &ret,
//                       const OXWindow *p, const OXWindow *m, int w = 373, int h = 101 );
                       const OXWindow *p, const OXWindow *m, int w = 373, int h = 116 );
  virtual ~OXConnectionDetails();

  virtual int ProcessMessage(OMessage *msg);

protected:
  OXButton *buttonOK;
  OXButton *buttonCancel;
  OXButton *buttonOptions;
  OXCompositeFrame *frameButtons;

  OXCompositeFrame *frameServer;
  OXComboBox *comboBoxServer;
  OXLabel *labelServer;
  OXLabel *labelSyntax;

  OXCheckButton *checkButtonRecordFBS;
  OXCheckButton *checkButtonRecordRFM;

  OLayoutHints *_lh;
  
  ConnectionInfo *connectionInfo;
  int *retCode;
};



int getConnectionDetails( ConnectionInfo &info, const OXWindow *p, const OXWindow *m )
{
  int retCode = 0;
  new OXConnectionDetails( info, retCode, p, m );
  return retCode;
}




OXConnectionDetails::OXConnectionDetails( ConnectionInfo &info, int &ret,
                                          const OXWindow *p, const OXWindow *m, int w, int h)
  : OXTransientFrame(p, m, 16, 16, 0)
  , connectionInfo( &info )
  , retCode( &ret )
{
  h += 32;

  OFontPool *fp = new OFontPool( _client );
  OXFont *font = fp->GetFont("-adobe-helvetica-medium-r-normal-*-11-*-*-*-*-*-*-*");

  ChangeOptions((GetOptions() & ~HORIZONTAL_FRAME) | VERTICAL_FRAME);

  OXCompositeFrame *frameTop = new OXCompositeFrame(this, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);

#include "../icons/top.xpm"
  const OPicture *back = _client->GetPicture( "top_xpm", top_xpm );
  frameTop->SetBackgroundPixmap( back->GetPicture() );
  _lh = new OLayoutHints(LHINTS_BOTTOM | LHINTS_EXPAND_X, 0, 0, 0, 0);
  AddFrame( frameTop, _lh );

#include "../icons/top_hexonet.xpm"
  const OPicture *hexonet = _client->GetPicture( "top_hexonet_xpm", top_hexonet_xpm );
  OXIcon *icon_hexonet = new OXIcon( frameTop, hexonet,
                                     hexonet->GetWidth(), hexonet->GetHeight() );
  _lh = new OLayoutHints(LHINTS_BOTTOM | LHINTS_LEFT, 0, 56, 0, 0);
  frameTop->AddFrame(icon_hexonet, _lh);

  buttonOK      = new OXTextButton(frameTop, new OHotString("&OK"), 101);
  buttonCancel  = new OXTextButton(frameTop, new OHotString("&Cancel"), 102);
  buttonOptions = new OXTextButton(frameTop, new OHotString("&Options..."), 103);
  
  buttonOK->SetBackgroundColor( _defaultFrameBackground );
  buttonCancel->SetBackgroundColor( _defaultFrameBackground );
  buttonOptions->SetBackgroundColor( _defaultFrameBackground );

  buttonOK->Associate(this);
  buttonCancel->Associate(this);
  buttonOptions->Associate(this);

  SetDefaultAcceptButton(buttonOK);
  SetDefaultCancelButton(buttonCancel);

  _lh = new OLayoutHints(LHINTS_LEFT | LHINTS_BOTTOM | LHINTS_EXPAND_X, 4, 1, 5, 6);
  frameTop->AddFrame( buttonOK, _lh );
  frameTop->AddFrame( buttonCancel, _lh );
  frameTop->AddFrame( buttonOptions, _lh );

  frameTop->Resize( frameTop->GetDefaultWidth(), frameTop->GetDefaultHeight());


  OXCompositeFrame *frameRow = new OXCompositeFrame(this, 60, 20, HORIZONTAL_FRAME | FIXED_WIDTH);


  frameServer = new OXCompositeFrame(frameRow, 60, 20, VERTICAL_FRAME | FIXED_WIDTH);

  comboBoxServer = new OXComboBox(frameServer, "", 200);
  char tmp[1024];
  sprintf( tmp, "%s:%i", info.host, info.display );
  comboBoxServer->SetText( tmp );
  comboBoxServer->GetTextEntry()->SetCursor( strlen( tmp ) );
  
  char inifilename[1024];
  sprintf( inifilename, "%s/.xrfbviewer", getenv( "HOME" ) );
  OIniFile inifile( inifilename, INI_READ );
  char section[256];
  while ( inifile.GetNext( section ) ) {
    if ( !strcasecmp( "server", section ) ) {
      char value[256];
      if ( inifile.GetItem( "0", value ) ) comboBoxServer->AddEntry( new OString( value ), 0 );
      if ( inifile.GetItem( "1", value ) ) comboBoxServer->AddEntry( new OString( value ), 1 );
      if ( inifile.GetItem( "2", value ) ) comboBoxServer->AddEntry( new OString( value ), 2 );
      if ( inifile.GetItem( "3", value ) ) comboBoxServer->AddEntry( new OString( value ), 3 );
      if ( inifile.GetItem( "4", value ) ) comboBoxServer->AddEntry( new OString( value ), 4 );
      if ( inifile.GetItem( "5", value ) ) comboBoxServer->AddEntry( new OString( value ), 5 );
      if ( inifile.GetItem( "6", value ) ) comboBoxServer->AddEntry( new OString( value ), 6 );
      if ( inifile.GetItem( "7", value ) ) comboBoxServer->AddEntry( new OString( value ), 7 );
      if ( inifile.GetItem( "8", value ) ) comboBoxServer->AddEntry( new OString( value ), 8 );
      if ( inifile.GetItem( "9", value ) ) comboBoxServer->AddEntry( new OString( value ), 9 );
    }
  }

  OXButton *buttonVNCFile = new OXTextButton( frameRow,
                                              new OHotString(".vnc &file..."),
					      104 );
  buttonVNCFile->Associate(this);
  
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_EXPAND_X, 0, 0, 0, 0);
  frameServer->AddFrame(comboBoxServer, _lh);

  labelSyntax = new OXLabel(frameServer,
                            new OString("Use: <host>[:<display>]\n"
		                        "e.g. rfbserver:1\n"
				        "(display defaults to 0 if not given)"
                                       ),
		            font
                           );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 4, 0, 2, 0);
  frameServer->AddFrame(labelSyntax, _lh);

  checkButtonRecordFBS = new OXCheckButton( frameServer, new OHotString("record video (fbs)"), -1 );
  checkButtonRecordFBS->SetTextColor( _client->GetColorByName( "darkred" ) );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 16, 0, 3, 0);
  frameServer->AddFrame(checkButtonRecordFBS, _lh);

  checkButtonRecordRFM = new OXCheckButton( frameServer, new OHotString("record macro (rfm)"), -1 );
  checkButtonRecordRFM->SetTextColor( _client->GetColorByName( "darkred" ) );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 16, 0, 2, 0);
  frameServer->AddFrame(checkButtonRecordRFM, _lh);



  frameServer->Resize( 200, frameServer->GetDefaultHeight() );

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_RIGHT, 0, 8, 8, 8);
  frameRow->AddFrame(buttonVNCFile, _lh);

  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_RIGHT, 4, 8, 8, 8);
  frameRow->AddFrame(frameServer, _lh);

  labelServer = new OXLabel(frameRow, new OString("RFB server:\n") );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_RIGHT, 8, 0, 12, 0);
  frameRow->AddFrame(labelServer, _lh);

/*
#include "../icons/rfb_viewer_small.xpm"
  const OPicture *logo = _client->GetPicture( "rfb_viewer_small_xpm", rfb_viewer_small_xpm );
  OXIcon *icon = new OXIcon( frameRow, logo, logo->GetWidth(), logo->GetHeight() );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_LEFT, 2, 2, 2, 2);
  frameRow->AddFrame(icon, _lh);
*/


  _lh = new OLayoutHints(LHINTS_EXPAND_X | LHINTS_EXPAND_Y, 0, 0, 0, 0);
  AddFrame(frameRow, _lh);



#include "../icons/right.xpm"
  const OPicture *right = _client->GetPicture( "right_xpm", right_xpm );
  OXIcon *icon_right = new OXIcon( frameTop, right,
                                     right->GetWidth(), right->GetHeight() );
  _lh = new OLayoutHints(LHINTS_BOTTOM | LHINTS_RIGHT, 0, 0, 0, 0);
  frameTop->AddFrame(icon_right, _lh);

  SetFocusOwner( comboBoxServer->GetTextEntry() );

  SetWindowName( "heXoNet RFB Viewer V" VERSION_xrfbviewer );

  Resize(GetDefaultSize());
  Resize(w, h);
  SetWMSize(w, h);
  SetWMSizeHints(w, h, w, h, 0, 0);
  MapSubwindows();

  Move((_client->GetDisplayWidth() - GetWidth()) >> 1,
       (_client->GetDisplayHeight() - GetHeight()) >> 1);

  SetMWMHints(MWM_DECOR_ALL | MWM_DECOR_MAXIMIZE | MWM_DECOR_MENU,
              MWM_FUNC_ALL | MWM_FUNC_MAXIMIZE | MWM_FUNC_RESIZE,
              MWM_INPUT_MODELESS);

     
  MapWindow();

  _client->WaitFor(this);
}






OXConnectionDetails::~OXConnectionDetails() {
  delete _lh;
}







int OXConnectionDetails::ProcessMessage(OMessage *msg) {
  OWidgetMessage *wmsg = (OWidgetMessage *) msg;

// Button OK
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == 101)) {
        char *tmp;
        char host[256];
        char display[256];
        tmp = strdup ( comboBoxServer->GetText() );
        char *ptr = strstr( tmp, ":" );
        if ( ptr ) {
          strcpy( display, ptr+1 );
          (*ptr) = 0;
          strcpy( host, tmp );
        } else {
          strcpy( host, tmp );
          strcpy( display, "0" );
        }
	free (tmp);

        strcpy( connectionInfo->host, host );
        connectionInfo->display = atoi( display );

        connectionInfo->recordFBS = ( checkButtonRecordFBS->GetState() == BUTTON_DOWN );
        connectionInfo->recordRFM = ( checkButtonRecordRFM->GetState() == BUTTON_DOWN );

        char inifilename[1024];
        snprintf( inifilename, sizeof (inifilename), "%s/.xrfbviewer",
		  getenv( "HOME" ) );
	writeConnectionInfo( inifilename, *connectionInfo );
        OIniFile inifile( inifilename, INI_APPEND );
	inifile.PutNewLine();
	char section[] = "server";
	inifile.PutNext( section );
        tmp = strdup ( comboBoxServer->GetText() );
	inifile.PutItem( "0", tmp );
	int i;
	int j = 0;
	for ( i = 1; i < 10; i++ ) {
	  const char *target = NULL;
	  const OXTextLBEntry *entry;
	  while ( j < 10 ) {
            const OXListBox *listBox = comboBoxServer->GetListBox();
	    entry = (OXTextLBEntry*) (((OXListBox*) listBox)->FindEntry(j));
	    if ( entry )
	      if ( strcasecmp( tmp, target = entry->GetText()->GetString() ) )
	        break;
            j++;
	  }
	  if ( j < 10 ) {
	    char server[3];
            char tmp[ strlen(target)+1 ];
            strcpy( tmp, target );
	    sprintf( server, "%i", i );
      	    inifile.PutItem( server, tmp );
	  }
	  else
	    i = 10;
          j++;
        }
	free (tmp);
        (*retCode) = 1;
	delete this;
      }

// Button Cancel
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == 102)) {
        delete this;
      }


// Button Options
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == 103)) {
        getConnectionOptions( *connectionInfo, GetParent(), this  );
      }

// Button .vnc file
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == 104)) {
          OFileInfo finfo;
          char *filetypes[] = { "VNC Connection Files [*.vnc]", "*.vnc",
                                "All Files",          "*" ,
                                NULL,                 NULL };
          finfo.file_types = filetypes;
          new OXFileDialog ( _client->GetRoot(),
                             this,
                             FDLG_OPEN, &finfo );                                        
      }

  return True;
}


}

