gnomeDialogSetDefault <-
function(dialog = NULL, button, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 button <- as.integer(button)

	 w <- .GtkCall("S_gnome_dialog_set_default", dialog, button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeScoresSetDefColor <-
function(gs = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_scores_set_def_color", gs, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppSetToolbar <-
function(app = NULL, toolbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(toolbar, "GtkToolbar")

	 w <- .GtkCall("S_gnome_app_set_toolbar", app, toolbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDISetChildListPath <-
function(mdi = NULL, path, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 path <- as.character(path)

	 w <- .GtkCall("S_gnome_mdi_set_child_list_path", mdi, path, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockGetClientArea <-
function(dock = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dock, "GnomeDock")

	 w <- .GtkCall("S_gnome_dock_get_client_area", dock, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIGetActiveView <-
function(mdi = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")

	 w <- .GtkCall("S_gnome_mdi_get_active_view", mdi, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDEntryEditClear <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_edit_clear", dee, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListUnselectIcon <-
function(gil = NULL, pos, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)

	 w <- .GtkCall("S_gnome_icon_list_unselect_icon", gil, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDateEditSetPopupRange <-
function(gde = NULL, low.hour, up.hour, .flush = TRUE)
{
	 gtkCheckInherits(gde, "GnomeDateEdit")
	 low.hour <- as.integer(low.hour)
	 up.hour <- as.integer(up.hour)

	 w <- .GtkCall("S_gnome_date_edit_set_popup_range", gde, low.hour, up.hour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppError <-
function(app = NULL, error, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 error <- as.character(error)

	 w <- .GtkCall("S_gnome_app_error", app, error, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDISetActiveView <-
function(mdi = NULL, view = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(view, "GtkWidget")

	 w <- .GtkCall("S_gnome_mdi_set_active_view", mdi, view, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkClockStart <-
function(gclock = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gclock, "GtkClock")

	 w <- .GtkCall("S_gtk_clock_start", gclock, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerSetPreviewText <-
function(gfp = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_font_picker_set_preview_text", gfp, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gNOMEAPPBARINTERACTIVE <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_GNOME_APPBAR_INTERACTIVE", appbar, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDEntryEditGetIcon <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_edit_get_icon", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAnimatorGetStatus <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_get_status", animator, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDEntryEditChild2 <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_edit_child2", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDEntryEditChild1 <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_edit_child1", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeColorPickerSetD <-
function(cp = NULL, r, g, b, a, .flush = TRUE)
{
	 gtkCheckInherits(cp, "GnomeColorPicker")
	 gtkCheckInherits(r, "double")
	 gtkCheckInherits(g, "double")
	 gtkCheckInherits(b, "double")
	 gtkCheckInherits(a, "double")

	 w <- .GtkCall("S_gnome_color_picker_set_d", cp, r, g, b, a, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeHRefGetLabel <-
function(href = NULL, .flush = TRUE)
{
	 gtkCheckInherits(href, "GnomeHRef")

	 w <- .GtkCall("S_gnome_href_get_label", href, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconEntryGtkEntry <-
function(ientry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ientry, "GnomeIconEntry")

	 w <- .GtkCall("S_gnome_icon_entry_gtk_entry", ientry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeScoresSetCurrentPlayer <-
function(gs = NULL, index, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 index <- as.integer(index)

	 w <- .GtkCall("S_gnome_scores_set_current_player", gs, index, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePaperSelectorGetLeftMargin <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_left_margin", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDialogEditableEnters <-
function(dialog = NULL, editable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 gtkCheckInherits(editable, "GtkEditable")

	 w <- .GtkCall("S_gnome_dialog_editable_enters", dialog, editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientSetCurrentDirectory <-
function(client = NULL, dir, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 dir <- as.character(dir)

	 w <- .GtkCall("S_gnome_client_set_current_directory", client, dir, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeLessShowFile <-
function(less = NULL, path, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 path <- as.character(path)

	 w <- .GtkCall("S_gnome_less_show_file", less, path, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePaperSelectorGetName <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_name", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeWarningDialog <-
function(message, .flush = TRUE)
{
	 message <- as.character(message)

	 w <- .GtkCall("S_gnome_warning_dialog", message, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppBarRefresh <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_gnome_appbar_refresh", appbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCalculatorClear <-
function(calc = NULL, reset, .flush = TRUE)
{
	 gtkCheckInherits(calc, "GnomeCalculator")
	 reset <- as.logical(reset)

	 w <- .GtkCall("S_gnome_calculator_clear", calc, reset, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorGetPlaybackDirection <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_get_playback_direction", animator, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIUnregister <-
function(mdi = NULL, obj = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(obj, "GtkObject")

	 w <- .GtkCall("S_gnome_mdi_unregister", mdi, obj, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeSpellKill <-
function(spell = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spell, "GnomeSpell")

	 w <- .GtkCall("S_gnome_spell_kill", spell, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorSetPlaybackDirection <-
function(animator = NULL, playback.direction, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 playback.direction <- as.integer(playback.direction)

	 w <- .GtkCall("S_gnome_animator_set_playback_direction", animator, playback.direction, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDEntryEditGetName <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_edit_get_name", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClonedClient <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gnome_cloned_client", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDialSetPercentage <-
function(dial = NULL, percent, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")
	 percent <- as.numeric(percent)

	 w <- .GtkCall("S_gtk_dial_set_percentage", dial, percent, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetTextColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_text_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeLessNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_less_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeLess", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeAppBarSetPrompt <-
function(appbar = NULL, prompt, modal, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")
	 prompt <- as.character(prompt)
	 modal <- as.logical(modal)

	 w <- .GtkCall("S_gnome_appbar_set_prompt", appbar, prompt, modal, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerUwSetWidget <-
function(gfp = NULL, widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gnome_font_picker_uw_set_widget", gfp, widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppRemoveMenuRange <-
function(app = NULL, path, start, items, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 path <- as.character(path)
	 start <- as.integer(start)
	 items <- as.integer(items)

	 w <- .GtkCall("S_gnome_app_remove_menu_range", app, path, start, items, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePropertyBoxAppendPage <-
function(property.box = NULL, child = NULL, tab.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(property.box, "GnomePropertyBox")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")

	 w <- .GtkCall("S_gnome_property_box_append_page", property.box, child, tab.label, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCanvasItemGrab <-
function(item = NULL, mask, cursor = NULL, etime, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")
	 mask  <- mapGdkEventMask(mask)
	 gtkCheckInherits(cursor, "GdkCursor")
	 etime <- as.integer(etime)

	 w <- .GtkCall("S_gnome_canvas_item_grab", item, mask, cursor, etime, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageBack <-
function(druid.page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid.page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_page_back", druid.page, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIGetViewFromWindow <-
function(mdi = NULL, app.win = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(app.win, "GnomeApp")

	 w <- .GtkCall("S_gnome_mdi_get_view_from_window", mdi, app.win, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIAddToplevelView <-
function(mdi = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(child, "GnomeMDIChild")

	 w <- .GtkCall("S_gnome_mdi_add_toplevel_view", mdi, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDialSetUpdatePolicy <-
function(dial = NULL, policy = GtkUpdateType[1], .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")
	 policy  <- mapGtkUpdateType(policy)

	 w <- .GtkCall("S_gtk_dial_set_update_policy", dial, policy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorAppendFramesFromFileAtSize <-
function(animator = NULL, name, x.offset, y.offset, interval, x.unit, width, height, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 name <- as.character(name)
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)
	 x.unit <- as.integer(x.unit)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_animator_append_frames_from_file_at_size", animator, name, x.offset, y.offset, interval, x.unit, width, height, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePaperSelectorGetWidth <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_width", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockItemSetShadowType <-
function(item = NULL, type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")
	 type  <- mapGtkShadowType(type)

	 w <- .GtkCall("S_gnome_dock_item_set_shadow_type", item, type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkClockSetFormat <-
function(gclock = NULL, fmt, .flush = TRUE)
{
	 gtkCheckInherits(gclock, "GtkClock")
	 fmt <- as.character(fmt)

	 w <- .GtkCall("S_gtk_clock_set_format", gclock, fmt, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeNumberEntrySetTitle <-
function(nentry = NULL, calc.dialog.title, .flush = TRUE)
{
	 gtkCheckInherits(nentry, "GnomeNumberEntry")
	 calc.dialog.title <- as.character(calc.dialog.title)

	 w <- .GtkCall("S_gnome_number_entry_set_title", nentry, calc.dialog.title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorAppendFrameFromFile <-
function(animator = NULL, name, x.offset, y.offset, interval, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 name <- as.character(name)
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)

	 w <- .GtkCall("S_gnome_animator_append_frame_from_file", animator, name, x.offset, y.offset, interval, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientGetGlobalConfigPrefix <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_get_global_config_prefix", client, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeStockOrOrdinaryButton <-
function(type, .flush = TRUE)
{
	 type <- as.character(type)

	 w <- .GtkCall("S_gnome_stock_or_ordinary_button", type, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockBandPrepend <-
function(band = NULL, child = NULL, offset, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(child, "GtkWidget")
	 offset <- as.integer(offset)

	 w <- .GtkCall("S_gnome_dock_band_prepend", band, child, offset, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockBandInsert <-
function(band = NULL, child = NULL, offset, position, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(child, "GtkWidget")
	 offset <- as.integer(offset)
	 position <- as.integer(position)

	 w <- .GtkCall("S_gnome_dock_band_insert", band, child, offset, position, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDentryGetTryexecEntry <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_get_tryexec_entry", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_druid_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruid", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkDialGetAdjustment <-
function(dial = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")

	 w <- .GtkCall("S_gtk_dial_get_adjustment", dial, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientSetEnvironment <-
function(client = NULL, name, value, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 name <- as.character(name)
	 value <- as.character(value)

	 w <- .GtkCall("S_gnome_client_set_environment", client, name, value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarSetProgress <-
function(appbar = NULL, percentage, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")
	 percentage <- as.numeric(percentage)

	 w <- .GtkCall("S_gnome_appbar_set_progress", appbar, percentage, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidAppendPage <-
function(druid = NULL, page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid, "GnomeDruid")
	 gtkCheckInherits(page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_append_page", druid, page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogSetAccelerator <-
function(dialog = NULL, button, accelerator.key, accelerator.mods, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 button <- as.integer(button)
	 accelerator.key <- as.integer(accelerator.key)
	 accelerator.mods  <- mapGdkModifierType(accelerator.mods)

	 w <- .GtkCall("S_gnome_dialog_set_accelerator", dialog, button, accelerator.key, accelerator.mods, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeStockTransparentWindow <-
function(icon, subtype, .flush = TRUE)
{
	 icon <- as.character(icon)
	 subtype <- as.character(subtype)

	 w <- .GtkCall("S_gnome_stock_transparent_window", icon, subtype, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeEntryLoadHistory <-
function(gentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gentry, "GnomeEntry")

	 w <- .GtkCall("S_gnome_entry_load_history", gentry, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePaperSelectorGetTopMargin <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_top_margin", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeNumberEntryGnomeEntry <-
function(nentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(nentry, "GnomeNumberEntry")

	 w <- .GtkCall("S_gnome_number_entry_gnome_entry", nentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconTextItemGetText <-
function(iti = NULL, .flush = TRUE)
{
	 gtkCheckInherits(iti, "GnomeIconTextItem")

	 w <- .GtkCall("S_gnome_icon_text_item_get_text", iti, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeColorPickerSetUseAlpha <-
function(cp = NULL, use.alpha, .flush = TRUE)
{
	 gtkCheckInherits(cp, "GnomeColorPicker")
	 use.alpha <- as.logical(use.alpha)

	 w <- .GtkCall("S_gnome_color_picker_set_use_alpha", cp, use.alpha, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetText <-
function(page = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_druid_page_finish_set_text", page, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIRemoveView <-
function(mdi = NULL, view = NULL, force, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(view, "GtkWidget")
	 force <- as.integer(force)

	 w <- .GtkCall("S_gnome_mdi_remove_view", mdi, view, force, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStartSetWatermark <-
function(page = NULL, image, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_druid_page_start_set_watermark", page, image, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapEntryNew <-
function(history.id, browse.dialog.title, do.preview, show = TRUE, .flush = TRUE)
{
	 history.id <- as.character(history.id)
	 browse.dialog.title <- as.character(browse.dialog.title)
	 do.preview <- as.logical(do.preview)

	 w <- .GtkCall("S_gnome_pixmap_entry_new", history.id, browse.dialog.title, do.preview, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePixmapEntry", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeClientConnect <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_connect", client, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapEntryGnomeEntry <-
function(pentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")

	 w <- .GtkCall("S_gnome_pixmap_entry_gnome_entry", pentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDialGetValue <-
function(dial = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")

	 w <- .GtkCall("S_gtk_dial_get_value", dial, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockBandGetNumChildren <-
function(band = NULL, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")

	 w <- .GtkCall("S_gnome_dock_band_get_num_children", band, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAnimatorAdvance <-
function(animator = NULL, num, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 num <- as.integer(num)

	 w <- .GtkCall("S_gnome_animator_advance", animator, num, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientSetProgram <-
function(client = NULL, program, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 program <- as.character(program)

	 w <- .GtkCall("S_gnome_client_set_program", client, program, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientGetId <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_get_id", client, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppRemoveMenus <-
function(app = NULL, path, items, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 path <- as.character(path)
	 items <- as.integer(items)

	 w <- .GtkCall("S_gnome_app_remove_menus", app, path, items, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeEntrySetHistoryId <-
function(gentry = NULL, history.id, .flush = TRUE)
{
	 gtkCheckInherits(gentry, "GnomeEntry")
	 history.id <- as.character(history.id)

	 w <- .GtkCall("S_gnome_entry_set_history_id", gentry, history.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeSpellNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_spell_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeSpell", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDockNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_dock_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDock", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomePixmapEntrySetPreview <-
function(pentry = NULL, do.preview, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")
	 do.preview <- as.logical(do.preview)

	 w <- .GtkCall("S_gnome_pixmap_entry_set_preview", pentry, do.preview, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemUngrab <-
function(item = NULL, etime, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")
	 etime <- as.integer(etime)

	 w <- .GtkCall("S_gnome_canvas_item_ungrab", item, etime, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorNewWithSize <-
function(width, height, show = TRUE, .flush = TRUE)
{
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_animator_new_with_size", width, height, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeAnimator", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeLessSetFixedFont <-
function(less = NULL, fixed, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 fixed <- as.logical(fixed)

	 w <- .GtkCall("S_gnome_less_set_fixed_font", less, fixed, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStartSetBgColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_start_set_bg_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_dock_band_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDockBand", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeIconSelectionShowIcons <-
function(gis = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gis, "GnomeIconSelection")

	 w <- .GtkCall("S_gnome_icon_selection_show_icons", gis, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemGrabFocus <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")

	 w <- .GtkCall("S_gnome_canvas_item_grab_focus", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerSetTitle <-
function(gfp = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_font_picker_set_title", gfp, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarGetResponse <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_gnome_appbar_get_response", appbar, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppBarPop <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_gnome_appbar_pop", appbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeNumberEntryGetNumber <-
function(nentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(nentry, "GnomeNumberEntry")

	 w <- .GtkCall("S_gnome_number_entry_get_number", nentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStandardSetTitle <-
function(page = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStandard")
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_druid_page_standard_set_title", page, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandDragEnd <-
function(band = NULL, item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_band_drag_end", band, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppGetDockItemByName <-
function(app = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 name <- as.character(name)

	 w <- .GtkCall("S_gnome_app_get_dock_item_by_name", app, name, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeHRefNew <-
function(url, label = NULL, show = TRUE, .flush = TRUE)
{
	 url <- as.character(url)
	 label <- as.character(label)

	 w <- .GtkCall("S_gnome_href_new", url, label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeHRef", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeStockNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_stock_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeStock", "GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeFontPickerFiSetShowSize <-
function(gfp = NULL, show.size, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 show.size <- as.logical(show.size)

	 w <- .GtkCall("S_gnome_font_picker_fi_set_show_size", gfp, show.size, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFileEntrySetDefaultPath <-
function(fentry = NULL, path, .flush = TRUE)
{
	 gtkCheckInherits(fentry, "GnomeFileEntry")
	 path <- as.character(path)

	 w <- .GtkCall("S_gnome_file_entry_set_default_path", fentry, path, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIAddChild <-
function(mdi = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(child, "GnomeMDIChild")

	 w <- .GtkCall("S_gnome_mdi_add_child", mdi, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientSetId <-
function(client = NULL, client.id, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 client.id <- as.character(client.id)

	 w <- .GtkCall("S_gnome_client_set_id", client, client.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeLessShowFilestream <-
function(less = NULL, fp, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 gtkCheckInherits(fp, "FILE")

	 w <- .GtkCall("S_gnome_less_show_filestream", less, fp, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIGetActiveChild <-
function(mdi = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")

	 w <- .GtkCall("S_gnome_mdi_get_active_child", mdi, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDateEditGetFlags <-
function(gde = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gde, "GnomeDateEdit")

	 w <- .GtkCall("S_gnome_date_edit_get_flags", gde, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockItemGetChild <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_item_get_child", item, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTedAdd <-
function(ted = NULL, widget = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(ted, "GtkTed")
	 gtkCheckInherits(widget, "GtkWidget")
	 name <- as.character(name)

	 w <- .GtkCall("S_gtk_ted_add", ted, widget, name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientGetPreviousId <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_get_previous_id", client, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientSetPriority <-
function(client = NULL, priority, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 priority <- as.integer(priority)

	 w <- .GtkCall("S_gnome_client_set_priority", client, priority, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeInteractionKeyReturn <-
function(key, cancel.shutdown, .flush = TRUE)
{
	 key <- as.integer(key)
	 cancel.shutdown <- as.logical(cancel.shutdown)

	 w <- .GtkCall("S_gnome_interaction_key_return", key, cancel.shutdown, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageCancel <-
function(druid.page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid.page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_page_cancel", druid.page, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCalculatorSet <-
function(calc = NULL, result, .flush = TRUE)
{
	 gtkCheckInherits(calc, "GnomeCalculator")
	 gtkCheckInherits(result, "double")

	 w <- .GtkCall("S_gnome_calculator_set", calc, result, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetIconWidth <-
function(gil = NULL, width, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 width <- as.integer(width)

	 w <- .GtkCall("S_gnome_icon_list_set_icon_width", gil, width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetWatermark <-
function(page = NULL, image, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_watermark", page, image, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasUpdateNow <-
function(canvas = NULL, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")

	 w <- .GtkCall("S_gnome_canvas_update_now", canvas, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListAppendImlib <-
function(gil = NULL, image, text, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 gtkCheckInherits(image, "GdkImlibImage")
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_icon_list_append_imlib", gil, image, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientSetRestartStyle <-
function(client = NULL, style = GnomeRestartStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 style  <- mapGnomeRestartStyle(style)

	 w <- .GtkCall("S_gnome_client_set_restart_style", client, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIRegister <-
function(mdi = NULL, obj = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(obj, "GtkObject")

	 w <- .GtkCall("S_gnome_mdi_register", mdi, obj, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_font_picker_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeFontPicker", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageStartSetTitleColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_start_set_title_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeEntryGtkEntry <-
function(gentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gentry, "GnomeEntry")

	 w <- .GtkCall("S_gnome_entry_gtk_entry", gentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStandardSetTitleColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStandard")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_standard_set_title_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemLowerToBottom <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")

	 w <- .GtkCall("S_gnome_canvas_item_lower_to_bottom", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetTextboxColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_textbox_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetLogoBgColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_logo_bg_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDialSetViewOnly <-
function(dial = NULL, view.only, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")
	 view.only <- as.logical(view.only)

	 w <- .GtkCall("S_gtk_dial_set_view_only", dial, view.only, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorAppendFrameFromImlib <-
function(animator = NULL, image, x.offset, y.offset, interval, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 gtkCheckInherits(image, "GdkImlibImage")
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)

	 w <- .GtkCall("S_gnome_animator_append_frame_from_imlib", animator, image, x.offset, y.offset, interval, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconEntryNew <-
function(history.id, browse.dialog.title, show = TRUE, .flush = TRUE)
{
	 history.id <- as.character(history.id)
	 browse.dialog.title <- as.character(browse.dialog.title)

	 w <- .GtkCall("S_gnome_icon_entry_new", history.id, browse.dialog.title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeIconEntry", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDockBandGetChildOffset <-
function(band = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gnome_dock_band_get_child_offset", band, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientDisconnect <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_disconnect", client, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppAddDockItem <-
function(app = NULL, item = NULL, placement = GnomeDockPlacement[1], band.num, band.position, offset, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(item, "GnomeDockItem")
	 placement  <- mapGnomeDockPlacement(placement)
	 band.num <- as.integer(band.num)
	 band.position <- as.integer(band.position)
	 offset <- as.integer(offset)

	 w <- .GtkCall("S_gnome_app_add_dock_item", app, item, placement, band.num, band.position, offset, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockItemGetBehavior <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_item_get_behavior", item, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppBarSetStatus <-
function(appbar = NULL, status, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")
	 status <- as.character(status)

	 w <- .GtkCall("S_gnome_appbar_set_status", appbar, status, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStartSetText <-
function(page = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_druid_page_start_set_text", page, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconTextItemSelect <-
function(iti = NULL, sel, .flush = TRUE)
{
	 gtkCheckInherits(iti, "GnomeIconTextItem")
	 sel <- as.integer(sel)

	 w <- .GtkCall("S_gnome_icon_text_item_select", iti, sel, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerSetMode <-
function(gfp = NULL, mode = GnomeFontPickerMode[1], .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 mode  <- mapGnomeFontPickerMode(mode)

	 w <- .GtkCall("S_gnome_font_picker_set_mode", gfp, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListRemove <-
function(gil = NULL, pos, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)

	 w <- .GtkCall("S_gnome_icon_list_remove", gil, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeLessSetFont <-
function(less = NULL, font = NULL, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 gtkCheckInherits(font, "GdkFont")

	 w <- .GtkCall("S_gnome_less_set_font", less, font, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListGetIconAt <-
function(gil = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gnome_icon_list_get_icon_at", gil, x, y, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidSetPage <-
function(druid = NULL, page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid, "GnomeDruid")
	 gtkCheckInherits(page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_set_page", druid, page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerGetFontName <-
function(gfp = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")

	 w <- .GtkCall("S_gnome_font_picker_get_font_name", gfp, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIChildRemoveView <-
function(mdic = NULL, view = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdic, "GnomeMDIChild")
	 gtkCheckInherits(view, "GtkWidget")

	 w <- .GtkCall("S_gnome_mdi_child_remove_view", mdic, view, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorGetLoopType <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_get_loop_type", animator, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkClockSetSeconds <-
function(gclock = NULL, seconds, .flush = TRUE)
{
	 gtkCheckInherits(gclock, "GtkClock")
	 seconds <- as.integer(seconds)

	 w <- .GtkCall("S_gtk_clock_set_seconds", gclock, seconds, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapEntryGnomeFileEntry <-
function(pentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")

	 w <- .GtkCall("S_gnome_pixmap_entry_gnome_file_entry", pentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAnimatorAppendFrameFromGnomePixmap <-
function(animator = NULL, pixmap = NULL, x.offset, y.offset, interval, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 gtkCheckInherits(pixmap, "GnomePixmap")
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)

	 w <- .GtkCall("S_gnome_animator_append_frame_from_gnome_pixmap", animator, pixmap, x.offset, y.offset, interval, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIGenericChildNew <-
function(name, .flush = TRUE)
{
	 name <- as.character(name)

	 w <- .GtkCall("S_gnome_mdi_generic_child_new", name, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeMDIGenericChild", "GnomeMDIChild", "GtkObject")
	 return(w)

}
 

gnomeDruidPageStandardSetBgColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStandard")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_standard_set_bg_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDateEditSetFlags <-
function(gde = NULL, flags, .flush = TRUE)
{
	 gtkCheckInherits(gde, "GnomeDateEdit")
	 flags  <- mapGnomeDateEditFlags(flags)

	 w <- .GtkCall("S_gnome_date_edit_set_flags", gde, flags, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDINew <-
function(appname, title, .flush = TRUE)
{
	 appname <- as.character(appname)
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_mdi_new", appname, title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeMDI", "GtkObject")
	 return(w)

}
 

gnomeOkDialogParented <-
function(message, parent = NULL, .flush = TRUE)
{
	 message <- as.character(message)
	 gtkCheckInherits(parent, "GtkWindow")

	 w <- .GtkCall("S_gnome_ok_dialog_parented", message, parent, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStartSetLogoBgColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_start_set_logo_bg_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkClockNew <-
function(type = GtkClockType[1], show = TRUE, .flush = TRUE)
{
	 type  <- mapGtkClockType(type)

	 w <- .GtkCall("S_gtk_clock_new", type, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkClock", "GtkLabel", "GtkMisc", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeClientRequestPhase2 <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_request_phase_2", client, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppFlash <-
function(app = NULL, flash, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 flash <- as.character(flash)

	 w <- .GtkCall("S_gnome_app_flash", app, flash, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasScrollTo <-
function(canvas = NULL, cx, cy, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")
	 cx <- as.integer(cx)
	 cy <- as.integer(cy)

	 w <- .GtkCall("S_gnome_canvas_scroll_to", canvas, cx, cy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeErrorDialog <-
function(message, .flush = TRUE)
{
	 message <- as.character(message)

	 w <- .GtkCall("S_gnome_error_dialog", message, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeStockMenuItem <-
function(type, text, .flush = TRUE)
{
	 type <- as.character(type)
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_stock_menu_item", type, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppEnableLayoutConfig <-
function(app = NULL, enable, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 enable <- as.logical(enable)

	 w <- .GtkCall("S_gnome_app_enable_layout_config", app, enable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageNext <-
function(druid.page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid.page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_page_next", druid.page, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePaperSelectorNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_paper_selector_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePaperSelector", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomePixmapLoadImlib <-
function(gpixmap = NULL, image, .flush = TRUE)
{
	 gtkCheckInherits(gpixmap, "GnomePixmap")
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_pixmap_load_imlib", gpixmap, image, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarClearPrompt <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_gnome_appbar_clear_prompt", appbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDentryGetExecEntry <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_get_exec_entry", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIOpenToplevel <-
function(mdi = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")

	 w <- .GtkCall("S_gnome_mdi_open_toplevel", mdi, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconEntrySetPixmapSubdir <-
function(ientry = NULL, subdir, .flush = TRUE)
{
	 gtkCheckInherits(ientry, "GnomeIconEntry")
	 subdir <- as.character(subdir)

	 w <- .GtkCall("S_gnome_icon_entry_set_pixmap_subdir", ientry, subdir, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTedSetAppName <-
function(appname, .flush = TRUE)
{
	 appname <- as.character(appname)

	 w <- .GtkCall("S_gtk_ted_set_app_name", appname, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeColorPickerNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_color_picker_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeColorPicker", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageFinishNewWithVals <-
function(title = NULL, text = NULL, logo = NULL, watermark = NULL, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)
	 text <- as.character(text)
	 gtkCheckInherits(logo, "GdkImlibImage", nullOk = TRUE)
	 gtkCheckInherits(watermark, "GdkImlibImage", nullOk = TRUE)

	 w <- .GtkCall("S_gnome_druid_page_finish_new_with_vals", title, text, logo, watermark, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruidPageFinish", "GnomeDruidPage", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDEntryEditNew <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gnome_dentry_edit_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDEntryEdit", "GtkObject")
	 return(w)

}
 

gnomeAnimatorGetPlaybackSpeed <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_get_playback_speed", animator, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStandardSetLogoBgColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStandard")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_standard_set_logo_bg_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockItemNew <-
function(name, behavior, show = TRUE, .flush = TRUE)
{
	 name <- as.character(name)
	 behavior  <- mapGnomeDockItemBehavior(behavior)

	 w <- .GtkCall("S_gnome_dock_item_new", name, behavior, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDockItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomePaperSelectorGetRightMargin <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_right_margin", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockAddItem <-
function(dock = NULL, item = NULL, placement = GnomeDockPlacement[1], band.num, position, offset, in.new.band, .flush = TRUE)
{
	 gtkCheckInherits(dock, "GnomeDock")
	 gtkCheckInherits(item, "GnomeDockItem")
	 placement  <- mapGnomeDockPlacement(placement)
	 band.num <- as.integer(band.num)
	 position <- as.integer(position)
	 offset <- as.integer(offset)
	 in.new.band <- as.logical(in.new.band)

	 w <- .GtkCall("S_gnome_dock_add_item", dock, item, placement, band.num, position, offset, in.new.band, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeStockNewWithIcon <-
function(icon, show = TRUE, .flush = TRUE)
{
	 icon <- as.character(icon)

	 w <- .GtkCall("S_gnome_stock_new_with_icon", icon, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeStock", "GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageFinishSetTitle <-
function(page = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_druid_page_finish_set_title", page, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetSeparators <-
function(gil = NULL, separators, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 separators <- as.character(separators)

	 w <- .GtkCall("S_gnome_icon_list_set_separators", gil, separators, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDialGetPercentage <-
function(dial = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")

	 w <- .GtkCall("S_gtk_dial_get_percentage", dial, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDentryGetDocEntry <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_get_doc_entry", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconListSetColSpacing <-
function(gil = NULL, pixels, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pixels <- as.integer(pixels)

	 w <- .GtkCall("S_gnome_icon_list_set_col_spacing", gil, pixels, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeScoresSetColor <-
function(gs = NULL, pos, colour, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 pos <- as.integer(pos)
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_scores_set_color", gs, pos, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapLoadFileAtSize <-
function(gpixmap = NULL, filename, width, height, .flush = TRUE)
{
	 gtkCheckInherits(gpixmap, "GnomePixmap")
	 filename <- as.character(filename)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_pixmap_load_file_at_size", gpixmap, filename, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasSetPixelsPerUnit <-
function(canvas = NULL, n, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")
	 gtkCheckInherits(n, "double")

	 w <- .GtkCall("S_gnome_canvas_set_pixels_per_unit", canvas, n, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogCloseHides <-
function(dialog = NULL, just.hide, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 just.hide <- as.logical(just.hide)

	 w <- .GtkCall("S_gnome_dialog_close_hides", dialog, just.hide, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeScoresDisplay <-
function(title, app.name, level, pos, .flush = TRUE)
{
	 title <- as.character(title)
	 app.name <- as.character(app.name)
	 level <- as.character(level)
	 pos <- as.integer(pos)

	 w <- .GtkCall("S_gnome_scores_display", title, app.name, level, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDISetMode <-
function(mdi = NULL, mode = GnomeMDIMode[1], .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 mode  <- mapGnomeMDIMode(mode)

	 w <- .GtkCall("S_gnome_mdi_set_mode", mdi, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconEntryGetFilename <-
function(ientry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ientry, "GnomeIconEntry")

	 w <- .GtkCall("S_gnome_icon_entry_get_filename", ientry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePropertyBoxChanged <-
function(property.box = NULL, .flush = TRUE)
{
	 gtkCheckInherits(property.box, "GnomePropertyBox")

	 w <- .GtkCall("S_gnome_property_box_changed", property.box, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorGetCurrentFrameNumber <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_get_current_frame_number", animator, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockItemGetOrientation <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_item_get_orientation", item, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeFileEntrySetModal <-
function(fentry = NULL, is.modal, .flush = TRUE)
{
	 gtkCheckInherits(fentry, "GnomeFileEntry")
	 is.modal <- as.logical(is.modal)

	 w <- .GtkCall("S_gnome_file_entry_set_modal", fentry, is.modal, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientNew <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gnome_client_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeClient", "GtkObject")
	 return(w)

}
 

gnomeDruidSetButtonsSensitive <-
function(druid = NULL, back.sensitive, next.sensitive, cancel.sensitive, .flush = TRUE)
{
	 gtkCheckInherits(druid, "GnomeDruid")
	 back.sensitive <- as.logical(back.sensitive)
	 next.sensitive <- as.logical(next.sensitive)
	 cancel.sensitive <- as.logical(cancel.sensitive)

	 w <- .GtkCall("S_gnome_druid_set_buttons_sensitive", druid, back.sensitive, next.sensitive, cancel.sensitive, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockSetClientArea <-
function(dock = NULL, widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dock, "GnomeDock")
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gnome_dock_set_client_area", dock, widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFileEntryNew <-
function(history.id, browse.dialog.title, show = TRUE, .flush = TRUE)
{
	 history.id <- as.character(history.id)
	 browse.dialog.title <- as.character(browse.dialog.title)

	 w <- .GtkCall("S_gnome_file_entry_new", history.id, browse.dialog.title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeFileEntry", "GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeHRefGetUrl <-
function(href = NULL, .flush = TRUE)
{
	 gtkCheckInherits(href, "GnomeHRef")

	 w <- .GtkCall("S_gnome_href_get_url", href, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDialNew <-
function(adjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_dial_new", adjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkDial", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeLessShowCommand <-
function(less = NULL, command.line, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 command.line <- as.character(command.line)

	 w <- .GtkCall("S_gnome_less_show_command", less, command.line, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIGetAppFromView <-
function(view = NULL, .flush = TRUE)
{
	 gtkCheckInherits(view, "GtkWidget")

	 w <- .GtkCall("S_gnome_mdi_get_app_from_view", view, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeNumberEntryNew <-
function(history.id, calc.dialog.title, show = TRUE, .flush = TRUE)
{
	 history.id <- as.character(history.id)
	 calc.dialog.title <- as.character(calc.dialog.title)

	 w <- .GtkCall("S_gnome_number_entry_new", history.id, calc.dialog.title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeNumberEntry", "GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDialogSetClose <-
function(dialog = NULL, click.closes, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 click.closes <- as.logical(click.closes)

	 w <- .GtkCall("S_gnome_dialog_set_close", dialog, click.closes, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkClockStop <-
function(gclock = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gclock, "GtkClock")

	 w <- .GtkCall("S_gtk_clock_stop", gclock, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemShow <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")

	 w <- .GtkCall("S_gnome_canvas_item_show", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconSelectionAddDirectory <-
function(gis = NULL, dir, .flush = TRUE)
{
	 gtkCheckInherits(gis, "GnomeIconSelection")
	 dir <- as.character(dir)

	 w <- .GtkCall("S_gnome_icon_selection_add_directory", gis, dir, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStartNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_druid_page_start_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruidPageStart", "GnomeDruidPage", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeCanvasItemLower <-
function(item = NULL, positions, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")
	 positions <- as.integer(positions)

	 w <- .GtkCall("S_gnome_canvas_item_lower", item, positions, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogSetSensitive <-
function(dialog = NULL, button, setting, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 button <- as.integer(button)
	 setting <- as.logical(setting)

	 w <- .GtkCall("S_gnome_dialog_set_sensitive", dialog, button, setting, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapNewFromGnomePixmap <-
function(gpixmap = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(gpixmap, "GnomePixmap")

	 w <- .GtkCall("S_gnome_pixmap_new_from_gnome_pixmap", gpixmap, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDockItemSetOrientation <-
function(item = NULL, orientation = GtkOrientation[1], .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")
	 orientation  <- mapGtkOrientation(orientation)

	 w <- .GtkCall("S_gnome_dock_item_set_orientation", item, orientation, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconSelectionClear <-
function(gis = NULL, not.shown, .flush = TRUE)
{
	 gtkCheckInherits(gis, "GnomeIconSelection")
	 not.shown <- as.logical(not.shown)

	 w <- .GtkCall("S_gnome_icon_selection_clear", gis, not.shown, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorStop <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_stop", animator, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppNew <-
function(appname, title, show = TRUE, .flush = TRUE)
{
	 appname <- as.character(appname)
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_app_new", appname, title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeApp", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDockAddFloatingItem <-
function(dock = NULL, item = NULL, x, y, orientation = GtkOrientation[1], .flush = TRUE)
{
	 gtkCheckInherits(dock, "GnomeDock")
	 gtkCheckInherits(item, "GnomeDockItem")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 orientation  <- mapGtkOrientation(orientation)

	 w <- .GtkCall("S_gnome_dock_add_floating_item", dock, item, x, y, orientation, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasREquestRedraw <-
function(canvas = NULL, x1, y1, x2, y2, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")
	 x1 <- as.integer(x1)
	 y1 <- as.integer(y1)
	 x2 <- as.integer(x2)
	 y2 <- as.integer(y2)

	 w <- .GtkCall("S_gnome_canvas_request_redraw", canvas, x1, y1, x2, y2, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetVadjustment <-
function(gil = NULL, vadj = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 gtkCheckInherits(vadj, "GtkAdjustment")

	 w <- .GtkCall("S_gnome_icon_list_set_vadjustment", gil, vadj, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandDragBegin <-
function(band = NULL, item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_band_drag_begin", band, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetSelectionMode <-
function(gil = NULL, mode = GtkSelectionMode[1], .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 mode  <- mapGtkSelectionMode(mode)

	 w <- .GtkCall("S_gnome_icon_list_set_selection_mode", gil, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorSetPlaybackSpeed <-
function(animator = NULL, speed, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 gtkCheckInherits(speed, "double")

	 w <- .GtkCall("S_gnome_animator_set_playback_speed", animator, speed, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeGuruCurrentPage <-
function(guru = NULL, .flush = TRUE)
{
	 gtkCheckInherits(guru, "GnomeGuru")

	 w <- .GtkCall("S_gnome_guru_current_page", guru, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCanvasNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_canvas_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeCanvas", "GtkLayout", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkDialSetAdjustment <-
function(dial = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_dial_set_adjustment", dial, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIGetActiveWindow <-
function(mdi = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")

	 w <- .GtkCall("S_gnome_mdi_get_active_window", mdi, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDialogRunAndClose <-
function(dialog = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")

	 w <- .GtkCall("S_gnome_dialog_run_and_close", dialog, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppAddDocked <-
function(app = NULL, widget = NULL, name, behavior, placement = GnomeDockPlacement[1], band.num, band.position, offset, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(widget, "GtkWidget")
	 name <- as.character(name)
	 behavior  <- mapGnomeDockItemBehavior(behavior)
	 placement  <- mapGnomeDockPlacement(placement)
	 band.num <- as.integer(band.num)
	 band.position <- as.integer(band.position)
	 offset <- as.integer(offset)

	 w <- .GtkCall("S_gnome_app_add_docked", app, widget, name, behavior, placement, band.num, band.position, offset, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppWarning <-
function(app = NULL, warning, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 warning <- as.character(warning)

	 w <- .GtkCall("S_gnome_app_warning", app, warning, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapButton <-
function(pixmap = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(pixmap, "GtkWidget")
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_pixmap_button", pixmap, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCanvasRoot <-
function(canvas = NULL, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")

	 w <- .GtkCall("S_gnome_canvas_root", canvas, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconListClear <-
function(gil = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")

	 w <- .GtkCall("S_gnome_icon_list_clear", gil, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapLoadImlibAtSize <-
function(gpixmap = NULL, image, width, height, .flush = TRUE)
{
	 gtkCheckInherits(gpixmap, "GnomePixmap")
	 gtkCheckInherits(image, "GdkImlibImage")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_pixmap_load_imlib_at_size", gpixmap, image, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockAllowFloatingItems <-
function(dock = NULL, enable, .flush = TRUE)
{
	 gtkCheckInherits(dock, "GnomeDock")
	 enable <- as.logical(enable)

	 w <- .GtkCall("S_gnome_dock_allow_floating_items", dock, enable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogNew <-
function(title, b1 = NULL, b2 = NULL, b3 = NULL, b4 = NULL, b5 = NULL, b6 = NULL, b7 = NULL, b8 = NULL, b9 = NULL, b10 = NULL, b11 = NULL, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)
	 b1 <- as.character(b1)
	 b2 <- as.character(b2)
	 b3 <- as.character(b3)
	 b4 <- as.character(b4)
	 b5 <- as.character(b5)
	 b6 <- as.character(b6)
	 b7 <- as.character(b7)
	 b8 <- as.character(b8)
	 b9 <- as.character(b9)
	 b10 <- as.character(b10)
	 b11 <- as.character(b11)

	 w <- .GtkCall("S_gnome_dialog_new", title, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkDialSetValue <-
function(dial = NULL, value, .flush = TRUE)
{
	 gtkCheckInherits(dial, "GtkDial")
	 value <- as.numeric(value)

	 w <- .GtkCall("S_gtk_dial_set_value", dial, value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPrependPage <-
function(druid = NULL, page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid, "GnomeDruid")
	 gtkCheckInherits(page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_prepend_page", druid, page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePaperSelectorGetHeight <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_height", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTedNew <-
function(dialog.name, show = TRUE, .flush = TRUE)
{
	 dialog.name <- as.character(dialog.name)

	 w <- .GtkCall("S_gtk_ted_new", dialog.name, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTed", "GtkTable", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageStandardNewWithVals <-
function(title, logo, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)
	 gtkCheckInherits(logo, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_druid_page_standard_new_with_vals", title, logo, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruidPageStandard", "GnomeDruidPage", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidSetShowFinish <-
function(druid = NULL, show.finish, .flush = TRUE)
{
	 gtkCheckInherits(druid, "GnomeDruid")
	 show.finish <- as.logical(show.finish)

	 w <- .GtkCall("S_gnome_druid_set_show_finish", druid, show.finish, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeSpellCheck <-
function(spell = NULL, str, .flush = TRUE)
{
	 gtkCheckInherits(spell, "GnomeSpell")
	 str <- as.character(str)

	 w <- .GtkCall("S_gnome_spell_check", spell, str, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTedPrepare <-
function(ted = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ted, "GtkTed")

	 w <- .GtkCall("S_gtk_ted_prepare", ted, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetTextSpacing <-
function(gil = NULL, pixels, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pixels <- as.integer(pixels)

	 w <- .GtkCall("S_gnome_icon_list_set_text_spacing", gil, pixels, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientRequestSave <-
function(client = NULL, save.style = GnomeSaveStyle[1], shutdown, interact.style = GnomeInteractStyle[1], fast, global, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 save.style  <- mapGnomeSaveStyle(save.style)
	 shutdown <- as.logical(shutdown)
	 interact.style  <- mapGnomeInteractStyle(interact.style)
	 fast <- as.logical(fast)
	 global <- as.logical(global)

	 w <- .GtkCall("S_gnome_client_request_save", client, save.style, shutdown, interact.style, fast, global, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconSelectionGetIcon <-
function(gis = NULL, full.path, .flush = TRUE)
{
	 gtkCheckInherits(gis, "GnomeIconSelection")
	 full.path <- as.logical(full.path)

	 w <- .GtkCall("S_gnome_icon_selection_get_icon", gis, full.path, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAnimatorAppendFrameFromFileAtSize <-
function(animator = NULL, name, x.offset, y.offset, interval, width, height, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 name <- as.character(name)
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_animator_append_frame_from_file_at_size", animator, name, x.offset, y.offset, interval, width, height, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconListFreeze <-
function(gil = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")

	 w <- .GtkCall("S_gnome_icon_list_freeze", gil, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarSetDefault <-
function(appbar = NULL, default.status, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")
	 default.status <- as.character(default.status)

	 w <- .GtkCall("S_gnome_appbar_set_default", appbar, default.status, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapLoadFile <-
function(gpixmap = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(gpixmap, "GnomePixmap")
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gnome_pixmap_load_file", gpixmap, filename, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogAppendButtons <-
function(dialog = NULL, b1 = NULL, b2 = NULL, b3 = NULL, b4 = NULL, b5 = NULL, b6 = NULL, b7 = NULL, b8 = NULL, b9 = NULL, b10 = NULL, b11 = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 b1 <- as.character(b1)
	 b2 <- as.character(b2)
	 b3 <- as.character(b3)
	 b4 <- as.character(b4)
	 b5 <- as.character(b5)
	 b6 <- as.character(b6)
	 b7 <- as.character(b7)
	 b8 <- as.character(b8)
	 b9 <- as.character(b9)
	 b10 <- as.character(b10)
	 b11 <- as.character(b11)

	 w <- .GtkCall("S_gnome_dialog_append_buttons", dialog, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStartSetLogo <-
function(page = NULL, image, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_druid_page_start_set_logo", page, image, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconSelectionAddDefaults <-
function(gis = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gis, "GnomeIconSelection")

	 w <- .GtkCall("S_gnome_icon_selection_add_defaults", gis, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeStockSetIcon <-
function(stock = NULL, icon, .flush = TRUE)
{
	 gtkCheckInherits(stock, "GnomeStock")
	 icon <- as.character(icon)

	 w <- .GtkCall("S_gnome_stock_set_icon", stock, icon, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeFileEntrySetDirectory <-
function(fentry = NULL, directory.entry, .flush = TRUE)
{
	 gtkCheckInherits(fentry, "GnomeFileEntry")
	 directory.entry <- as.logical(directory.entry)

	 w <- .GtkCall("S_gnome_file_entry_set_directory", fentry, directory.entry, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandGetOrientation <-
function(band = NULL, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")

	 w <- .GtkCall("S_gnome_dock_band_get_orientation", band, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconListAppend <-
function(gil = NULL, icon.filename, text, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 icon.filename <- as.character(icon.filename)
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_icon_list_append", gil, icon.filename, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDISetChildMenuPath <-
function(mdi = NULL, path, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 path <- as.character(path)

	 w <- .GtkCall("S_gnome_mdi_set_child_menu_path", mdi, path, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetIconBorder <-
function(gil = NULL, pixels, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pixels <- as.integer(pixels)

	 w <- .GtkCall("S_gnome_icon_list_set_icon_border", gil, pixels, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListInsertImlib <-
function(gil = NULL, pos, image, text, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)
	 gtkCheckInherits(image, "GdkImlibImage")
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_icon_list_insert_imlib", gil, pos, image, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetRowSpacing <-
function(gil = NULL, pixels, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pixels <- as.integer(pixels)

	 w <- .GtkCall("S_gnome_icon_list_set_row_spacing", gil, pixels, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeColorPickerSetI8 <-
function(cp = NULL, r, g, b, a, .flush = TRUE)
{
	 gtkCheckInherits(cp, "GnomeColorPicker")
	 r <- as.integer(r)
	 g <- as.integer(g)
	 b <- as.integer(b)
	 a <- as.integer(a)

	 w <- .GtkCall("S_gnome_color_picker_set_i8", cp, r, g, b, a, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeLessWriteFile <-
function(less = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gnome_less_write_file", less, filename, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePaperSelectorGetBottomMargin <-
function(gspaper = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gspaper, "GnomePaperSelector")

	 w <- .GtkCall("S_gnome_paper_selector_get_bottom_margin", gspaper, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeLessReshow <-
function(less = NULL, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")

	 w <- .GtkCall("S_gnome_less_reshow", less, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListIconIsVisible <-
function(gil = NULL, pos, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)

	 w <- .GtkCall("S_gnome_icon_list_icon_is_visible", gil, pos, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppSetStatusbar <-
function(app = NULL, statusbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(statusbar, "GtkWidget")

	 w <- .GtkCall("S_gnome_app_set_statusbar", app, statusbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconEntryGnomeFileEntry <-
function(ientry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ientry, "GnomeIconEntry")

	 w <- .GtkCall("S_gnome_icon_entry_gnome_file_entry", ientry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeIconListMoveto <-
function(gil = NULL, pos, yalign, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)
	 gtkCheckInherits(yalign, "double")

	 w <- .GtkCall("S_gnome_icon_list_moveto", gil, pos, yalign, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerFiSetUseFontInLabel <-
function(gfp = NULL, use.font.in.label, size, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 use.font.in.label <- as.logical(use.font.in.label)
	 size <- as.integer(size)

	 w <- .GtkCall("S_gnome_font_picker_fi_set_use_font_in_label", gfp, use.font.in.label, size, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIRemoveChild <-
function(mdi = NULL, child = NULL, force, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(child, "GnomeMDIChild")
	 force <- as.integer(force)

	 w <- .GtkCall("S_gnome_mdi_remove_child", mdi, child, force, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIAddView <-
function(mdi = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(child, "GnomeMDIChild")

	 w <- .GtkCall("S_gnome_mdi_add_view", mdi, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeEntryPrependHistory <-
function(gentry = NULL, save, text, .flush = TRUE)
{
	 gtkCheckInherits(gentry, "GnomeEntry")
	 save <- as.integer(save)
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_entry_prepend_history", gentry, save, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeEntryAppendHistory <-
function(gentry = NULL, save, text, .flush = TRUE)
{
	 gtkCheckInherits(gentry, "GnomeEntry")
	 save <- as.integer(save)
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_entry_append_history", gentry, save, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinish <-
function(druid.page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid.page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_page_finish", druid.page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeGuruBackSetSensitive <-
function(guru = NULL, sensitivity, .flush = TRUE)
{
	 gtkCheckInherits(guru, "GnomeGuru")
	 sensitivity <- as.logical(sensitivity)

	 w <- .GtkCall("S_gnome_guru_back_set_sensitive", guru, sensitivity, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandDragTo <-
function(band = NULL, item = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(item, "GnomeDockItem")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gnome_dock_band_drag_to", band, item, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListInsert <-
function(gil = NULL, pos, icon.filename, text, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)
	 icon.filename <- as.character(icon.filename)
	 text <- as.character(text)

	 w <- .GtkCall("S_gnome_icon_list_insert", gil, pos, icon.filename, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeHRefSetLabel <-
function(href = NULL, label, .flush = TRUE)
{
	 gtkCheckInherits(href, "GnomeHRef")
	 label <- as.character(label)

	 w <- .GtkCall("S_gnome_href_set_label", href, label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCalculatorNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_calculator_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeCalculator", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeClientGetConfigPrefix <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_get_config_prefix", client, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPagePrepare <-
function(druid.page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid.page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_page_prepare", druid.page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDateEditGetDate <-
function(gde = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gde, "GnomeDateEdit")

	 w <- .GtkCall("S_gnome_date_edit_get_date", gde, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockItemGetName <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_item_get_name", item, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStartNewWithVals <-
function(title = NULL, text = NULL, logo = NULL, watermark = NULL, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)
	 text <- as.character(text)
	 gtkCheckInherits(logo, "GdkImlibImage", nullOk = TRUE)
	 gtkCheckInherits(watermark, "GdkImlibImage", nullOk = TRUE)

	 w <- .GtkCall("S_gnome_druid_page_start_new_with_vals", title, text, logo, watermark, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruidPageStart", "GnomeDruidPage", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeWidgetAddHelp <-
function(widget = NULL, help, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 help <- as.character(help)

	 w <- .GtkCall("S_gnome_widget_add_help", widget, help, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconTextItemStopEditing <-
function(iti = NULL, accept, .flush = TRUE)
{
	 gtkCheckInherits(iti, "GnomeIconTextItem")
	 accept <- as.logical(accept)

	 w <- .GtkCall("S_gnome_icon_text_item_stop_editing", iti, accept, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDentryGetIconEntry <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_get_icon_entry", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientSetProcessId <-
function(client = NULL, pid, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 pid <- as.integer(pid)

	 w <- .GtkCall("S_gnome_client_set_process_id", client, pid, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeColorPickerSetDither <-
function(cp = NULL, dither, .flush = TRUE)
{
	 gtkCheckInherits(cp, "GnomeColorPicker")
	 dither <- as.logical(dither)

	 w <- .GtkCall("S_gnome_color_picker_set_dither", cp, dither, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStartSetTextColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_start_set_text_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeColorPickerSetTitle <-
function(cp = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(cp, "GnomeColorPicker")
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_color_picker_set_title", cp, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeStockButton <-
function(type, .flush = TRUE)
{
	 type <- as.character(type)

	 w <- .GtkCall("S_gnome_stock_button", type, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAnimatorAppendFrameFromImlibAtSize <-
function(animator = NULL, image, x.offset, y.offset, interval, width, height, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 gtkCheckInherits(image, "GdkImlibImage")
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_animator_append_frame_from_imlib_at_size", animator, image, x.offset, y.offset, interval, width, height, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockBandSetOrientation <-
function(band = NULL, orientation = GtkOrientation[1], .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 orientation  <- mapGtkOrientation(orientation)

	 w <- .GtkCall("S_gnome_dock_band_set_orientation", band, orientation, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSelectIcon <-
function(gil = NULL, pos, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 pos <- as.integer(pos)

	 w <- .GtkCall("S_gnome_icon_list_select_icon", gil, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconTextItemSetxy <-
function(iti = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(iti, "GnomeIconTextItem")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gnome_icon_text_item_setxy", iti, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemReparent <-
function(item = NULL, new.group = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")
	 gtkCheckInherits(new.group, "GnomeCanvasGroup")

	 w <- .GtkCall("S_gnome_canvas_item_reparent", item, new.group, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeColorPickerSetI16 <-
function(cp = NULL, r, g, b, a, .flush = TRUE)
{
	 gtkCheckInherits(cp, "GnomeColorPicker")
	 r <- as.integer(r)
	 g <- as.integer(g)
	 b <- as.integer(b)
	 a <- as.integer(a)

	 w <- .GtkCall("S_gnome_color_picker_set_i16", cp, r, g, b, a, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeEntryNew <-
function(history.id, show = TRUE, .flush = TRUE)
{
	 history.id <- as.character(history.id)

	 w <- .GtkCall("S_gnome_entry_new", history.id, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeEntry", "GtkCombo", "GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomePixmapEntrySetPixmapSubdir <-
function(pentry = NULL, subdir, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")
	 subdir <- as.character(subdir)

	 w <- .GtkCall("S_gnome_pixmap_entry_set_pixmap_subdir", pentry, subdir, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorStart <-
function(animator = NULL, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")

	 w <- .GtkCall("S_gnome_animator_start", animator, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorSetLoopType <-
function(animator = NULL, loop.type = GnomeAnimatorLoopType[1], .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 loop.type  <- mapGnomeAnimatorLoopType(loop.type)

	 w <- .GtkCall("S_gnome_animator_set_loop_type", animator, loop.type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListThaw <-
function(gil = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")

	 w <- .GtkCall("S_gnome_icon_list_thaw", gil, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListUnselectAll <-
function(gil = NULL, event = NULL, keep = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 gtkCheckInherits(event, "GdkEvent")
	 keep <- as.character(keep)

	 w <- .GtkCall("S_gnome_icon_list_unselect_all", gil, event, keep, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarClearStack <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_gnome_appbar_clear_stack", appbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIChildAddView <-
function(mdic = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdic, "GnomeMDIChild")

	 w <- .GtkCall("S_gnome_mdi_child_add_view", mdic, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDockItemGetShadowType <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeDockItem")

	 w <- .GtkCall("S_gnome_dock_item_get_shadow_type", item, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeEntrySaveHistory <-
function(gentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gentry, "GnomeEntry")

	 w <- .GtkCall("S_gnome_entry_save_history", gentry, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerSetFontName <-
function(gfp = NULL, fontname, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")
	 fontname <- as.character(fontname)

	 w <- .GtkCall("S_gnome_font_picker_set_font_name", gfp, fontname, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientNewWithoutConnection <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gnome_client_new_without_connection", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeClient", "GtkObject")
	 return(w)

}
 

gnomeLessShowString <-
function(less = NULL, str, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")
	 str <- as.character(str)

	 w <- .GtkCall("S_gnome_less_show_string", less, str, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppGetDock <-
function(app = NULL, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")

	 w <- .GtkCall("S_gnome_app_get_dock", app, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCanvasSetScrollRegion <-
function(canvas = NULL, x1, y1, x2, y2, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")
	 gtkCheckInherits(x1, "double")
	 gtkCheckInherits(y1, "double")
	 gtkCheckInherits(x2, "double")
	 gtkCheckInherits(y2, "double")

	 w <- .GtkCall("S_gnome_canvas_set_scroll_region", canvas, x1, y1, x2, y2, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFileEntryGtkEntry <-
function(fentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fentry, "GnomeFileEntry")

	 w <- .GtkCall("S_gnome_file_entry_gtk_entry", fentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDEntryEditLoadFile <-
function(dee = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gnome_dentry_edit_load_file", dee, filename, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePropertyBoxSetModified <-
function(property.box = NULL, modified, .flush = TRUE)
{
	 gtkCheckInherits(property.box, "GnomePropertyBox")
	 modified <- as.logical(modified)

	 w <- .GtkCall("S_gnome_property_box_set_modified", property.box, modified, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientSetUserId <-
function(client = NULL, user.id, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")
	 user.id <- as.character(user.id)

	 w <- .GtkCall("S_gnome_client_set_user_id", client, user.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListGetItemsPerLine <-
function(gil = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")

	 w <- .GtkCall("S_gnome_icon_list_get_items_per_line", gil, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePixmapEntrySetPreviewSize <-
function(pentry = NULL, preview.w, preview.h, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")
	 preview.w <- as.integer(preview.w)
	 preview.h <- as.integer(preview.h)

	 w <- .GtkCall("S_gnome_pixmap_entry_set_preview_size", pentry, preview.w, preview.h, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapNewFromFileAtSize <-
function(filename, width, height, show = TRUE, .flush = TRUE)
{
	 filename <- as.character(filename)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_pixmap_new_from_file_at_size", filename, width, height, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeFontPickerGetFont <-
function(gfp = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")

	 w <- .GtkCall("S_gnome_font_picker_get_font", gfp, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeOkDialog <-
function(message, .flush = TRUE)
{
	 message <- as.character(message)

	 w <- .GtkCall("S_gnome_ok_dialog", message, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIRemoveAll <-
function(mdi = NULL, force, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 force <- as.integer(force)

	 w <- .GtkCall("S_gnome_mdi_remove_all", mdi, force, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeErrorDialogParented <-
function(message, parent = NULL, .flush = TRUE)
{
	 message <- as.character(message)
	 gtkCheckInherits(parent, "GtkWindow")

	 w <- .GtkCall("S_gnome_error_dialog_parented", message, parent, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDateEditNewFlags <-
function(the.time, flags, .flush = TRUE)
{
	 the.time <- as.integer(the.time)
	 flags  <- mapGnomeDateEditFlags(flags)

	 w <- .GtkCall("S_gnome_date_edit_new_flags", the.time, flags, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDateEdit", "GnomeHBox")
	 return(w)

}
 

gnomeDialogSetParent <-
function(dialog = NULL, parent = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 gtkCheckInherits(parent, "GtkWindow")

	 w <- .GtkCall("S_gnome_dialog_set_parent", dialog, parent, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppSetMenus <-
function(app = NULL, menubar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(menubar, "GtkMenuBar")

	 w <- .GtkCall("S_gnome_app_set_menus", app, menubar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemMove <-
function(item = NULL, dx, dy, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")
	 gtkCheckInherits(dx, "double")
	 gtkCheckInherits(dy, "double")

	 w <- .GtkCall("S_gnome_canvas_item_move", item, dx, dy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapEntryGetFilename <-
function(pentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")

	 w <- .GtkCall("S_gnome_pixmap_entry_get_filename", pentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppBarPush <-
function(appbar = NULL, status, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")
	 status <- as.character(status)

	 w <- .GtkCall("S_gnome_appbar_push", appbar, status, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDEntryEditNewNotebook <-
function(notebook = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")

	 w <- .GtkCall("S_gnome_dentry_edit_new_notebook", notebook, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDEntryEdit", "GtkObject")
	 return(w)

}
 

gnomeAnimatorAppendFramesFromImlib <-
function(animator = NULL, image, x.offset, y.offset, interval, x.unit, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 gtkCheckInherits(image, "GdkImlibImage")
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)
	 x.unit <- as.integer(x.unit)

	 w <- .GtkCall("S_gnome_animator_append_frames_from_imlib", animator, image, x.offset, y.offset, interval, x.unit, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAnimatorGotoFrame <-
function(animator = NULL, num.frame, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 num.frame <- as.integer(num.frame)

	 w <- .GtkCall("S_gnome_animator_goto_frame", animator, num.frame, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogClose <-
function(dialog = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")

	 w <- .GtkCall("S_gnome_dialog_close", dialog, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarGetProgress <-
function(appbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(appbar, "GnomeAppBar")

	 w <- .GtkCall("S_gnome_appbar_get_progress", appbar, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeClientFlush <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_flush", client, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTedNewLayout <-
function(dialog.name, layout, show = TRUE, .flush = TRUE)
{
	 dialog.name <- as.character(dialog.name)
	 layout <- as.character(layout)

	 w <- .GtkCall("S_gtk_ted_new_layout", dialog.name, layout, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTed", "GtkTable", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDialogAppendButton <-
function(dialog = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 name <- as.character(name)

	 w <- .GtkCall("S_gnome_dialog_append_button", dialog, name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIUpdateChild <-
function(mdi = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 gtkCheckInherits(child, "GnomeMDIChild")

	 w <- .GtkCall("S_gnome_mdi_update_child", mdi, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIGetChildFromView <-
function(view = NULL, .flush = TRUE)
{
	 gtkCheckInherits(view, "GtkWidget")

	 w <- .GtkCall("S_gnome_mdi_get_child_from_view", view, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeScoresSetLogoLabel <-
function(gs = NULL, text, font, colour, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 text <- as.character(text)
	 font <- as.character(font)
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_scores_set_logo_label", gs, text, font, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListNew <-
function(icon.width, adj = NULL, is.editable = FALSE, show = TRUE, .flush = TRUE)
{
	 icon.width <- as.integer(icon.width)
	 gtkCheckInherits(adj, "GtkAdjustment", nullOk = TRUE)
	 is.editable <- as.logical(is.editable)

	 w <- .GtkCall("S_gnome_icon_list_new", icon.width, adj, is.editable, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeIconList", "GnomeCanvas", "GtkLayout", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeCanvasItemHide <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")

	 w <- .GtkCall("S_gnome_canvas_item_hide", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeScoresSetLogoPixmap <-
function(gs = NULL, logo, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 logo <- as.character(logo)

	 w <- .GtkCall("S_gnome_scores_set_logo_pixmap", gs, logo, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorAppendFramesFromFile <-
function(animator = NULL, name, x.offset, y.offset, interval, x.unit, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 name <- as.character(name)
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)
	 x.unit <- as.integer(x.unit)

	 w <- .GtkCall("S_gnome_animator_append_frames_from_file", animator, name, x.offset, y.offset, interval, x.unit, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomePixmapNewFromImlib <-
function(image, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_pixmap_new_from_imlib", image, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDentryGetNameEntry <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_get_name_entry", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkClockSetUpdateInterval <-
function(gclock = NULL, seconds, .flush = TRUE)
{
	 gtkCheckInherits(gclock, "GtkClock")
	 seconds <- as.integer(seconds)

	 w <- .GtkCall("S_gtk_clock_set_update_interval", gclock, seconds, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconSelectionNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_icon_selection_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeIconSelection", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidInsertPage <-
function(druid = NULL, back.page = NULL, page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(druid, "GnomeDruid")
	 gtkCheckInherits(back.page, "GnomeDruidPage")
	 gtkCheckInherits(page, "GnomeDruidPage")

	 w <- .GtkCall("S_gnome_druid_insert_page", druid, back.page, page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogAppendButtonWithPixmap <-
function(dialog = NULL, name, pixmap, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")
	 name <- as.character(name)
	 pixmap <- as.character(pixmap)

	 w <- .GtkCall("S_gnome_dialog_append_button_with_pixmap", dialog, name, pixmap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeSpellInsert <-
function(spell = NULL, word, lowercase, .flush = TRUE)
{
	 gtkCheckInherits(spell, "GnomeSpell")
	 word <- as.character(word)
	 lowercase <- as.integer(lowercase)

	 w <- .GtkCall("S_gnome_spell_insert", spell, word, lowercase, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFileEntrySetTitle <-
function(fentry = NULL, browse.dialog.title, .flush = TRUE)
{
	 gtkCheckInherits(fentry, "GnomeFileEntry")
	 browse.dialog.title <- as.character(browse.dialog.title)

	 w <- .GtkCall("S_gnome_file_entry_set_title", fentry, browse.dialog.title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStartSetTitle <-
function(page = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 title <- as.character(title)

	 w <- .GtkCall("S_gnome_druid_page_start_set_title", page, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconEntrySetIcon <-
function(ientry = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(ientry, "GnomeIconEntry")
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gnome_icon_entry_set_icon", ientry, filename, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeMDIFindChild <-
function(mdi = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(mdi, "GnomeMDI")
	 name <- as.character(name)

	 w <- .GtkCall("S_gnome_mdi_find_child", mdi, name, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMessageBoxNew <-
function(message, messagebox.type, b1 = NULL, b2 = NULL, b3 = NULL, b4 = NULL, b5 = NULL, b6 = NULL, b7 = NULL, b8 = NULL, b9 = NULL, b10 = NULL, b11 = NULL, show = TRUE, .flush = TRUE)
{
	 message <- as.character(message)
	 messagebox.type <- as.character(messagebox.type)
	 b1 <- as.character(b1)
	 b2 <- as.character(b2)
	 b3 <- as.character(b3)
	 b4 <- as.character(b4)
	 b5 <- as.character(b5)
	 b6 <- as.character(b6)
	 b7 <- as.character(b7)
	 b8 <- as.character(b8)
	 b9 <- as.character(b9)
	 b10 <- as.character(b10)
	 b11 <- as.character(b11)

	 w <- .GtkCall("S_gnome_message_box_new", message, messagebox.type, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10, b11, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeMessageBox", "GnomeDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDateEditNew <-
function(the.time, show.time, use.24.format, .flush = TRUE)
{
	 the.time <- as.integer(the.time)
	 show.time <- as.logical(show.time)
	 use.24.format <- as.logical(use.24.format)

	 w <- .GtkCall("S_gnome_date_edit_new", the.time, show.time, use.24.format, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDateEdit", "GnomeHBox")
	 return(w)

}
 

gnomeGuruNew <-
function(name = NULL, graphic = NULL, dialog = NULL, show = TRUE, .flush = TRUE)
{
	 name <- as.character(name)
	 gtkCheckInherits(graphic, "GtkWidget")
	 gtkCheckInherits(dialog, "GnomeDialog")

	 w <- .GtkCall("S_gnome_guru_new", name, graphic, dialog, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeGuru", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageFinishNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_druid_page_finish_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruidPageFinish", "GnomeDruidPage", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageStartSetTextboxColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStart")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_start_set_textbox_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeHRefSetUrl <-
function(href = NULL, url, .flush = TRUE)
{
	 gtkCheckInherits(href, "GnomeHRef")
	 url <- as.character(url)

	 w <- .GtkCall("S_gnome_href_set_url", href, url, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetBgColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_bg_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeFontPickerGetMode <-
function(gfp = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")

	 w <- .GtkCall("S_gnome_font_picker_get_mode", gfp, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMasterClient <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gnome_master_client", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDruidPageStandardNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_druid_page_standard_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeDruidPageStandard", "GnomeDruidPage", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeScoresSetLogoWidget <-
function(gs = NULL, w = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 gtkCheckInherits(w, "GtkWidget")

	 w <- .GtkCall("S_gnome_scores_set_logo_widget", gs, w, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeCanvasItemRaise <-
function(item = NULL, positions, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")
	 positions <- as.integer(positions)

	 w <- .GtkCall("S_gnome_canvas_item_raise", item, positions, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAnimatorAppendFramesFromImlibAtSize <-
function(animator = NULL, image, x.offset, y.offset, interval, x.unit, width, height, .flush = TRUE)
{
	 gtkCheckInherits(animator, "GnomeAnimator")
	 gtkCheckInherits(image, "GdkImlibImage")
	 x.offset <- as.integer(x.offset)
	 y.offset <- as.integer(y.offset)
	 interval <- as.integer(interval)
	 x.unit <- as.integer(x.unit)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_animator_append_frames_from_imlib_at_size", animator, image, x.offset, y.offset, interval, x.unit, width, height, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeNumberEntryGtkEntry <-
function(nentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(nentry, "GnomeNumberEntry")

	 w <- .GtkCall("S_gnome_number_entry_gtk_entry", nentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeSpellAccept <-
function(spell = NULL, word, .flush = TRUE)
{
	 gtkCheckInherits(spell, "GnomeSpell")
	 word <- as.character(word)

	 w <- .GtkCall("S_gnome_spell_accept", spell, word, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeGuruAppendPage <-
function(guru = NULL, name, page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(guru, "GnomeGuru")
	 name <- as.character(name)
	 gtkCheckInherits(page, "GtkWidget")

	 w <- .GtkCall("S_gnome_guru_append_page", guru, name, page, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconListSetHadjustment <-
function(gil = NULL, hadj = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gil, "GnomeIconList")
	 gtkCheckInherits(hadj, "GtkAdjustment")

	 w <- .GtkCall("S_gnome_icon_list_set_hadjustment", gil, hadj, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppSetContents <-
function(app = NULL, contents = NULL, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(contents, "GtkWidget")

	 w <- .GtkCall("S_gnome_app_set_contents", app, contents, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDateEditSetTime <-
function(gde = NULL, the.time, .flush = TRUE)
{
	 gtkCheckInherits(gde, "GnomeDateEdit")
	 the.time <- as.integer(the.time)

	 w <- .GtkCall("S_gnome_date_edit_set_time", gde, the.time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconSelectionSelectIcon <-
function(gis = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(gis, "GnomeIconSelection")
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gnome_icon_selection_select_icon", gis, filename, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePropertyBoxNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gnome_property_box_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePropertyBox", "GnomeDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomePixmapNewFromImlibAtSize <-
function(image, width, height, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(image, "GdkImlibImage")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gnome_pixmap_new_from_imlib_at_size", image, width, height, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeScoresSetLogoLabelTitle <-
function(gs = NULL, logo, .flush = TRUE)
{
	 gtkCheckInherits(gs, "GnomeScores")
	 logo <- as.character(logo)

	 w <- .GtkCall("S_gnome_scores_set_logo_label_title", gs, logo, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageFinishSetTitleColor <-
function(page = NULL, colour, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(colour, "GdkColor")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_title_color", page, colour, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandAppend <-
function(band = NULL, child = NULL, offset, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(child, "GtkWidget")
	 offset <- as.integer(offset)

	 w <- .GtkCall("S_gnome_dock_band_append", band, child, offset, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeDentryGetCommentEntry <-
function(dee = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dee, "GnomeDEntryEdit")

	 w <- .GtkCall("S_gnome_dentry_get_comment_entry", dee, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeFontPickerGetPreviewText <-
function(gfp = NULL, .flush = TRUE)
{
	 gtkCheckInherits(gfp, "GnomeFontPicker")

	 w <- .GtkCall("S_gnome_font_picker_get_preview_text", gfp, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeGuruNextSetSensitive <-
function(guru = NULL, sensitivity, .flush = TRUE)
{
	 gtkCheckInherits(guru, "GnomeGuru")
	 sensitivity <- as.logical(sensitivity)

	 w <- .GtkCall("S_gnome_guru_next_set_sensitive", guru, sensitivity, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppMessage <-
function(app = NULL, message, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 message <- as.character(message)

	 w <- .GtkCall("S_gnome_app_message", app, message, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapEntryGtkEntry <-
function(pentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(pentry, "GnomePixmapEntry")

	 w <- .GtkCall("S_gnome_pixmap_entry_gtk_entry", pentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCanvasSetStippleOrigin <-
function(canvas = NULL, gc, .flush = TRUE)
{
	 gtkCheckInherits(canvas, "GnomeCanvas")
	 gtkCheckInherits(gc, "GdkGC")

	 w <- .GtkCall("S_gnome_canvas_set_stipple_origin", canvas, gc, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDialogRun <-
function(dialog = NULL, .flush = TRUE)
{
	 gtkCheckInherits(dialog, "GnomeDialog")

	 w <- .GtkCall("S_gnome_dialog_run", dialog, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeMDIChildSetName <-
function(mdic = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(mdic, "GnomeMDIChild")
	 name <- as.character(name)

	 w <- .GtkCall("S_gnome_mdi_child_set_name", mdic, name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeSpellNext <-
function(spell = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spell, "GnomeSpell")

	 w <- .GtkCall("S_gnome_spell_next", spell, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDockBandSetChildOffset <-
function(band = NULL, child = NULL, offset, .flush = TRUE)
{
	 gtkCheckInherits(band, "GnomeDockBand")
	 gtkCheckInherits(child, "GtkWidget")
	 offset <- as.integer(offset)

	 w <- .GtkCall("S_gnome_dock_band_set_child_offset", band, child, offset, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientGetFlags <-
function(client = NULL, .flush = TRUE)
{
	 gtkCheckInherits(client, "GnomeClient")

	 w <- .GtkCall("S_gnome_client_get_flags", client, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeCanvasItemRaiseToTop <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GnomeCanvasItem")

	 w <- .GtkCall("S_gnome_canvas_item_raise_to_top", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeIconEntryGnomeEntry <-
function(ientry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ientry, "GnomeIconEntry")

	 w <- .GtkCall("S_gnome_icon_entry_gnome_entry", ientry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppAddToolbar <-
function(app = NULL, toolbar = NULL, name, behavior, placement = GnomeDockPlacement[1], band.num, band.position, offset, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 name <- as.character(name)
	 behavior  <- mapGnomeDockItemBehavior(behavior)
	 placement  <- mapGnomeDockPlacement(placement)
	 band.num <- as.integer(band.num)
	 band.position <- as.integer(band.position)
	 offset <- as.integer(offset)

	 w <- .GtkCall("S_gnome_app_add_toolbar", app, toolbar, name, behavior, placement, band.num, band.position, offset, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomePixmapNewFromFile <-
function(filename, show = TRUE, .flush = TRUE)
{
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gnome_pixmap_new_from_file", filename, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomePixmap", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeFileEntryGnomeEntry <-
function(fentry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fentry, "GnomeFileEntry")

	 w <- .GtkCall("S_gnome_file_entry_gnome_entry", fentry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeWarningDialogParented <-
function(message, parent = NULL, .flush = TRUE)
{
	 message <- as.character(message)
	 gtkCheckInherits(parent, "GtkWindow")

	 w <- .GtkCall("S_gnome_warning_dialog_parented", message, parent, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gnomeAppSetStatusbarCustom <-
function(app = NULL, container = NULL, statusbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(app, "GnomeApp")
	 gtkCheckInherits(container, "GtkWidget")
	 gtkCheckInherits(statusbar, "GtkWidget")

	 w <- .GtkCall("S_gnome_app_set_statusbar_custom", app, container, statusbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeClientDisableMasterConnection <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gnome_client_disable_master_connection", PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeLessClear <-
function(less = NULL, .flush = TRUE)
{
	 gtkCheckInherits(less, "GnomeLess")

	 w <- .GtkCall("S_gnome_less_clear", less, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeDruidPageStandardSetLogo <-
function(page = NULL, image, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageStandard")
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_druid_page_standard_set_logo", page, image, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gnomeAppBarNew <-
function(has.progress, has.status, interactivity = GnomePreferencesType[1], show = TRUE, .flush = TRUE)
{
	 has.progress <- as.logical(has.progress)
	 has.status <- as.logical(has.status)
	 interactivity  <- mapGnomePreferencesType(interactivity)

	 w <- .GtkCall("S_gnome_appbar_new", has.progress, has.status, interactivity, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GnomeAppBar", "GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gnomeDruidPageFinishSetLogo <-
function(page = NULL, image, .flush = TRUE)
{
	 gtkCheckInherits(page, "GnomeDruidPageFinish")
	 gtkCheckInherits(image, "GdkImlibImage")

	 w <- .GtkCall("S_gnome_druid_page_finish_set_logo", page, image, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

