dynamicHist <-
function(x, ..., singleWindow = TRUE)
{
   # Preparatory work to process the data so that we can respond
   # to updates to the bin width relatively easily.
   # We compute the default breaks and find the average interval
   # size.
  breaks <- hist(x, ..., plot = FALSE)
  current <- mean(diff(breaks$breaks))
   # Next we compute the max and min for the data.
  mn <- min(breaks$breaks[1], min(x) - 0.001)
  mx <- max(breaks$breaks[length(breaks$breaks)], max(x) + 0.001)

   # Create the slider and its settings.
  r <- mx - mn
  delta <- diff(sort(x))
  adj <- gtkAdjustment(current, min(delta), r, min(delta), delta, delta)
  scale <- gtkHScale(adj)
  scale$SetDigits(1)

   # Create a callback for when the slider thumb is moved.
   # This computes the breaks given the value of the bin width
   # from the slider and updates the histogram accordingly.
  adj$AddCallback("value-changed",
                  function(adj) {
                     tmp <- adj$GetValue()
                     if(tmp == 0)
                       return()
                     current <<- tmp
                     brks <- seq(mn, mx, by = current)
                       # Fix up the breaks if the sequence doesn't include all the points.
                     if(brks[length(brks)] < mx) {
                       brks <- c(brks, brks[length(brks)]+current)
                     }
                     old <- dev.cur()
                     dev.set(dev)
                     on.exit(dev.set(old))
                     hist(x, brks)
                  })

  
   win <- gtkWindow(show = FALSE)
  
    # IF we want the device and slider in a single window,
    # rather than two separate windows, then we create a device
    # by creating a drawing area widget and coercing it to a device.
    # This currently requires that we be running with --gui=GNOME.
  if(singleWindow) {
    w <- gtkDrawingArea()
    asGtkDevice(w)
     # Remember which device we are drawing to.
    dev <- dev.cur()

      # Now create vertical box and put the device widget and the scale
      # in to it.
    box <- gtkVBox(FALSE, 10)
    box$PackStart(w, expand = TRUE)
    box$PackEnd(scale, fill = FALSE, expand = FALSE)    
    win$Add(box)
    win$SetUsize(400, 400)
  } else {
     # Separate window for device and slider, so just add the slider to
     # to the window.
    win$Add(scale)
  }
  
  win$Show()

   # Draw the first histogram
  hist(x, breaks = seq(mn, mx, by = current))  

  list(window = win, scale = scale)
}  
