\name{dollar.GtkObject}
\alias{$.GtkObject}
\alias{$.GtkType}
\alias{$.GdkEvent}
\title{Find methods for an S-Gtk object}
\description{
  These accessor functions find the
  appropriate method for a Gtk object
  based on its class hierarchy information.
  This allows one to invoke a method
  such as \code{show}
  on a Gtk object without having to remember
  for which parent class it was defined
  (e.g. GtkWidget).
  So \code{w$Show} will find the method.
  The function exploits the naming convention
  used in Gtk and the R-Gtk interface
  to find S functions of the form
  \code{gtk<Type>FunctionName},
  and it searches for the most appropriate
  function given the object's class.
}
\usage{
obj$name
"$.GtkObject"(obj, name)
"$.GtkType"(obj, name)
"$.GdkEvent"(obj, name)
}
\arguments{
  \item{obj}{the GtkObject whose classes are to be used to find the
    method of interest.}
  \item{name}{the shortened name of the method of interest.
    This is combined with the appropriate class of Gtk object
    to produce the full name.}
}
\details{
  This searches for an appropriate S function by
  combining the name of the function
  with each of the elements in the class
  vector of \code{obj}.
  This can be expensive. A more classical
  OOP mechanism would be more efficient
  and will likely be implemented in the future.
}
\value{
  The return value is a function
  which has access to the \code{obj}
  value so that it can call the real S function
  with that object as the first argument.
  One typically invokes the function
  directly, as in
  \code{w$Show()}
  and it is not intended that one assigns the
  result of the \code{$} operation for later use.
}
\references{
  Information on the package is available
  from \url{http://www.omegahat.org/RGtk}.

  Information on Gtk is available from
  \url{http://www.gtk.org}.
}
\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}
\note{
  In the future, the RGtk interface may use a
  more traditional object oriented class mechanism
  provided by the \url{http://www.omegahat.org/OOP}
  in which case the dispatching will be done
  internally from the definitions of the Gtk class
  rather than using this ``home-made'' mechanism.
}


\seealso{
  \code{\link{[[.GtkObject}}
  \code{\link{.getAutoMethodByName}}
  \code{\link{.getAutoElementByName}}
}

\examples{
 gtkInit()

 w <- gtkButton("My button", show = FALSE)
 w$Show()
 w$Hide()
 w$Destroy()
}
\keyword{interface}
