#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "cavity.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo  omega (argv[1]);
  space Xh = cavity_space (omega, "P2");
  field uh = cavity_field (Xh, 1);
  space Qh (omega, "P1");
  field ph (Qh, 0.);
  form a  (Xh, Xh, "2D_D");
  form b = - form(Xh, Qh, "div");
  form mp (Qh, Qh, "mass");
  solver_abtb stokes (a.uu(), b.uu(), mp.uu());
  stokes.solve (-(a.ub()*uh.b()), -(b.ub()*uh.b()),
                uh.set_u(),       ph.set_u());
  dout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
