///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// geo adaptation with grummp
//
// author:
//      Pierre.Saramito@imag.fr
//
// date: 27 january 2006
//
// ============================================================================
//  includes
// ============================================================================

#include "rheolef/geo.h"
#include "rheolef/iorheo.h"
#include "rheolef/rheostream.h" // i/o utility
#include "rheolef/field.h"
using namespace std;
namespace rheolef { 

void
georep_adapt_grummp (const field& u0, georep& adapt_g, const adapt_option_type& opt, bool do_interpolate)
{
    // il faut regenerer le .g
    // est-ce qu'on utilise encore le fichier .bdry ??
    const geo& g       = u0.get_geo();
    string basename    = g.basename();
    string serial_name = g.name();
    size_t    i        = g.serial_number();
    string command = "meshopt2d -i " + serial_name + " -l " + serial_name + ".hloc";

    error_macro ("georep_adapt_grummp: not yet !");
}

}// namespace rheolef
