#ifndef _RHEO_DIV_DIV_H
#define _RHEO_DIV_DIV_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/form_element.h"
namespace rheolef { 

/*Class:div_div
NAME: @code{div_div} -- -grad div operator
@bfindex div_div
@apindex P1
@apindex P2
@cindex  grad(div(.)) operator
@cindex  elasticity problem
@cindex  divergence
@cindex  rate of deformation tensor
@clindex form
@clindex space
SYNOPSIS:
  @example
    	form (const space V, const space& V, "div_div");
  @end example
DESCRIPTION:       
  @noindent
  Assembly the form associated to the @code{grad(div(.))}
  operator on the finite element space @code{V}:
@iftex
@tex
  $$
  	a({\bf u},{\bf v}) = \int_\Omega  
	  {\rm div}({\bf u}) {\rm div}({\bf v}) \, dx
  $$
@end tex
@end iftex
@ifnottex
  @example
                 /
                 |
  	a(u,v) = | div(u) div(v) dx
                 |
                 / Omega  
  @end example
@end ifnottex
  This form is usefull when considering elasticity problem.
EXAMPLE:
  @noindent
  Here is an example of the vector-valued form:
  @example
        geo omega ("square");
        space V (omega, "P2", "vector");
        form  a (V, V, "div_div");
  @end example

DATE:
    25 february 1997
End:
*/
template<class T, class M>
class div_div: public form_element_rep<T,M> {
public:
    typedef form_element_rep<T,M>       base;
    typedef typename base::size_type    size_type;
    typedef typename base::geo_type     geo_type;
    typedef typename base::space_type   space_type;

// allocator:

    div_div (const space_type& X, const space_type& Y, const geo_type& omega,
        const quadrature_option_type& qopt)
	: form_element_rep<T,M> (X,Y,omega,qopt) { base::initialize_all(); }

    void operator() (const geo_element& K, ublas::matrix<T>& m) const;
    void initialize () const;
    bool is_symmetric () const { return true; }
};

}// namespace rheolef
#endif // _RHEOLEF_DIV_DIV_H
