// file automatically generated by: make_form_element_list_cxx.sh
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/form_element.h"
#include "mass.h"
#include "grad_grad.h"
#include "2D_D.h"
#include "div_div.h"
#include "inv_mass.h"
#include "grad.h"
#include "div.h"
#include "2D.h"
#include "curl.h"
#include "s_curl.h"
#include "s_grad_grad.h"
#include "lumped_mass.h"
namespace rheolef {
using namespace std;

template<class T, class M>
form_element_rep<T,M>* 
form_element_rep<T,M>::make_ptr (
    string                name,
    const space_type&     X,
    const space_type&     Y,
    const geo_type&       omega,
    const quadrature_option_type& qopt)
{
  // TODO: use gperf instead of a long if-else test suite
  if (name == "")          return 0;
  if (name == "mass") return new_macro ((mass<T,M>)(X,Y,omega,qopt));
  if (name == "grad_grad") return new_macro ((grad_grad<T,M>)(X,Y,omega,qopt));
  if (name == "2D_D") return new_macro ((_2D_D<T,M>)(X,Y,omega,qopt));
  if (name == "div_div") return new_macro ((div_div<T,M>)(X,Y,omega,qopt));
  if (name == "inv_mass") return new_macro ((inv_mass<T,M>)(X,Y,omega,qopt));
  if (name == "grad") return new_macro ((grad<T,M>)(X,Y,omega,qopt));
  if (name == "div") return new_macro ((div<T,M>)(X,Y,omega,qopt));
  if (name == "2D") return new_macro ((_2D<T,M>)(X,Y,omega,qopt));
  if (name == "curl") return new_macro ((curl<T,M>)(X,Y,omega,qopt));
  if (name == "s_curl") return new_macro ((s_curl<T,M>)(X,Y,omega,qopt));
  if (name == "s_grad_grad") return new_macro ((s_grad_grad<T,M>)(X,Y,omega,qopt));
  if (name == "lumped_mass") return new_macro ((lumped_mass<T,M>)(X,Y,omega,qopt));
  error_macro ("undefined form_element \"" << name << "\"");
  return 0;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class form_element_rep<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class form_element_rep<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
