#ifndef _RHEOLEF_FIELD_EVALUATE_H
#define _RHEOLEF_FIELD_EVALUATE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// 
// evaluate a field on a predefined point set: hat_x[q], q=0..nq
// See also piola_transformation.h
//
#include "rheolef/field.h"
#include "rheolef/basis_on_pointset.h"
namespace rheolef { 

template<class T, class M, class BasisOnPointset>
T
field_evaluate (
  const field_basic<T,M>&       uh,
  const BasisOnPointset&        basis_on_pointset,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q)
{
  typedef typename field_basic<T,M>::size_type size_type;
   T value = 0;
   size_type loc_idof = 0;
   for (typename BasisOnPointset::const_iterator
	  iter = basis_on_pointset.begin(hat_K, q),
          last = basis_on_pointset.end  (hat_K, q);
          iter != last;
          iter++, loc_idof++) {
     const T& cdof = *iter;
     const T& udof = uh.dis_dof (dis_idof[loc_idof]);
     value += cdof*udof;
   }
   return value;
}
template<class T, class M, class BasisOnPointset>
point_basic<T>
vector_field_evaluate (
  const field_basic<T,M>&       uh,
  const BasisOnPointset&        basis_on_pointset,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof_tab,
  size_t                        q)
{
  typedef typename field_basic<T,M>::size_type size_type;
   size_type dis_ndof = uh.dis_ndof();
   size_type loc_ndof = dis_idof_tab.size();
   size_type loc_comp_ndof = std::distance (
		basis_on_pointset.begin(hat_K, q),
          	basis_on_pointset.end  (hat_K, q));
   size_type loc_comp_idof = 0;
   size_type n_comp = uh.get_geo().dimension();
   point_basic<T> value (0,0,0);
   for (typename BasisOnPointset::const_iterator
	  iter = basis_on_pointset.begin(hat_K, q),
          last = basis_on_pointset.end  (hat_K, q);
          iter != last;
          iter++, loc_comp_idof++) {
     const T& cdof = *iter;
     for (size_type i_comp = 0; i_comp < n_comp; i_comp++) {
       size_type loc_idof = loc_comp_idof + i_comp*loc_comp_ndof;
       assert_macro (loc_idof < loc_ndof, "invalid local index "<<loc_idof<<" out of range [0:"<<loc_ndof<<"[");
       size_type dis_idof = dis_idof_tab[loc_idof];
       assert_macro (dis_idof < dis_ndof, "invalid distr index");
       const T& udof = uh.dis_dof (dis_idof);
       value[i_comp] += cdof*udof;
     }
   }
   return value;
}

}// namespace rheolef
#endif // _RHEOLEF_FIELD_EVALUATE_H
