///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/config.h"
#ifdef _RHEOLEF_HAVE_MPI
#include "rheolef/geo.h"

namespace rheolef {

// --------------------------------------------------------------------------
// accessors to distributed data
// --------------------------------------------------------------------------
template <class T>
typename geo_rep<T,distributed>::const_reference  
geo_rep<T,distributed>::dis_get_geo_element (size_type dim, size_type dis_ige) const
{
  if (base::_gs.ownership_by_dimension[dim].is_owned (dis_ige)) {
    size_type first_dis_ige = base::_gs.ownership_by_dimension[dim].first_index();
    size_type ige = dis_ige - first_dis_ige;
    return get_geo_element (dim, ige);
  }
  // element is owned by another proc ; get its variant
  size_type iproc = base::_gs.ownership_by_dimension[dim].find_owner(dis_ige);
  size_type first_dis_ige = base::_gs.ownership_by_dimension[dim].first_index(iproc);
  size_type first_dis_v = first_dis_ige;
  size_type  last_dis_v = first_dis_v;
  size_type shift = 0;
  for (size_type variant = reference_element::first_variant_by_dimension(dim);
                 variant < reference_element:: last_variant_by_dimension(dim); variant++) {
    last_dis_v += base::_geo_element [variant].ownership().size (iproc);
    if (dis_ige < last_dis_v)  {
       assert_macro (dis_ige >= shift, "unexpected index computation");
       size_type dis_igev = dis_ige - shift;
       return base::_geo_element [variant].dis_at (dis_igev);
    }
    shift += base::_geo_element [variant].ownership().first_index (iproc);
    first_dis_v = last_dis_v;
  }
  error_macro ("geo_element dis_index " << dis_ige 
	<< " cause problem; its range is [0:"<< base::_gs.ownership_by_dimension[dim].dis_size() << "[");
  return base::_geo_element [0].dis_at(0); // not reached
}
template <class T>
typename geo_rep<T,distributed>::size_type
geo_rep<T,distributed>::dis_ige2ios_dis_ige (size_type dim, size_type dis_ige) const
{
    const geo_element& K = dis_get_geo_element(dim,dis_ige);
    return K.ios_dis_ie();
}
// --------------------------------------------------------------------------
// access by geo_element(dim,idx)
// --------------------------------------------------------------------------
template <class T>
distributor
geo_rep<T,distributed>::geo_element_ios_ownership (size_type dim) const
{
  return _ios_ige2dis_ige[dim].ownership();
}
template <class T>
typename geo_rep<T,distributed>::size_type
geo_rep<T,distributed>::ios_ige2dis_ige (size_type dim, size_type ios_ige) const
{
  return _ios_ige2dis_ige[dim][ios_ige];
}
template <class T>
typename geo_rep<T,distributed>::size_type
geo_rep<T,distributed>::ige2ios_dis_ige (size_type dim, size_type ige) const
{
    const geo_element& K = get_geo_element(dim,ige);
    return K.ios_dis_ie();
}
/** -------------------------------------------------------------------------
 * utility: vertex ownership follows node ownership, but dis_numbering differ
 * for high order > 1 meshes. This function converts numbering.
 * --------------------------------------------------------------------------
 */
template <class T>
typename geo_rep<T,distributed>::size_type
geo_rep<T,distributed>::dis_inod2dis_iv (size_type dis_inod) const
{
  if (base::order() == 1) return dis_inod;
  distributor vertex_ownership = geo_element_ownership(0);
  distributor   node_ownership = base::_node.ownership();
  size_type iproc          =   node_ownership.find_owner(dis_inod);
  size_type first_dis_inod =   node_ownership.first_index(iproc);
  size_type first_dis_iv   = vertex_ownership.first_index(iproc);
  size_type   inod = dis_inod - first_dis_inod;
  size_type     iv = inod;
  size_type dis_iv = first_dis_iv + iv;
  return dis_iv;
}
template <class T>
typename geo_rep<T,distributed>::size_type
geo_rep<T,distributed>::dis_iv2dis_inod (size_type dis_iv) const
{
  if (base::order() == 1) return dis_iv;
  distributor vertex_ownership = base::_gs.ownership_by_variant [reference_element::p];
  distributor   node_ownership = base::_gs.node_ownership;
  size_type iproc          = vertex_ownership.find_owner(dis_iv);
  size_type first_dis_iv   = vertex_ownership.first_index(iproc);
  size_type first_dis_inod =   node_ownership.first_index(iproc);
  size_type       iv = dis_iv - first_dis_iv;
  size_type     inod = iv;
  size_type dis_inod = first_dis_inod + inod;
  return dis_inod;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class geo_rep<Float,distributed>;

} // namespace rheolef
#endif // _RHEOLEF_HAVE_MPI
