#ifndef _RHEOLEF_SPACE_CONSTANT_H
#define _RHEOLEF_SPACE_CONSTANT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// constants

#include "rheolef/distributed.h"

namespace rheolef { namespace space_constant {

typedef size_t size_type;

// -------------------------------------------------------------
// coordinate system helper
// -------------------------------------------------------------

typedef enum {
        cartesian       = 0,
        axisymmetric_rz = 1,
        axisymmetric_zr = 2,
        last_coord_sys  = 3
} coordinate_type;

coordinate_type coordinate_system      (std::string sys_coord);
std::string     coordinate_system_name (coordinate_type);
void check_coord_sys_and_dimension     (coordinate_type, size_type d);

// -------------------------------------------------------------
// multi-component field support
// -------------------------------------------------------------
typedef enum {
	scalar             = 0,
	vector             = 1,
	tensor             = 2, // symmetric, D_ij
        unsymmetric_tensor = 3,
        tensor4            = 4, // symmetric, A_ijkl
	mixed              = 5,
	last_valued        = 6
} valued_type;

const std::string& valued_name (valued_type tag);
valued_type valued_tag  (const std::string& name);

size_type n_component (
    valued_type        valued_tag,
    size_type          d,
    coordinate_type    sys_coord);

size_type n_component (
    const std::string& valued,
    size_type          d,
    coordinate_type    sys_coord);

// -------------------------------------------------------------
// 2-tensor support
// -------------------------------------------------------------
size_type tensor_index (
    valued_type       valued_tag,
    coordinate_type   sys_coord,
    size_type         i,
    size_type         j);

size_type tensor_index (
    std::string      valued,
    std::string      sys_coord, 
    size_type   i, 
    size_type   j);

std::pair<size_type,size_type>
tensor_subscript (
    valued_type       valued_tag,
    coordinate_type   sys_coord,
    size_type         i_comp);

std::string
tensor_subscript_name (
    valued_type       valued_tag,
    coordinate_type   sys_coord,
    size_type         i_comp);

std::pair<size_type,size_type>
tensor_subscript (
    std::string     valued,
    std::string     sys_coord,
    size_type       i_comp);

std::string
tensor_subscript_name (
    std::string     valued,
    std::string     sys_coord,
    size_type       i_comp);

}} // namespace rheolef::space_constant
#endif // _RHEOLEF_SPACE_CONSTITUTION_H
