///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// animations using vtk
//
// author: Pierre.Saramito@imag.fr
//
// date: 4 may 2001
//
#include "rheolef/branch.h"
#include "rheolef/iofem.h"
#include "rheolef/iorheo.h"
using namespace rheolef;
using namespace std;

void
branch::put_header_paraview (ostream& out) const
{
}
void 
branch::put_event_paraview (ostream& out) const
{
    // open the data file
    string basename = iorheo::getbasename(out);
    if (basename == "") basename = "output";
    string data_file_name = basename + "-" + itos(_count_value) + ".vtk";
    ofstream vtk (data_file_name.c_str());
    bool verbose = iorheo::getverbose(clog);
    verbose && clog << "! file `" << data_file_name << "' created" << endl;
    vtk << setbasename(basename)
        << setprecision(numeric_limits<Float>::digits10);

    assert_macro (n_field() > 0, "empty branch (n_field = 0)");
    const field& u0 = operator[](0).second;
    string approx = u0.get_approx();
    const geo& g0 = u0.get_geo();
    field z = iofem::gettopography(out);
    if (z.size() != 0) {
	// elevation view using topography
        check_macro (z.get_approx() == "P1", "unsupported " << z.get_approx()
		<< " elevation field");
        z.put_vtk_2d_elevation_P1 (vtk);
    } else {
        if (approx == "P1" || approx == "P0" ) {
            vtk << vtkdata << g0;
        } else if (approx == "P2") {
            vtk << lattice << vtkdata << g0;
        } else if (approx == "P1d") {
            g0.data().put_vtk_P1d(vtk);
        } else {
            fatal_macro ("P0, P1, P1d or P2 approximation expected: `" << approx << "' founded");
        }
    }
    bool have_header = false;
    for (size_t i = 0; i < n_field(); i++) {
      const string& xname  = operator[](i).first;
      const field&  x      = operator[](i).second;
      check_macro (x.get_approx() == approx,
	"field #"<<i<<" approx `"<<x.get_approx()<<"' incompatible with field #0 approx `"<<approx<<"'");
      if (x.get_valued() == "scalar") {
          x.put_vtk(vtk, xname, !have_header);
      } else if (x.get_valued() == "vector") {
          x.put_vtk_vector (vtk, xname, !have_header);
      } else { // x.get_valued() == "tensor"
          x.put_vtk_tensor (vtk, xname, !have_header);
      }
      have_header = true;
    }
    vtk.close();
}
void 
branch::put_finalize_paraview (ostream& out) const
{
}
