%{
// This file is part of Rheolef.
//
// Copyright (C) 2000-2009 Pierre Saramito 
//
// Rheolef is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Rheolef is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rheolef; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// lexer for qmg mesh files
// =========================================================================
%}
%union  { 
        int           empty;
        size_t        string_value;
}
%type <empty>         all name special family_name degree
%type <empty>         opt_d opt_list non_empty_opt_list
%token<string_value>  IDENTIFIER INTEGER BUBBLE P1QD
%token<empty>         D
%%
all     : name ';'
	;
name    : family_name degree opt_d opt_list
	| special
	;
opt_d   : /* empty */
		{ _current_fdo.option.set_continuous(); }
	| D
		{ _current_fdo.option.set_discontinuous(); }
	;
family_name : IDENTIFIER
		{ _current_fdo.family = symbol($1); }
	;
degree  : INTEGER
		{ _current_fdo.degree = std::atoi (symbol($1).c_str()); }
	;
special	: BUBBLE 
		{ _current_fdo.family = symbol($1);
		  _current_fdo.degree = 0; /* should be -1...*/ }
	| P1QD
		{ _current_fdo.family = symbol($1);
		  _current_fdo.degree = 1; }
	;
opt_list: /* empty */
		{ $$ = 0; }
	| '[' non_empty_opt_list ']'
		{ $$ = 0; }
	;
non_empty_opt_list : IDENTIFIER
		{ _current_fdo.option.set (symbol($1)); }
	| non_empty_opt_list ',' IDENTIFIER
		{ _current_fdo.option.set (symbol($3)); }
	;
%%
