
#ifndef MISC_UTILS_H
#define MISC_UTILS_H

#include "common.h"
#include <stdio.h>

/* contents immigrated from misc.h */

char *get_string_piece( FILE* file, int delim );
char *get_ascii_file( FILE *file );
void strip_trailing_space( char** string );
void strip_leading_space( char** string );
char *string_append( char **dest, char *appendage );
void charpp_to_charp( char** dest, char** src, int num, char* separator );
FILE *socket_init( const char *server, short int port );
char *int2str( int integer );
int get_subdirs( const char *path, char **buffer );

/* end of misc.h */

int add_argv( char **dest, char *content );
int process_options( char *options, char **argv,
                     int start, int end );

char **create_argv_for_execution_using_shell( char *command );
void free_argv( char **argv );
// don't forget to free argv (ignore this comment, it's just for me ;)

int parse_rx_format_string( char *target, int target_len,
                            char *format,
                            int track_no, char *w_fname, char *m_fname,
                            char *artist, char *album, char *song );
// track_no starts from 0
// %% %
// %w Wav file name
// %m Mp3 file name
// %a Artist
// %v album (Volume)
// %s Song

char *length_to_readable( unsigned length );
char *time_to_readable( time_t sec );
char *construct_file_name( char *path, char *name );
char *expand_tilde( char *path );
char *file_name_without_path( char *src );
char *file_path_without_name( char *src );
void auto_append_extension( char *src, int type );
char *get_default_file_name( int type, int track );
void remove_non_unix( char *src );
void convert_spaces( char *src );

int open_a_pty( int *pty, int *tty );
int is_str_blank( char *str );

#endif
