/*  rlwrap.h: includes, definitions, declarations */

/*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License , or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

    You may contact the author by:
       e-mail:  hlub@knoware.nl
*/

#include "../config.h"
#include <sys/types.h>
#if HAVE_SYS_WAIT_H
#  include <sys/wait.h>
#endif

#ifndef WEXITSTATUS
#  define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif


#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <ctype.h>

#include <errno.h>
#include <stdarg.h>

#define __USE_XOPEN
#define __USE_GNU
#include <stdlib.h>


#include <assert.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif


#ifdef HAVE_GETOPT_H
#  include <getopt.h>
#endif

#ifdef HAVE_TERM_H
#  include <term.h>
#endif

#if STDC_HEADERS
#  include <string.h>
#else
#  ifndef HAVE_STRRCHR
#    define strrchr rindex
#  endif
   char *strchr (), *strrchr ();
#  ifndef HAVE_MEMMOVE
#    define memmove(d, s, n) bcopy ((s), (d), (n))
#  endif
#endif


#ifdef HAVE_PTY_H
#  include <pty.h>
#endif
#ifdef HAVE_LIBUTIL_H
#  include <libutil.h>
#endif
#ifdef HAVE_UTIL_H
#  include <util.h>
#endif




#define BUFFSIZE 512


#ifdef  HAVE_SNPRINTF  /* don't rely on the compiler understanding variadic macros */
# define snprintf1(buf,bufsize,format,arg1) snprintf(buf,bufsize,format,arg1)
#else
# define snprintf1(buf,bufsize,format,arg1) sprintf(buf,format,arg1)
# define vsnprintf(buf,bufsize,format,ap)   vsprintf(buf,format,ap)
#endif


#ifndef HAVE_STRNLEN
# define strnlen(s,l) strlen(s)
#endif



#include <readline/readline.h>
#include <readline/history.h>

#ifdef SPY_ON_READLINE
# ifndef HOMEGROWN_REDISPLAY
#  define MAYBE_MULTILINE 1
# endif
#endif

#ifdef MAYBE_MULTILINE
extern int _rl_horizontal_scroll_mode; /* Spying on readline's private life .... */
#  define redisplay_multiple_lines (!_rl_horizontal_scroll_mode)
#else
#  define redisplay_multiple_lines FALSE
#endif

/* in main.c: */
extern int master_pty_fd; 
extern int slave_pty_fd;
extern FILE *debug_fp;
extern char *program_name, *command_name;
extern int always_readline;
extern int complete_filenames;
extern int child_pid;
extern int i_am_child;
extern int nowarn;
extern int debug;
extern char *password_prompt_search_string;

void init_rlwrap(void);
void cleanup_rlwrap_and_exit(int status);
void main_loop(int pty_fd);


/* in signals.c */
extern int child_is_dead, childs_exit_status, sigterm_received;
void install_signal_handlers(void);
void block_signals(int* sigs);
void unblock_signals(int* sigs);
void ignore_sigchld(void);

/* in utils.c */
void usage(void);
void mywarn(const char  *message, ...);
void myerror(const char *message, ...);
void *mymalloc(size_t size);
char *mybasename(char *filename);
char *mydirname(char *filename);
char *mystrndup(const char *string, int len);
void mystrlcpy(char *dst, const char *src, size_t size);
void mystrlcat(char *dst, const char *src, size_t size);
char *mysavestring(const char*string);
char *add3strings(const char *str1, const char *str2, const char *str3);
#define add2strings(a,b)  add3strings(a,b,"")
char *mangle_string_for_debug_log(char *string, int maxlen);
void open_logfile(const char *filename);
void write_logfile(const char *str);
void close_logfile(void);

/* in readline.c: */
extern struct rl_state {      /* struct to save readline text buffer and point */
  char text[BUFFSIZE];
  char prompt[BUFFSIZE];
  int  point;
  int  already_saved;         /* flag set when saved, cleared when restored */ 
} saved_rl_state;

void save_rl_state (struct rl_state *);
void restore_rl_state (struct rl_state *);
void init_readline(char *);
void line_handler(char *);
void my_redisplay(void);

extern  int within_line_edit, transparent;
extern  char previous_line[];

/* in pty.c: */
pid_t my_pty_fork ( int *, const struct termios *, const struct winsize *);
int slave_is_in_raw_mode(void);
void mirror_slaves_echo_mode(void);

/* in ptytty.c */
int  ptytty_get_pty (int *fd_tty, const char **ttydev);
int  ptytty_get_tty (const char *ttydev);
int  ptytty_control_tty (int fd_tty, const char *ttydev);
int  ptytty_openpty(int  *amaster,  int *aslave, const char **name);



/* in completion.c */
void init_completer(const char *);
void feed_into_completion_list(const char *);
char *my_completion_function(char *, int);

extern int  remember_for_completion;

/* in term.c */
int redisplay;                         /* TRUE when user input should be visible */  
void init_terminal(void);
void set_echo(int);
void prepare_terminal(void);
void cr(void);
void backspace(int);
void clear_line(void);
void clear_the_screen(void);
void curs_up(void);
void curs_down(void);
int  my_putchar(int c);
void cursor_hpos (int col);
extern struct termios saved_terminal_settings;
extern int terminal_settings_saved;
extern struct winsize window_size;
extern char *term_backspace, term_eof, term_stop, *term_cursor_hpos, *term_cursor_up, *term_cursor_down;

/* some handy macros */
#ifndef TRUE
#  define TRUE 1
#endif

#ifndef FALSE
#  define FALSE 0
#endif

#ifndef min
# define min(a,b) ((a) < (b) ? (a) : (b))
#endif

#ifndef max
# define max(a,b) ((a) < (b) ? (b) : (a))
#endif



/* if DEBUG is defined (via --debug configure option) then use DEBUG_FILENAME to write debug info */
#define DEBUG_FILENAME "/tmp/rlwrap.debug"

/* macros to write debug info */
#ifdef  DEBUG

#  define DEBUG_TERMIO                     	 1
#  define DEBUG_SIGNALS                    	 2
#  define DEBUG_READLINE                   	 4
#  define DEBUG_ALL                        	 (DEBUG_TERMIO | DEBUG_SIGNALS | DEBUG_READLINE)  

#ifdef __GNUC__
#  define WHERE                                	  fprintf(debug_fp, "%10s:%-3d\t%-25s ", __FILE__, __LINE__, __FUNCTION__)
#else
#  define WHERE                                   fprintf(debug_fp, "%10s:%-3d\t", __FILE__, __LINE__)
#endif

#  define NLFLUSH                                 fputc('\n', debug_fp) ; fflush(debug_fp)
#  define DPRINTF0(mask, format)                  if (debug & mask) {WHERE; fprintf(debug_fp, format); NLFLUSH; }
#  define DPRINTF1(mask, format,arg)              if (debug & mask) {WHERE; fprintf(debug_fp, format, arg); NLFLUSH; }
#  define DPRINTF2(mask, format,arg1, arg2)       if (debug & mask) {WHERE; fprintf(debug_fp, format, arg1, arg2); NLFLUSH; }
#  define DPRINTF3(mask, format,arg1, arg2, arg3) if (debug & mask) {WHERE; fprintf(debug_fp, format, arg1, arg2, arg3); NLFLUSH; }
#  define ERRMSG(b)                               (b && (errno != 0) ? add3strings("(", strerror(errno), ")") : "" )
#else
#  define DPRINTF0(mask, format) 
#  define DPRINTF1(mask, format,arg) 
#  define DPRINTF2(mask, format,arg1, arg2)
#  define DPRINTF3(mask, format,arg1, arg2, arg3)
#  define ERRMSG(b) 
#  define NDEBUG    /* disable assertions */
#endif





