//codecfilter_flac.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2014
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _CODECFILTER_FLAC_H_
#define _CODECFILTER_FLAC_H_

#include <roaraudio.h>

#if defined(ROAR_HAVE_LIBFLAC)

#include <FLAC/all.h>

struct codecfilter_flac_inst {
 struct roar_stream_server * ss;
 struct {
  FLAC__StreamDecoder * decoder;
  struct roar_buffer * written;
  ssize_t readret;
  size_t readc;
 } decoder;
};

FLAC__StreamDecoderReadStatus cf_flac_cb_read(const FLAC__StreamDecoder *decoder, FLAC__byte buffer[], unsigned *bytes, void *client_data);
FLAC__StreamDecoderWriteStatus cf_flac_cb_write(const FLAC__StreamDecoder *decoder, const FLAC__Frame *frame, const FLAC__int32 * const buffer[], void *client_data);
void cf_flac_cb_metadata(const FLAC__StreamDecoder *decoder, const FLAC__StreamMetadata *metadata, void *client_data);
void cf_flac_cb_error(const FLAC__StreamDecoder *decoder, FLAC__StreamDecoderErrorStatus status, void *client_data);

int cf_flac_open(CODECFILTER_USERDATA_T * inst, int codec,
                                            struct roar_stream_server * info,
                                            struct roar_codecfilter   * filter);

int cf_flac_close(CODECFILTER_USERDATA_T   inst);

int cf_flac_write(CODECFILTER_USERDATA_T   inst, char * buf, int len);
int cf_flac_read(CODECFILTER_USERDATA_T   inst, char * buf, int len);

int cf_flac_ctl(CODECFILTER_USERDATA_T   inst, int cmd, void * data);

#endif

#endif

//ll
