/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Dice.h - Dice Class
 * Created by Robert Heller on Tue Jul 14 17:21:56 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Dice.h,v $
 * Revision 1.3  1999/07/13 00:29:40  heller
 * Documentation updates (spelling, punctionation, spelling, caps/nocaps).
 *
 * Revision 1.2  1998/12/27 21:48:19  heller
 * Spelling errors fixed.
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _DICE_H_
#define _DICE_H_

#if SIZEOF_LONG == 4
typedef long int int32;
typedef unsigned long int uint32;
#else if SIZEOF_INT == 4
typedef int int32;
typedef unsigned int uint32;
#endif

#include <stdlib.h>

#ifndef HAVE_BOOL
typedef enum bool {false=0, true=1};
#define HAVE_BOOL 1
#endif

//@Man: Random number games.
/*@Doc:

  \typeout{Generated from $Id: Dice.h,v 1.3 1999/07/13 00:29:40 heller Rel1 $.}

  First a PD random number generator then a class that
  implements dice.
 */

//@{

/*@ManDoc:
   RandomInteger class -- generate a random number in the range specified.

 This random number generator originally appeared in "Toward a Universal
 Random Number Generator" by George Marsaglia and Arif Zaman.
 Florida State University Report: FSU-SCRI-87-50 (1987)

 It was later modified by F. James and published in "A Review of Pseudo-
 random Number Generators".

 Converted from FORTRAN to C by Phil Linttell, James F. Hickling
 Management Consultants Ltd. Aug. 14, 1989.

 THIS IS THE BEST KNOWN RANDOM NUMBER GENERATOR AVAILABLE.
       (However, a newly discovered technique can yield
         a period of $10^{600}$. But that is still in the development stage.)

 It passes ALL of the tests for random number generators and has a period
   of $2^{144}$, is completely portable (gives bit identical results on all
   machines with at least 24-bit mantissas in the floating point
   representation).

 The algorithm is a combination of a Fibonacci sequence (with lags of 97
   and 33, and operation "subtraction plus one, modulo one") and an
   "arithmetic sequence" (using subtraction).

 On a Vax 11/780, this random number generator can produce a number in
    13 microseconds.

 */

class RandomInteger {
private:
	//@ManDoc: lower bound.
	int l;
	//@ManDoc: upper bound.
	int h;
	float u[97], c, cd, cm;
	int i97, j97;
	bool test;
	/*@ManDoc:
 This is the initialization routine for the random number generator RANMAR().
 NOTE: The seed variables can have values between:    $0 \leq IJ \leq 31328$
                                                      $0 \leq KL \leq 30081$.
 The random number sequences created by these two seeds are of sufficient
 length to complete an entire calculation with. For example, if several
 different groups are working on different parts of the same calculation,
 each group could be assigned its own IJ seed. This would leave each group
 with 30000 choices for the second seed. That is to say, this random
 number generator can create 900 million different subsequences -- with
 each subsequence having a length of approximately $10^{30}$.

 Use $IJ = 1802$ and $KL = 9373$ to test the random number generator. The
 subroutine RANMAR should be used to generate 20000 random numbers.
 Then display the next six random numbers generated multiplied by 4096*4096.
 If the random number generator is working properly, the random numbers
 should be:
 \begin{centering}
 \begin{tabular}{rrr}
           6533892.0 & 14220222.0 &  7275067.0 \\
           6172232.0 &  8354498.0 & 10633180.0 \\
 \end{tabular}
 \end{centering}
	 */
	int rmarin(int ij, int kl);
	int ranmar(float rvec[], int len);
	void _seed();
public:
	//@ManDoc: constructor;
	RandomInteger(int low,int high)
	{
		l = low;
		h = high;
		_seed();
	}		
	int operator () ()
	{
		float rvec[1];
		ranmar(rvec,1);
		double f1 = rvec[0] * (h-l);
		double f2 = f1 + .5;
		int32 i1 = (int32) f2;
		return (i1 + l);
	}
};


/*@ManDoc:
  Dice Class -- Just a random number generator using a dice model.
  */
class Dice {
private:
	//@ManDoc: Random number generator. 
	RandomInteger *dice;
	//@ManDoc: Number of sides (0 = percentile dice).
	unsigned int nsides;
	//@ManDoc: Number of dice.
	unsigned int ndice;
	//@ManDoc: Internal initializer.
	void _Dice();
public:
	//@ManDoc: Constructor, create 1 or more dice.
	Dice(
		//@ManDoc: Number of sides (0 = percentile dice).
		unsigned int ns,
		//@ManDoc: Number of dice.
		unsigned int nd = 1
	)
	    {nsides = ns;ndice = nd;dice = NULL;_Dice();}
	//@ManDoc: Constructor -- uninitialized dice.
	Dice() {nsides = 0;ndice = 0; dice = NULL;}
	//@ManDoc: Destructor.
	~Dice();
	//@ManDoc: Roll them bones...
	unsigned int Roll();
	//@ManDoc: Return the type of dice.
	bool TypeOfDice(
		//@ManDoc: Number of sides (0 = percentile dice).
		unsigned int& ns,
		//@ManDoc: Number of dice.
		unsigned int& nd
	)
	{
		ns = nsides;
		nd = ndice;
		if (dice == NULL) return(false); 
		else return(true);
	}
};

//@}
	
#endif // _DICE_H_

