/* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Monster.cc - Monster class.
 * Created by Robert Heller on Sun Jul 19 14:05:32 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Monster.cc,v $
 * Revision 1.3  1998/12/27 21:48:19  heller
 * Spelling errors fixed.
 *
 * Revision 1.2  1998/08/19 17:40:40  heller
 * Add in missing 'else'
 *
 * Revision 1.1  1998/08/04 21:17:00  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <Monster.h>
#include <Dice.h>
#include <stdio.h>

static char rcsid[] = "$Id: Monster.cc,v 1.3 1998/12/27 21:48:19 heller Rel1 $";

Monster::Monster (const Monster *that)
{
	UpdateFromRecord(that->rawData);
}

Monster::Monster (const Monster &that)
{
	UpdateFromRecord(that.rawData);
}

Monster::Monster (const Record *rec)
{
	UpdateFromRecord(*rec);
}

void Monster::RecordToMonster ()
{
	register char* str = rawData.buffer;	// Data string
	register int   bytesleft = rawData.size; // Number of bytes

	name = NULL;
	alignment = NULL;
	treasureType = NULL;
	specialAttacks = NULL;
	specialDefences = NULL;
	psionics = NULL;
	comments = NULL;
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'n': name = str; break;
			case 'a': alignment = str; break;
			case 't': treasureType = str; break;
			case 'x': specialAttacks = str; break;
			case 'd': specialDefences = str; break;
			case 'p': psionics = str; break;
			case 'T': comments = str; break;
			case 'I': image = str; break;
			case 'H': hitpoints = atol(str); break;
			case 'D': hdie = atoi(str); break;
			case 'N': ndie = atoi(str); break;
			case 'A': hplus = atoi(str); break;
			case 'X': armclass = atoi(str); break;
			case 'm': move = atoi(str); break;
			case 'f': move_fly = atoi(str); break;
			case 's': move_swim = atoi(str); break;
			case 'b': move_burrow = atoi(str); break;
			case 'w': move_web = atoi(str); break;
			case 'l': percentLair = atoi(str); break;
			case 'u': numatt = atoi(str); break;
			case 'M': magres = atoi(str); break;
			case '+': damatt.l = atoi(str); break;
			case '-': damatt.h = atoi(str); break;
			case '!': noappearing.l = atoi(str); break;
			case '@': noappearing.h = atoi(str); break;
			case 'i': {
				if (strcmp(str,"Non") == 0) intelligence = Non;
				else if (strcmp(str,"Animal") == 0) intelligence = Animal;
				else if (strcmp(str,"Semi") == 0) intelligence = Semi;
				else if (strcmp(str,"Low") == 0) intelligence = Low;
				else if (strcmp(str,"Average") == 0) intelligence = Average;
				else if (strcmp(str,"Very") == 0) intelligence = Very;
				else if (strcmp(str,"Highly") == 0) intelligence = Highly;
				else if (strcmp(str,"Exceptionally") == 0) intelligence = Exceptionally;
				else if (strcmp(str,"Genius") == 0) intelligence = Genius;
				else if (strcmp(str,"SupraGenius") == 0) intelligence = SupraGenius;
				else if (strcmp(str,"Godlike") == 0) intelligence = Godlike;
				else intelligence = BogusIntelligence;
				break;
				  }
			case 'q': {
				if (strcmp(str,"Unique") == 0) frequency = Unique;
				else if (strcmp(str,"VeryRare") == 0) frequency = VeryRare;
				else if (strcmp(str,"Rare") == 0) frequency = Rare;
				else if (strcmp(str,"Uncommon") == 0) frequency = Uncommon;
				else if (strcmp(str,"Common") == 0) frequency = Common;
				else frequency = BogusFrequency;
				break;
			          }
			case 'h': {
				if (strcmp(str,"Points") == 0) hittype = Points;
				else if (strcmp(str,"Dice") == 0) hittype = Dice;
				else hittype = BogusHitType;
				break;
				  }
			case 'S': size = atof(str); break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
	
}

void Monster::UpdateRecord()
{
	static char hitpointsS[12],
		    hdieS[4],
		    ndieS[4],
		    hplusS[4],
		    armclassS[4],
		    moveS[4],
		    move_flyS[4],
		    move_swimS[4],
		    move_burrowS[4],
		    move_webS[4],
		    percentLairS[4],
		    numattS[4],
		    magresS[4],
		    damattlS[4],
		    damatthS[4],
		    noappearinglS[4],
		    noappearinghS[4],
		    sizeS[12];
	char *intelligenceS, *frequencyS, *hittypeS;
	// form numeric strings
	sprintf(hitpointsS,"%d",hitpoints);
	sprintf(hdieS,"%d",hdie);
	sprintf(ndieS,"%d",ndie);
	sprintf(hplusS,"%d",hplus);
	sprintf(armclassS,"%d",armclass);
	sprintf(moveS,"%d",move);
	sprintf(move_flyS,"%d",move_fly);
	sprintf(move_swimS,"%d",move_swim);
	sprintf(move_burrowS,"%d",move_burrow);
	sprintf(move_webS,"%d",move_web);
	sprintf(percentLairS,"%d",percentLair);
	sprintf(numattS,"%d",numatt);
	sprintf(magresS,"%d",magres);
	sprintf(damattlS,"%d",damatt.l);
	sprintf(damatthS,"%d",damatt.h);
	sprintf(noappearinglS,"%d",noappearing.l);
	sprintf(noappearinghS,"%d",noappearing.h);
	sprintf(sizeS,"%f",size);
	switch (intelligence)
	{
		case Non: intelligenceS = "Non"; break;
		case Animal: intelligenceS = "Animal"; break;
		case Semi: intelligenceS = "Semi"; break;
		case Low: intelligenceS = "Low"; break;
		case Average: intelligenceS = "Average"; break;
		case Very: intelligenceS = "Very"; break;
		case Highly: intelligenceS = "Highly"; break;
		case Exceptionally: intelligenceS = "Exceptionally"; break;
		case Genius: intelligenceS = "Genius"; break;
		case SupraGenius: intelligenceS = "SupraGenius"; break;
		case Godlike: intelligenceS = "Godlike"; break;
		default: intelligenceS = "BogusIntelligence"; break;
	}
	switch (frequency)
	{
		case Unique: frequencyS = "Unique"; break;
		case VeryRare: frequencyS = "VeryRare"; break;
		case Rare: frequencyS = "Rare"; break;
		case Uncommon: frequencyS = "Uncommon"; break;
		case Common: frequencyS = "Common"; break;
		default: frequencyS = "BogusFrequency"; break;
	}
	switch (hittype)
	{
		case Points: hittypeS = "Points"; break;
		case Dice: hittypeS = "Dice"; break;
		default: hittypeS = "BogusHitType"; break;
	}
	int rsize =  9 +	// "*Monster\0"
		((name)?(strlen(name)):(0)) + 3 + // "%nxxx\0"
		((alignment)?(strlen(alignment)):(0)) + 3 + // "%axxx\0"
		((treasureType)?(strlen(treasureType)):(0)) + 3 + // "%txxx\0"
		((specialAttacks)?(strlen(specialAttacks)):(0)) + 3 + // "%xxxx\0"
		((specialDefences)?(strlen(specialDefences)):(0)) + 3 + // "%dxxx\0"
		((psionics)?(strlen(psionics)):(0)) + 3 + // "%pxxx\0"
		((comments)?(strlen(comments)):(0)) + 3 + // "%Tnnn\0"
		((image)?(strlen(image)):(0)) + 3 + // "%Innn\0"
		strlen(hitpointsS) + 3 + // "%Hnnn\0"
		strlen(hdieS) + 3 + // "%Dnnn\0"
		strlen(ndieS) + 3 + // "%Nnnn\0"
		strlen(hplusS) + 3 + // "%Annn\0"
		strlen(armclassS) + 3 + // "%Xnnn\0"
		strlen(moveS) + 3 + // "%mnnn\0"
		strlen(move_flyS) + 3 + // "%fnnn\0"
		strlen(move_swimS) + 3 + // "%snnn\0"
		strlen(move_burrowS) + 3 + // "%bnnn\0"
		strlen(move_webS) + 3 + // "%wnnn\0"
		strlen(percentLairS) + 3 + // "%lnnn\0"
		strlen(numattS) + 3 + // "%unnn\0"
		strlen(magresS) + 3 + // "%Mnnn\0"
		strlen(damattlS) + 3 + // "%+nnn\0"
		strlen(damatthS) + 3 + // "%-nnn\0"
		strlen(noappearinglS) + 3 + // "%!nnn\0"
		strlen(noappearinghS) + 3 + // "%@nnn\0"
		strlen(intelligenceS) + 3 + // "%innn\0"
		strlen(frequencyS) + 3 + // "%qnnn\0"
		strlen(hittypeS) + 3 + // "%hnnn\0"
		strlen(sizeS) + 3 + // "%Snnn\0"
		strlen("\n") + 1;               // "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	strcpy(p,"*Monster"); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'n'; if (name) strcpy(p,name); else strcpy(p,""); name = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'a'; if (alignment) strcpy(p,alignment); else strcpy(p,""); alignment = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 't'; if (treasureType) strcpy(p,treasureType); else strcpy(p,""); alignment = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'x'; if (specialAttacks) strcpy(p,specialAttacks); else strcpy(p,""); alignment = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'd'; if (specialDefences) strcpy(p,specialDefences); else strcpy(p,""); alignment = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'p'; if (psionics) strcpy(p,psionics); else strcpy(p,""); alignment = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; if (comments) strcpy(p,comments); else strcpy(p,""); comments = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'I'; if (image) strcpy(p,image); else strcpy(p,""); image = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'H'; strcpy(p,hitpointsS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; strcpy(p,hdieS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'N'; strcpy(p,ndieS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'A'; strcpy(p,hplusS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'X'; strcpy(p,armclassS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'm'; strcpy(p,moveS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'f'; strcpy(p,move_flyS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 's'; strcpy(p,move_swimS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'b'; strcpy(p,move_burrowS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'w'; strcpy(p,move_webS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'l'; strcpy(p,percentLairS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'u'; strcpy(p,numattS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'M'; strcpy(p,magresS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = '+'; strcpy(p,damattlS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = '-'; strcpy(p,damatthS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = '!'; strcpy(p,noappearinglS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = '@'; strcpy(p,noappearinghS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'i'; strcpy(p,intelligenceS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'q'; strcpy(p,frequencyS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'h'; strcpy(p,hittypeS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'S'; strcpy(p,sizeS); p += strlen(p) + 1;
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	rawData.NewBuffer(0);
	// paste in new buffer
	rawData.size = rsize;
	rawData.buffer = str;
}

MonsterInstance::MonsterInstance(const Monster *iOf, const char *iN)
{
	const char *nn;
	if (iOf->Frequency() == Monster::Unique && (iN == NULL || strlen(iN) == 0))
	{
		nn = iOf->Name();
	} else
	{
		nn = iN;
		if (nn == NULL) nn = "";
	}
	instanceName = new char[strlen(nn)+1];
	strcpy((char*)instanceName,nn);
	instanceOf = iOf;
	if (iOf->Hittype() == Monster::Points)
	{
		instanceHitPoints = iOf->HitPoints();
	} else if (iOf->Hittype() == Monster::Dice)
	{
		Dice md(iOf->HitDieSides(),iOf->NumHitDice());
		instanceHitPoints = md.Roll() + iOf->HitAdjustment();
	} else
	{
		instanceHitPoints = 0;
	}
}

MonsterInstance::MonsterInstance(const MonsterInstance *that)
{
	instanceName = new char[strlen(that->instanceName)+1];
	strcpy((char*)instanceName,instanceName);
	instanceOf = that->instanceOf;
	if (instanceOf->Hittype() == Monster::Points)
	{
		instanceHitPoints = instanceOf->HitPoints();
	} else if (instanceOf->Hittype() == Monster::Dice)
	{
		Dice md(instanceOf->HitDieSides(),instanceOf->NumHitDice());
		instanceHitPoints = md.Roll() + instanceOf->HitAdjustment();
	} else
	{
		instanceHitPoints = 0;
	}
}

MonsterInstance::MonsterInstance(const MonsterInstance &that)
{
	instanceName = new char[strlen(that.instanceName)+1];
	strcpy((char*)instanceName,instanceName);
	instanceOf = that.instanceOf;
	if (instanceOf->Hittype() == Monster::Points)
	{
		instanceHitPoints = instanceOf->HitPoints();
	} else if (instanceOf->Hittype() == Monster::Dice)
	{
		Dice md(instanceOf->HitDieSides(),instanceOf->NumHitDice());
		instanceHitPoints = md.Roll() + instanceOf->HitAdjustment();
	} else
	{
		instanceHitPoints = 0;
	}
}





