#ifndef DRAWING_AREA_H
#define DRAWING_AREA_H

#include <X11/Xlib.h>

class DrawingArea
{
public:
        DrawingArea();
        virtual ~DrawingArea();
        void set_x(int nx);
        void set_y(int ny);
        void set_width(int nwidth);
        void set_height(int nheight);
        
        int get_x() {
                return x;
        }
        int get_y() {
                return y;
        }
        int get_width() {
                return width;
        }
        int get_height() {
                return height;
        }

        bool intersects_with_exposed_area(XExposeEvent *ev);
        void erase();
        virtual void redraw(XExposeEvent *ev) = 0;
        
        int x, y, width, height;
protected:
        Window root;
        GC gc;
        int screen;
};

#endif
