#define _XOPEN_SOURCE 500
#include <iostream>
#include <fstream>
using namespace std;

// the following define is a bit of a workaround to get rid of a warning
#define	_ALLOCA_H	1
#include <applet-widget.h>

#include "common.h"
#include "utils.h"
#include "root-portal.xpm"
#include "root-portal-tiny.xpm"

#include <sys/types.h>
#include <signal.h>

#define CONFIG_DIR ".root-portal"

static GtkWidget *applet = 0;
static GdkPixmap *pixmap = 0;
static GtkWidget *pixmapwid = 0;

static int get_rp_pid()
{
        // assumes that the environment variable, DISPLAY is set
        // correctly (ie it wasn't explicitly set with -d etc)
        string lockfilename = string(getenv("HOME"))
                + "/" CONFIG_DIR "/lock." + string(getenv("DISPLAY"));
        ifstream lockfile;
        lockfile.open(lockfilename.c_str(), ios::in);
        if (lockfile.is_open()) {
                int pid;
                lockfile >> pid;
                lockfile.close();
                string check_for = "root-portal";
                string other_exe = get_exe(pid);
                if (other_exe.length() >= check_for.length()) {
                        string prog(other_exe, other_exe.length() - check_for.length(),
                                    check_for.length());
                        if (prog != check_for)
                                return 0;
                } else {
                        return 0;
                }
                return pid;
        }
        return 0;
}

static void startup_cb(AppletWidget* widget, void *data)
{
        if (!get_rp_pid()) {
                system("root-portal -n &");
        }
}

static void shutdown_cb(AppletWidget* widget, void *data)
{
        int rppid = get_rp_pid();
        if (rppid) {
                kill(rppid, SIGTERM);
        }
}

static void configure_cb(AppletWidget* widget, void *data)
{
        int rppid = get_rp_pid();
        if (rppid) {
                kill(rppid, SIGUSR2);
        } else {
                system("root-portal -c &");
        }
}

static void set_pixmap(int size)
{
        GdkBitmap *mask;

        if (size < 48) {
                pixmap = gdk_pixmap_create_from_xpm_d(applet->window, &mask,
                                                      NULL,
                                                      (gchar **)root_portal_tiny_xpm);
        } else {
                pixmap = gdk_pixmap_create_from_xpm_d(applet->window, &mask,
                                                      NULL,
                                                      (gchar **)root_portal_xpm);
        }
        if (pixmapwid == NULL) {
                pixmapwid = gtk_pixmap_new(pixmap, mask);
                gtk_widget_show(pixmapwid);
                applet_widget_add(APPLET_WIDGET(applet), pixmapwid);
        } else {
                gtk_pixmap_set(GTK_PIXMAP(pixmapwid), pixmap, mask);
        }
}

#ifdef HAVE_PANEL_PIXEL_SIZE
/*this is when the panel size changes*/
static void applet_change_pixel_size(GtkWidget *w, int size, gpointer data)
{
        set_pixmap(size);
}
#endif

int main(int argc, char **argv)
{
        applet_widget_init("root-portal_applet", VERSION, argc, argv, NULL, 0, NULL);

        applet = applet_widget_new("root-portal_applet");
        gtk_widget_realize(applet);

#ifdef HAVE_PANEL_PIXEL_SIZE
        /*we have to bind change_pixel_size before we do applet_widget_add 
          since we need to get an initial change_pixel_size signal to set our
          initial size, and we get that during the _add call*/
        gtk_signal_connect(GTK_OBJECT(applet),"change_pixel_size",
                           GTK_SIGNAL_FUNC(applet_change_pixel_size), NULL);
        set_pixmap(24);
#else
        set_pixmap(48);
#endif

        applet_widget_register_stock_callback(APPLET_WIDGET(applet), "Shutdown", "Quit",
                                              "Shutdown", shutdown_cb, NULL);
        applet_widget_register_stock_callback(APPLET_WIDGET(applet), "Configure", "Preferences",
                                              "Configure", configure_cb, NULL);
        applet_widget_register_stock_callback(APPLET_WIDGET(applet), "Startup", "Exec",
                                              "Startup", startup_cb, NULL);
        
        gtk_widget_show(applet);

        applet_widget_gtk_main();
        return 0;
}
