#include "../module_tree.h"
#include "childvarentry.h"

static void selectionDone(GtkMenuShell* widget, ChildVarEntry* data)
{
        data->changed();
}

ChildVarEntry::ChildVarEntry(const string& varName, const Path& mod_,
                             ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        optionMenu = gtk_option_menu_new();
        menu = gtk_menu_new();
        gtk_signal_connect(GTK_OBJECT(menu), "selection-done", GTK_SIGNAL_FUNC(selectionDone), this);

        addOutputsFromChildren(mod);

        gtk_option_menu_set_menu(GTK_OPTION_MENU(optionMenu), menu);
        gtk_box_pack_start(GTK_BOX(hbox), optionMenu, true, true, 40);

        reload();
}

void ChildVarEntry::addOutputsFromChildren(const Path& m)
{
        try {
                int child_count = ModuleTree::instance()->child_count(m);
                for (int i = 0; i < child_count; i++) {
                        Path cmod = m;
                        cmod.add_last(i);

                        const DataSetMap* m = ModuleTree::instance()->module_info(cmod);
                        assert (m);
                        const DataSetMap& mInf = *m;
                        const DataSet& output_variables = mInf["output_variables"];
        
                        for (int j = 0; j < output_variables.count(); j++) {
                                string name = output_variables.getString(j);
                
                                if (name == "CHILD_VARS") {
                                        addOutputsFromChildren(cmod);
                                } else {
                                        bool found = false;
                                        for (vector<string>::const_iterator k = names.begin(); k != names.end(); ++k) {
                                                if (*k == name)
                                                        found = true;
                                        }
                                        if (!found) {
                                                names.push_back(name);
                                                
                                                GtkWidget* menuItem = gtk_menu_item_new_with_label(const_cast<gchar *> (name.c_str()));
                                                gtk_object_set_user_data(GTK_OBJECT(menuItem), reinterpret_cast<void *> (names.size() - 1));
                                                gtk_menu_append(GTK_MENU(menu), menuItem);
                                        }
                                }                                
                        }
                }
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}
        
DataSet ChildVarEntry::getValue()
{
        if (names.size() > 0) {
                GtkWidget* active = gtk_menu_get_active(GTK_MENU(menu));
                long index = long(gtk_object_get_user_data(GTK_OBJECT(active)));
                string newValue = names[index];
                return DataSet(newValue);
        } else {
                return DataSet();
        }
}

void ChildVarEntry::setValue(const DataSet& value)
{
        if (value.count() > 0) {
                for (unsigned int i = 0; i < names.size(); i++) {
                        if (names[i] == value.getString()) {
                                gtk_option_menu_set_history(GTK_OPTION_MENU(optionMenu), i);
                        }
                }
        }
}
