(define-fluid *message-prefix* #f)

(define (with-message-prefix plc thunk)
  (fluid-let ((*message-prefix* plc))
    (thunk)))

(&module (export with-message-prefix))

;;;

(define-class <error-message> (<condition>)
  (message-prefix init-value: #f)
  (message type: <message>)
  (arguments type: <vector> init-value: '#()))

(define-method display-object ((self <error-message>) port)
  (display-message (message self) port (arguments self) (message-prefix self)))

#|
(define-syntax em
  (syntax-rules ()
    ((_ id fmt arg ...)
     (error (make <error-message>
		  message: (message id fmt)
		  arguments: (vector arg ...))))
    ((_ fmt arg ...)
     (error (make <error-message>
		  message: (message fmt)
		  arguments: (vector arg ...))))))
|#

(define (foo t args)
  (cond
   ((eq? (car args) 'at:)
    (bind ((a b (foo t (cddr args))))
      (values a b (list (cadr args)))))
   ((eq? (car args) 'type:)
    (bind ((a b c (foo t (cddr args))))
      (values (cons (cadr args) (cdr a)) b c)))
   (else
    (if (fixnum? (car args))
	(values (list t (car args) (cadr args)) (cddr args) '())
	(values (list t (car args)) (cdr args) '())))))

(define (signal-message msg argv . mp)
  (signal (make <error-message>
		message-prefix: (if (null? mp) *message-prefix* (car mp))
		message: msg
		arguments: argv)))
(define (error-message msg argv . mp)
  (error (make <error-message>
		message-prefix: (if (null? mp) *message-prefix* (car mp))
		message: msg
		arguments: argv)))

;;; signal a message

(define-macro (sm . args)
  (bind ((msg args xtra (foo 'error args)))
    `(',signal-message (alloc-message ,@msg)
		       (',vector ,@args) ,@xtra)))

(define-macro (em . args)
  (bind ((msg args xtra (foo 'fatal args)))
    `(',error-message (alloc-message ,@msg)
		      (',vector ,@args) ,@xtra)))
   

(&module (export sm em))
