/*------------------------------------------------------------------*-C-*-*
 * %Z%1.29  %G% 09:49:41 %W%
 *
 * Purpose:	
 *
 *------------------------------------------------------------------------*
 * Notes:
 *------------------------------------------------------------------------*/

char *__rstore_util_sccsid__() { return "%Z%%W% 1.29 %G% 09:49:41"; }

#include <stdio.h>
#include <string.h>
#include "rstoret.h"
#include "alloc.h"
#include "mmglue.h"
#include <rscheme/scheme.h>
#include <rscheme/writebar.h>
#include "indirect.h"
#include "swizzler.h"

#define CLIENT_INFO_RECNUM  (0)
    
/* #define VERBOSE */

/* usage of lss's client misc[] area */

struct swiz_mode_handler *(app_swiz_mode_handlers[10]);

extern IRC_Heap *gc_arena;

#define MAX_ACTIVE_RSTORES  (10)

static RStore *(rstores[MAX_ACTIVE_RSTORES]);
static unsigned num_rstores;
obj alloc_area_class; /* initialized by (open-rstore) */

void rstore_error_handler( LSS *lss, void *info, int code, char *msg )
{
  scheme_error( "lss error: ~a (~d)\nin ~s",
	        3,
	        make_string(msg),
	        int2fx(code), 
	        ((RStore *)info)->owner );
}

void plain_lss_error_handler( LSS *lss, void *info, int code, char *msg )
{
  scheme_error( "lss error: ~a (~d)",
	        2,
	        make_string(msg),
	        int2fx(code) );
}

struct swiz_mode_handler *get_swiz_mode_handler( RStore *sto,
						 enum SwizzleMode mode )
{
  struct swiz_mode_handler **p;

  for (p=sto->swiz_mode_handlers; *p; p++)
    {
      if ((*p)->handles == mode)
	return *p;
    }
  scheme_error( "image mode ~d not handled by ~s", 
		2, int2fx(mode), sto->owner );
  return NULL;
}

void rstore_add_swiz_mode_handler( RStore *sto, struct swiz_mode_handler *h )
{
  struct swiz_mode_handler **p;

  if (h->handles >= SWIZ_MODE_APP_0 && h->handles <= SWIZ_MODE_APP_9)
    {
      for (p=sto->swiz_mode_handlers; *p; p++)
	{
	  if ((*p)->handles == h->handles)
	    {
	      scheme_error( "swizzle mode ~d already handled", 
			    1, int2fx( h->handles ) );
	    }
	}
      if (p >= (sto->swiz_mode_handlers + 10))
	scheme_error( "swizzle mode handler table full", 0 );
      *p++ = h;
      *p = NULL;
    }
  else
    scheme_error( "swizzle mode ~d not valid for app swizzler",
		  1, int2fx( h->handles ) );
}

static rs_bool mminit = NO;

static void init_new( RStore *store )
{
  store->next_page = 0x1000000;
  store->next_indirect_page = 256;   /* 0...63 reserved for the system,
					64..255 for app. pivot pages */
  
  /* create the first allocation area */
  
  store->default_area = make_alloc_area( store, FALSE_OBJ );
  store->using_rich_model = LRU_RICH_MODEL;
}

obj identify_rich_model( LSS *lss )
{
  struct RStoreCommitInfo ci;
  zipbuf v[2];
  LSSAccess *a;
  obj m;

  a = lss_read_access( lss, CLIENT_INFO_RECNUM );

  if (!a)
    {
      return FALSE_OBJ;
    }

  v[0].ptr = &ci;
  v[0].limit = 1 + &ci;
  v[1].ptr = v[1].limit = NULL;
  
  lss_readv( lss, v, a );
  lss_read_release( lss, a );
  
  if (strcmp( ci.tag, "RStore-3.0" ) == 0)
    {
      m = int2fx( LRU_RICH_MODEL );
    }
  else if (strcmp( ci.tag, "TKG-RStore-1.0" ) == 0)
    {
      m = int2fx( OLD_RICH_MODEL );
    }
  else
    {
      return FALSE_OBJ;
    }
  return cons( m, cons( int2fx( ci.default_area.base_page_num ),
                        int2fx( ci.default_area.offset ) ) );
}

static void init_existing( RStore *store, struct RStoreCommitInfo *ci )
{
  obj aa = translate_LR( store, ci->default_area );

  store->next_page = ci->next_page_num;
  store->next_indirect_page = ci->next_indirect_page;
  store->default_area = PTR_TO_DATAPTR( aa );
  
  if (strcmp( ci->tag, "RStore-3.0" ) == 0)
    {
      store->using_rich_model = LRU_RICH_MODEL;
    }
  else if (strcmp( ci->tag, "TKG-RStore-1.0" ) == 0)
    {
      store->using_rich_model = OLD_RICH_MODEL;
    }
}

obj rstore_get_live_objects( RStore *owner, obj otbl )
{
  struct IRC_PtrBucket *b;
  IRC_Header **p, **lim;
  unsigned n = 0;

  for (b=owner->the_gen.pstorePrevPointers.first; b; b=b->next) {
    lim = b->ptr;
    for (p=b->contents; p<lim; p++) {
      obj k = GCPTR_TO_PTR( (*p)+1 );
      obj h = obj_hash( k );

      /*printf( "pstore live[%u] (@%p) %08x <%08x>\n", n, p, *p, k );*/
      n++;
#if 1
      objecttable_insert( otbl, h, k, TRUE_OBJ );
#else /* this branch is useful for debugging who's holding those pointers... */
      if (!objecttable_probe( otbl, h, k )) {
        objecttable_insert( otbl, h, k, all_pointers_to( k ) );
      }
#endif
    }
  }
  return int2fx( n );
}

RStore *rstore_open( obj owner, LSS *lss )
{
  RStore *store;
  LSSAccess *a;

  if (num_rstores >= MAX_ACTIVE_RSTORES)
    scheme_error( "rstore: too many active pstores", 1, owner );

  if (!mminit)
    {
      init_mm();
      mminit = YES;
      rstore_init_psizeclass();
    }

  store = ALLOC( struct RStore );
  store->owner = owner;
  store->data_zipper = NULL;    /* by default, don't compress */
  store->id_pages = 0;          /* not ready for prime time yet... */

  rstores[num_rstores++] = store;

  store->swiz_mode_handlers[0] = NULL;
  store->lss = lss;

  /* extract appropriate tables and values from the owner */

  store->pivot_table = gvec_ref( owner, SLOT(1) );
  store->local_code_ptrs = gvec_ref( owner, SLOT(2) );
  store->local_fn_descrs = gvec_ref( owner, SLOT(3) );
  store->reloc_table = FALSE_OBJ;

  /* initialize our fake size class and generation */

  store->the_gen.heap = gc_arena;
  irc_init_pstore_gen( &store->the_gen );

#ifdef VERBOSE
  printf( "initializing pstore generation <%p>\n", &store->the_gen );
#endif

  store->the_size_class.gen = &store->the_gen;
  store->the_size_class.heap = gc_arena;

  /* install write-barrier hooks */

  {
    unsigned l, r;

    l = 0xF;
    for (r=0; r<14; r++)
      gc_arena->writeBarrierTable[l*16+r] = WB_PERSISTENT;
  }
      
  /* empty the lists of various VMPs */

  store->first_dirty = NULL;
  store->last_dirty = NULL;
  store->num_dirty = 0;
  store->first_loaded = NULL;
  store->first_reserved = NULL;

  htable_init( &store->vm_page_records );
  htable_init( &store->reserved_base_pages );

  a = lss_read_access( lss, CLIENT_INFO_RECNUM );

  if (!a)
    {
      /* no client info -- must be a new rstore */
      init_new( store );
    }
  else
    {
      struct RStoreCommitInfo ci;
      zipbuf v[2];

      v[0].ptr = &ci;
      v[0].limit = 1 + &ci;
      v[1].ptr = v[1].limit = NULL;

      lss_readv( lss, v, a );
      lss_read_release( lss, a );

      init_existing( store, &ci );
    }
    
  return store;
}

/* allocate some new storage... */

void install_new_vmpr( RStore *store, struct VMPageRecord *vmpr )
{
    vmpr->next_reserved = store->first_reserved;
    store->first_reserved = vmpr;

#ifdef VERBOSE
    printf( "new_vmpr(%p) : %p\n", vmpr, vmpr->mem_address );
#endif

    if (vmpr->ref.loaded)
      {
	vmpr->next_loaded = store->first_loaded;
	store->first_loaded = vmpr;
      }

    if (vmpr->ref.dirty)
      {
	if (store->first_dirty)
	  {
	    /* put this after the previously last dirty page */
	    store->last_dirty->next_dirty = vmpr;
	  }
	else
	  {
	    /* this is the first dirty page... */
	    store->first_dirty = vmpr;
	  }
	store->last_dirty = vmpr;
	vmpr->next_dirty = NULL;
	store->num_dirty++;
      }

    if (!vmpr->ref.indirect)
      htable_insert( &store->vm_page_records, vmpr->mem_address )->value = vmpr;
    if (vmpr->ref.first)
      htable_insert( &store->reserved_base_pages,
		    (void *)vmpr->ref.base_page_num )->value = vmpr;
}

/*
 *  remove a set of VMPageRecords (corresponding to a single "first" VMPR
 *  and all the subsequent ones) from all of the data structures that they
 *  are participating in, which includes (up to):
 *
 *     - the linked list of reserved (mapped) VMPRs
 *     - the linked list of loaded (in-core) VMPRs
 *     - the linked list of dirty (r/w) VMPRs
 *     - the hash table of all VMPRs (mapping page address => vmpr)
 *     - the hash table of reserved base pages (mapping pers. address => vmpr)
 */

static void uninstall_vmpr_set( RStore *store, struct VMPageRecord *first )
{
  struct VMPageRecord *i, *p;
  void *mem_start, *mem_limit;
  char *memi;
  unsigned n;

  mem_start = first->mem_address;
  mem_limit = (char*)mem_start + first->ref.nth_page * MM_PAGE_SIZE;

  /*
  printf( "uninstall vmpr set [%08x, %08x): ", 
          (unsigned long)mem_start,
          (unsigned long)mem_limit );
  fflush( stdout );
  */

  /*
   *  Remove them from the list of reserved pages
   */

  for (n=0, p=NULL, i=store->first_reserved; i; i=i->next_reserved) {
    if ((i->mem_address >= mem_start) && (i->mem_address < mem_limit)) {
      if (p) {
        p->next_reserved = i->next_reserved;
      } else {
        store->first_reserved = i->next_reserved;
      }
      n++;
    } else {
      p = i;
    }
  }
  /*printf( " (%u r", n );
    fflush( stdout );*/

  /*
   *  Remove them from the list of loaded pages
   */
  for (n=0, p=NULL, i=store->first_loaded; i; i=i->next_loaded) {
    if ((i->mem_address >= mem_start) && (i->mem_address < mem_limit)) {
      if (p) {
        p->next_loaded = i->next_loaded;
      } else {
        store->first_loaded = i->next_loaded;
      }
      n++;
    } else {
      p = i;
    }
  }
  /*printf( ", %u l", n );
    fflush( stdout );*/

  /*
   *  Remove them from the list of dirty pages
   */
  for (n=0, p=NULL, i=store->first_dirty; i; i=i->next_dirty) {
    if ((i->mem_address >= mem_start) && (i->mem_address < mem_limit)) {
      if (p) {
        p->next_dirty = i->next_dirty;
      } else {
        store->first_dirty = i->next_dirty;
      }
      store->num_dirty--;
      n++;
    } else {
      p = i;
    }
  }
  /*printf( ", %u d", n );*/
  if (p != store->last_dirty) {
    store->last_dirty = p;
    /*printf( " (L)" );*/
  }
  /*fflush( stdout );*/


  {
    void *entry;
    n = 0;
    entry = htable_remove( &store->reserved_base_pages, 
                           (void *)first->ref.base_page_num );
    if (entry) {
      n++;
    }
  }
  /*printf( ", %u rb", n );
    fflush( stdout );*/

  for (n=0, memi=mem_start; memi<(char*)mem_limit; memi += MM_PAGE_SIZE) {
    void *entry;
    entry = htable_remove( &store->vm_page_records, memi );
    assert( entry );
    assert( (n != 0) || (entry == first) );
    if (entry) {
      n++;
      free( entry );
    }
  }

  /*printf( ", %u h)\n", n );
    fflush( stdout );*/
}

void dealloc_ppages( RStore *store, 
                     struct VMPageRecord *first,
                     UINT_32 num_pages )
{
  mm_free( first->mem_address, num_pages * MM_PAGE_SIZE );
  uninstall_vmpr_set( store, first );
  /* by the time `uninstall_vmpr_set' returns, the VMPR is invalid
     because it has been freed */
  first = NULL;
}

struct VMPageRecord *alloc_ppages( RStore *store, UINT_32 num_pages )
{
  struct VMPageRecord *first, *vmpr;
  void *addr;
  unsigned i;
 
  UINT_32 base_page_num = 0;

  if (lss_alloc_recs( store->lss, 0x2000000, num_pages, &base_page_num ) < 0) {
    base_page_num = store->next_page;
    store->next_page += num_pages;
  }
 
  /* allocate the first */

  addr = mm_alloc( num_pages * MM_PAGE_SIZE, MM_MODE_READ_WRITE );

  first = vmpr = ALLOC( struct VMPageRecord );

  vmpr->ref.base_page_num = base_page_num;
  vmpr->ref.first = 1;
  vmpr->ref.indirect = 0;
  vmpr->ref.dirty = 1;
  vmpr->ref.loaded = 1;
  vmpr->ref.nth_page = num_pages;  /* for FIRST, is # pages */
  vmpr->mem_address = addr;

  /*printf( "-- allocated first page of %d at %p\n", 
    (int)num_pages, addr );*/

  install_new_vmpr( store, vmpr );
    
  /* allocate the rest */

  for (i=1; i<num_pages; i++) {
    vmpr = ALLOC( struct VMPageRecord );

    vmpr->ref.base_page_num = base_page_num;
    vmpr->ref.first = 0;
    vmpr->ref.indirect = 0;
    vmpr->ref.dirty = 1;
    vmpr->ref.loaded = 1;
    vmpr->ref.nth_page = i;
    addr = ((char *)addr) + MM_PAGE_SIZE;
    vmpr->mem_address = addr;
	
    install_new_vmpr( store, vmpr );
  }
  return first;
}

/* reserve a new page (or pages) */

static struct VMPageRecord *reservation( RStore *store, 
					 struct PageRef *pr, void *addr )
{
struct VMPageRecord *vmpr = ALLOC( struct VMPageRecord );

    vmpr->ref = *pr;
    vmpr->ref.dirty = 0;
    vmpr->ref.loaded = 0;
    
    vmpr->next_reserved = store->first_reserved;
    store->first_reserved = vmpr;

    vmpr->next_dirty = NULL;
    vmpr->next_loaded = NULL;

    vmpr->mem_address = addr;
    
    htable_insert( &store->vm_page_records, addr )->value = vmpr;
    if (pr->first)
      {
	htable_insert( &store->reserved_base_pages,
		       (void *)pr->base_page_num )->value = vmpr;
      }
    return vmpr;
}

struct VMPageRecord *reserve_multi_page( struct RStore *store, 
					 struct PageRef *pr )
{
  unsigned i, n;
  char *a;
  struct VMPageRecord *first;

  assert( pr->first ); /* only works if we encounter the 1st page! */

  n = pr->nth_page;
  a = (char *)mm_alloc( MM_PAGE_SIZE * n, MM_MODE_NO_ACCESS );

  first = reservation( store, pr, a );

  for (i=1; i<n; i++)
    {
      struct PageRef interior;

      interior.base_page_num = pr->base_page_num;
      interior.first = 0;
      interior.indirect = 0;
      interior.dirty = 0;
      interior.loaded = 0;
      interior.nth_page = i;

      a += MM_PAGE_SIZE;
      reservation( store, &interior, a );
    }
  return first;
}

struct VMPageRecord *reserve_single_page( struct RStore *store, 
					  struct PageRef *pr )
{
  return reservation( store, pr, mm_alloc( MM_PAGE_SIZE, MM_MODE_NO_ACCESS ) );
}

/* returns an existing vmpr, or reserves it */

struct VMPageRecord *get_vmpr( struct RStore *store, struct PageRef *pr )
{
struct htent *e;

    e = htable_lookup( &store->reserved_base_pages,
		       (void *)pr->base_page_num );
    if (e)
	return (struct VMPageRecord *)e->value;

    if (pr->indirect)
	return build_indirect_page( store, pr );
    else if (pr->first && pr->nth_page == 1)
	return reserve_single_page( store, pr );
    else
	return reserve_multi_page( store, pr );
}

static void free_vmpr( void *datum )
{
  struct VMPageRecord *vmpr = (struct VMPageRecord *)datum;

  if (!vmpr->ref.indirect)
    {
      if (vmpr->ref.first)
        {
          int n = vmpr->ref.nth_page;
#ifdef VERBOSE
          printf( "free_vmpr(%p) : %p (%d pages)\n", vmpr, vmpr->mem_address, n );
#endif
          mm_free( vmpr->mem_address, n * MM_PAGE_SIZE );
        }
      else
        {
#ifdef VERBOSE
          printf( "free_vmpr(%p) : %p (1 page)\n", vmpr, vmpr->mem_address );
#endif
          mm_free( vmpr->mem_address, MM_PAGE_SIZE );
        }
    }
  else
    {
#ifdef VERBOSE
      printf( "free_vmpr(%p) : %p (indirect)\n", vmpr, vmpr->mem_address );
#endif
    }
  free( vmpr );
}

static void free_rstore( struct RStore *store )
{
  struct VMPageRecord *j;

  lss_close( store->lss );

  /*
   *  go through and free up any VM storage
   */
  for (j=store->first_reserved; j;)
    {
      struct VMPageRecord *n = j->next_reserved;
      free_vmpr( j );
      j = n;
    }
  /*
   *  clean up htable storage
   */
  htable_free( &store->vm_page_records );
  htable_free( &store->reserved_base_pages );
  free( store );
}

#if INCLUDE_PSTORE_UNMAPPER
extern obj found_unmapped;
#endif

void rstore_close( struct RStore *store )
{
  int i;

#if !INCLUDE_PSTORE_UNMAPPER
  fprintf( stderr, "** WARNING ** rstore-close without PSTORE_UNMAPPER\n" );
#endif

  /*
   *  force a GC to make sure we don't try to examine
   *  a pointer into the storage we are now deallocating
   */
  gc_now();

  /*
   *  Mark this store as getting unmapped, and
   *  mark ``Generation 7'' as needing traversal
   *  work
   */
#ifdef VERBOSE
  printf( "unmapping generation <%p>\n", &store->the_gen );
#endif
#if INCLUDE_PSTORE_UNMAPPER
  found_unmapped = FALSE_OBJ;
  store->the_gen.unmapped = 1;
  gc_arena->theGenerations[0].traversalWork[14] = 1;
  gc_arena->theGenerations[0].traversalWork[15] = 1;
  gc_now();

  if (truish(found_unmapped))
    {
      store->the_gen.unmapped = 2;
      gc_arena->theGenerations[0].traversalWork[14] = 0;
      gc_arena->theGenerations[0].traversalWork[15] = 0;

      scheme_error( "unmapped pointers found", 1, found_unmapped );
    }
#endif

  assert( store->lss );
  for (i=0; i<num_rstores; i++)
    {
      if (rstores[i] == store)
        {
#ifdef VERBOSE
          printf( "rstore_close[%d] %p\n", i, store );
#endif
          irc_close_pstore_gen( &store->the_gen );
          memmove( &rstores[i], 
                   &rstores[i+1], 
                   sizeof( struct RStore * ) * (num_rstores - i - 1) );
          num_rstores--;
          free_rstore( store );
#ifdef VERBOSE
          printf( "rstore_closed[%d]\nGC Testing...", i );
          fflush( stdout );
          gc_now();  /* this should not fault */
          printf( "OK\n" );
#endif
          gc_arena->theGenerations[0].traversalWork[14] = 0;
          gc_arena->theGenerations[0].traversalWork[15] = 0;
          return;
        }
    }
  scheme_error( "abandoned rstore", 1, store->owner );
}

static obj attempt_to_flush_pages( struct RStore *store, obj root_obj )
{
  set_rstore_root( store, root_obj );
  return write_dirty_pages( store );
}

static obj do_commit( struct RStore *store, obj root )
{
  struct RStoreCommitInfo ci;
  UINT_32 key;

  memset( &ci, 0, sizeof ci );

  switch (store->using_rich_model)
    {
    case OLD_RICH_MODEL:
      strcpy( ci.tag, "TKG-RStore-1.0" );
      break;
    case LRU_RICH_MODEL:
      strcpy( ci.tag, "RStore-3.0" );
      break;
    }
  
  ci.next_page_num = store->next_page;
  ci.next_indirect_page = store->next_indirect_page;
  ci.default_area = create_LR_first( store,
				     DATAPTR_TO_PTR(store->default_area) );

  lss_write( store->lss, CLIENT_INFO_RECNUM, &ci, sizeof ci, NULL );
  key = lss_commit( store->lss, 0 );

  /* printf( "committed lss => %lu\n", key ); */

  return int_64_compact( int_32_to_int_64( key ) );
}

obj rstore_get_scheme_object( RStore *owner )
{
  return owner->owner;
}

void set_rstore_root( RStore *store, obj item )
{
  /* don't WRITE to the page unless it needs to be changed */
  if (!EQ( item, store->default_area->entry ))
    {
      gvec_set( DATAPTR_TO_PTR(store->default_area), SLOT(0), item );
    }
}

obj rstore_root( RStore *store )
{
  return store->default_area->entry;
}

/*
 *
 *  rstore_commit() -- attempt to commit the state of the persistent store
 *
 *  Returns either a list of unresolved objects if there are some objects
 *  that still need to be copied to the store; else returns a commit 
 *  identifier if the commit was successful.
 *
 *  If `live_tbl' is not #f, then it is an object hash table, and
 *  a persistent GC cycle is going to start with the state of this
 *  commit.  In which case, if we succeed in committing the store,
 *  we will fill the table with all the persistent objects referenced
 *  by the transient heap.
 */

obj rstore_commit( struct RStore *store, obj root, obj reloc, obj live_tbl )
{
  obj unresolved;

  store->reloc_table = reloc;
  unresolved = attempt_to_flush_pages( store, root );

  if (EQ( unresolved, NIL_OBJ ))
    {
      obj at = do_commit( store, root );

      hashtable_clear( reloc );

      store->reloc_table = FALSE_OBJ;
      if (truish( live_tbl )) {
        gc_now();
        rstore_get_live_objects( store, live_tbl );
      }
      return at;
    }
  store->reloc_table = FALSE_OBJ;
  return unresolved;
}

void dirty_page( RStore *store, struct VMPageRecord *vmp )
{
    assert( !vmp->ref.dirty );
    if (store->first_dirty)
      {
	store->last_dirty->next_dirty = vmp;
      }
    else
      {
	store->first_dirty = vmp;
      }
    store->last_dirty = vmp;
    store->num_dirty++;

    vmp->ref.dirty = 1;
    vmp->next_dirty = NULL;
    mm_set_prot( vmp->mem_address, MM_PAGE_SIZE, MM_MODE_READ_WRITE );
}

void *mmc_in_failure = NULL;

void mmc_access_failed( void *addr )
{
  struct VMPageRecord *vmp;
  RStore *store;
  char temp[12];

  /* we should never get a recursive fault */

  assert( !mmc_in_failure );
  mmc_in_failure = addr;

  /* look up the address */
  vmp = find_owner_and_vmpr( addr, &store );
#ifdef VERBOSE
  printf( "/ protection fault at: %p vmp={%p}\n", addr, vmp );
#endif
  
  if (vmp)
    {
      if (!vmp->ref.loaded)
	{
#ifdef VERBOSE
	  printf( "  load page %lu\n", vmp->ref.base_page_num );
#endif
	  /* load it in */
	  load_page( store, vmp );
	}
      else 
	{
#ifdef VERBOSE
	  printf( "  scribbling on page %lu\n", vmp->ref.base_page_num );
#endif
	  /* mark it dirty */
	  assert( !vmp->ref.dirty );
	  dirty_page( store, vmp );
	}
    }
  else
    {
#ifdef VERBOSE
      printf( "  could not find owner of %p\n", addr );
      abort();
#endif
      sprintf( temp, "%#lx", (unsigned long)addr );
      scheme_error( "access protection error at address ~a",
		   1, make_string(temp) );
    }
#ifdef VERBOSE
  printf( "\\ done with fault at %p\n", addr );
#endif
  mmc_in_failure = NULL;
}
 
struct VMPageRecord *find_owner_and_vmpr( void *addr, RStore **s )
{
  int i;
  struct VMPageRecord *vmp;

  for (i=0; i<num_rstores; i++)
    {
#ifdef VERBOSE
      printf( "(%d %p?) ", i, rstores[i] );
#endif
      vmp = addr_to_vm_page_record( rstores[i],
				    MM_PAGE_BASE_ADDR(addr) );
      if (vmp)
	{
	  *s = rstores[i];
	  return vmp;
	}
    }
  return NULL;
}
#undef VERBOSE


enum SwizzleMode mode_for_object( struct PHeapHdr *hdr )
{
  obj imode = gvec_read( hdr->rs_header.pob_class, SLOT(2) );
  enum SwizzleMode m;

  m = OBJ_ISA_FIXNUM(imode) ? fx2int(imode) : SWIZ_MODE_GVEC;
  switch (m)
    {
    case SWIZ_MODE_GVEC:
    case SWIZ_MODE_BVEC:
    case SWIZ_MODE_TEMPLATE:
    case SWIZ_MODE_UINT32:
    case SWIZ_MODE_FLOAT:
    case SWIZ_MODE_PADDR_VEC:
    case SWIZ_MODE_PART_DESCR:
    case SWIZ_MODE_ALLOC_AREA:
    case SWIZ_MODE_APP_0:
    case SWIZ_MODE_APP_1:
    case SWIZ_MODE_APP_2:
    case SWIZ_MODE_APP_3:
    case SWIZ_MODE_APP_4:
    case SWIZ_MODE_APP_5:
    case SWIZ_MODE_APP_6:
    case SWIZ_MODE_APP_7:
    case SWIZ_MODE_APP_8:
    case SWIZ_MODE_APP_9:
      return m;
    }
  scheme_error( "don't know how to swizzle ~s (image-mode ~s)",
	        2, PHH_TO_PTR(hdr), imode );
  return 0; /* hush up -Wall, since scheme_error() never returns */
}

void rstore_copy_gvec_proc( obj new_item, obj old_item )
{
  UINT_32 i, size = PTR_TO_HDRPTR(old_item)->pob_size;

  for (i=0; i<size; i+=SLOT(1))
    {
      gvec_write_init( new_item, i, gvec_ref( old_item, i ) );
    }
}

/* copy an object into the store */

obj rstore_copy_in( AllocArea *aa, obj item )
{
  PAllocArea *area;
  obj new_item;
  POBHeader *h;
  enum SwizzleMode m;

  /*  this is the only crude check we have right now for making
   *  sure this AllocArea is really a PAllocArea
   */
  assert( aa->info != NULL );

  area = (PAllocArea *)aa;

  if (!OBJ_ISA_PTR(item))
    {
      /* silently ignore requests to copy non-ptrs into the store */
      return item;
    }

  h = PTR_TO_HDRPTR(item);

  m = mode_for_object(PTR_TO_PHH(item));

  if (m != SWIZ_MODE_ALLOC_AREA)
    new_item = parea_alloc( (AllocArea *)area, h->pob_class, h->pob_size );
  else
    new_item = FALSE_OBJ;

  switch (m)
    {
    case SWIZ_MODE_BVEC:
    case SWIZ_MODE_UINT32:
    case SWIZ_MODE_FLOAT:
    case SWIZ_MODE_PADDR_VEC:
      memcpy( PTR_TO_DATAPTR(new_item), 
              PTR_TO_DATAPTR(item), 
              h->pob_size );
      break;
    case SWIZ_MODE_ALLOC_AREA:  /* quiet compiler */
      scheme_error( "Illegal copy: ~s", 1, item );
    case SWIZ_MODE_GVEC:
    case SWIZ_MODE_PART_DESCR:
    case SWIZ_MODE_TEMPLATE:
      rstore_copy_gvec_proc( new_item, item );
      break;
    default:
      {
	struct swiz_mode_handler *h = get_swiz_mode_handler( area->owner, m );
	h->copy_in( new_item, item );
      }
    }
  return new_item;
}


AllocArea *rstore_get_default_area( RStore *store )
{
  return (AllocArea *)store->default_area;
}

void rstore_set_default_area( RStore *store, AllocArea *area )
{
  struct PAllocArea *a = (struct PAllocArea *)area;

  /*  be nice to have a better way of checking that it is a PAllocArea, and
   *  in the right place, too...
   */
  assert( a->owner == store );
  store->default_area = a;
}

obj rstore_area_owner( AllocArea *area )
{
   if (area->info)
     return ((PAllocArea *)area)->owner->owner;
   else
     return FALSE_OBJ; /* not a PStore area */
}

AllocArea *rstore_alloc_area( obj item )
{
  if (OBJ_ISA_PTR( item ))
    {
      RStore *o;
      struct VMPageRecord *vmpr;
      struct PHeapHdr *p = PTR_TO_PHH(item);

      vmpr = find_owner_and_vmpr( p, &o );

      if (vmpr)
        {
          struct FirstPageHdr *fph = (struct FirstPageHdr *)vmpr->mem_address;
	  return (AllocArea *)fph->area;
        }
      else
        return (AllocArea *)PTR_TO_DATAPTR( default_alloc_area );
    }
  else
    return (AllocArea *)PTR_TO_DATAPTR( default_alloc_area );
}

int rstore_count_dirty( RStore *store )
{
  return store->num_dirty;
}

/* an AllocArea is a heap-allocated mixvec, so just plop
 * back in the PTR tags and we've got an OBJ
 */

obj alloc_area_to_obj( AllocArea *area )
{
  return OBJ( ((UINT_32)area) + POINTER_TAG );
}

void rstore_set_compression( struct RStore *store, const char *str )
{
  zip_algorithm *z;

  z = lss_find_zip_algorithm( str );
  if (z)
    {
      store->data_zipper = z;
    }
  else
    {
      scheme_error( "zip algorithm undefined: ~s", 1, make_string( str ) );
    }
}
