/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: rt_tool.cpp
 *              
 *      Abstract: General subfunction for ioctl talk to driver 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 03     Created
 *      MarkW           9th  Feb 04     Baseline of code
 ***************************************************************************/ 


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/wireless.h>

#include "rt_tool.h"


/*------------------------------------------------------------------*/
/*
 * Open a socket.
 * Depending on the protocol present, open the right socket. The socket
 * will allow us to talk to the driver.
 */
int Open_Socket(void)
{
	static const int families[] = {
		AF_INET, AF_IPX, AF_AX25, AF_APPLETALK
	};
	unsigned int	i;
	int		sock;

	/*
	* Now pick any (exisiting) useful socket family for generic queries
	* Note : don't open all the socket, only returns when one matches,
	* all protocols might not be valid.
	* Workaround by Jim Kaba <jkaba@sarnoff.com>
	* Note : in 99% of the case, we will just open the inet_sock.
	* The remaining 1% case are not fully correct...
	*/

	/* Try all families we support */
	for(i = 0; i < sizeof(families)/sizeof(int); ++i)
	{
		/* Try to open the socket, if success returns it */
		sock = socket(families[i], SOCK_DGRAM, 0);
		if(sock >= 0)
			return sock;
	}

	return -1;
}

int Check_DeviceName(int socket_id, char *DeviceName, char *DriverInfo)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);

	if(ioctl(socket_id, SIOCGIWNAME, &wrq) >= 0)
	{
		if(memcmp(wrq.u.name, DriverInfo, sizeof(DriverInfo)) == 0)
			return 1;
		else
			return 0;		
	}
	else
		return 0;
}

char *Get_DeviceName(int socket_id, char *DeviceName)
{
	struct iwreq wrq;
	
	strcpy(wrq.ifr_name, DeviceName);

	if(ioctl(socket_id, SIOCGIWNAME, &wrq) < 0)
		return NULL;
	else
		return wrq.u.name;
}

NDIS_MEDIA_STATE  Get_Media_State(int socket_id, char *DeviceName)
{
	struct iwreq wrq;		
	NDIS_MEDIA_STATE ConnectStatus;	
	
	strcpy(wrq.ifr_name, DeviceName);			
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) &ConnectStatus;
	wrq.u.data.flags = RTLINUX_GET_MEDIA_CONNECT_STATUS;	
	ioctl(socket_id, SIOCDEVPRIVATE, &wrq);	
	
	return ConnectStatus;
}

int Get_NDIS_802_11_CONFIGURATION(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_CONFIGURATION;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_BSSID(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_BSSID;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}	

int Get_OID_802_11_AUTHENTICATION_MODE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_AUTHENTICATION_MODE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_BSSID_LIST(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_BSSID_LIST;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_DESIRED_RATES(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_DESIRED_RATES;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_FRAGMENTATION_THRESHOLD(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_FRAGMENTATION_THRESHOLD;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_INFRASTRUCTURE_MODE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_INFRASTRUCTURE_MODE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_POWER_MODE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_POWER_MODE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_QUERY_PREAMBLE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_QUERY_PREAMBLE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_RSSI(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_RSSI;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_RTS_THRESHOLD(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_RTS_THRESHOLD;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_RX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_RX_ANTENNA_SELECTED;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_SSID(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;	

	strcpy(wrq.ifr_name, DeviceName);			
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_SSID;	

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_STATISTICS(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_STATISTICS;
	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_TX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_TX_ANTENNA_SELECTED;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_TX_POWER_LEVEL(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_TX_POWER_LEVEL;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_11_WEP_STATUS(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_11_WEP_STATUS;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_802_3_CURRENT_ADDRESS(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_802_3_CURRENT_ADDRESS;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_GEN_RCV_NO_BUFFER(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_GEN_RCV_NO_BUFFER;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_OID_GEN_RCV_OK(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_OID_GEN_RCV_OK;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_RT_OID_802_11_QUERY_HARDWARE_REGISTER(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(RT_802_11_HARDWARE_REGISTER);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_RT_OID_802_11_QUERY_HARDWARE_REGISTER;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_RT_OID_802_11_QUERY_LINK_STATUS(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_RT_OID_802_11_QUERY_LINK_STATUS;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Get_VERSION_INFO(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_VERSION_INFO;							 
	
	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_ADD_WEP(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;
	PNDIS_802_11_WEP  pWEPKey;

	pWEPKey = (PNDIS_802_11_WEP) ptr;
	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = pWEPKey->Length;	
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_ADD_WEP;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_AUTHENTICATION_MODE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_AUTHENTICATION_MODE);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_AUTHENTICATION_MODE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_BSSID(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_MAC_ADDRESS);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_BSSID;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_BSSID_LIST_SCAN(int socket_id, char *DeviceName)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;	
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_BSSID_LIST_SCAN;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_CONFIGURATION(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_CONFIGURATION);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_CONFIGURATION;
	
	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_DESIRED_RATES(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_RATES);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_DESIRED_RATES;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_FRAGMENTATION_THRESHOLD(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_FRAGMENTATION_THRESHOLD);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_FRAGMENTATION_THRESHOLD;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_INFRASTRUCTURE_MODE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;
	
	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_NETWORK_INFRASTRUCTURE);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_INFRASTRUCTURE_MODE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_POWER_MODE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_POWER_MODE);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_POWER_MODE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_REMOVE_WEP(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(ULONG);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_REMOVE_WEP;
	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_RESET_COUNTERS(int socket_id, char *DeviceName)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) 0;
	wrq.u.data.flags = RTLINUX_SET_RT_OID_802_11_RESET_COUNTERS;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_RTS_THRESHOLD(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_RTS_THRESHOLD);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_RTS_THRESHOLD;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_RX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_ANTENNA);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_RX_ANTENNA_SELECTED;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_SET_PREAMBLE(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(RT_802_11_PREAMBLE);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_SET_PREAMBLE;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_SSID(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_SSID);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_SSID;
	
	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}	

int Set_OID_802_11_TX_ANTENNA_SELECTED(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_ANTENNA);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_TX_ANTENNA_SELECTED;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_TX_POWER_LEVEL(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_TX_POWER_LEVEL);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_TX_POWER_LEVEL;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_WEP_STATUS(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(NDIS_802_11_WEP_STATUS);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_OID_802_11_WEP_STATUS;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_RT_OID_802_11_SET_HARDWARE_REGISTER(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(RT_802_11_HARDWARE_REGISTER);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_RT_OID_802_11_SET_HARDWARE_REGISTER;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_RT_OID_802_11_SET_RADIO(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(bool);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_SET_RT_OID_802_11_SET_RADIO;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int GET_RT_OID_802_11_QUERY_RADIO(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = 0;
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_GET_RT_OID_802_11_QUERY_RADIO;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

int Set_OID_802_11_SET_COUNTRY_REGION(int socket_id, char *DeviceName, void *ptr)
{
	struct iwreq wrq;

	strcpy(wrq.ifr_name, DeviceName);
	wrq.u.data.length = sizeof(char);
	wrq.u.data.pointer = (caddr_t) ptr;
	wrq.u.data.flags = RTLINUX_RT_OID_802_11_SET_COUNTRY_REGION;

	return (ioctl(socket_id, SIOCDEVPRIVATE, &wrq));
}

//
//  FUNCTION: AtoH(char *, UCHAR *, int)
//
//  PURPOSE:  Converts ascii string to network order hex
//
//  PARAMETERS:
//    src    - pointer to input ascii string
//    dest   - pointer to output hex
//    destlen - size of dest
//
//  COMMENTS:
//
//    2 ascii bytes make a hex byte so must put 1st ascii byte of pair
//    into upper nibble and 2nd ascii byte of pair into lower nibble.
//

void AtoH(char * src, UCHAR * dest, int destlen)
{
    char * srcptr;

    srcptr = src;
	PUCHAR destTemp = dest; 

    while(destlen--)
    {
		*destTemp = BtoH(*srcptr++) << 4;    // Put 1st ascii byte in upper nibble.
		*destTemp += BtoH(*srcptr++);      // Add 2nd ascii byte to above.
		destTemp++;
    }
}

//
//  FUNCTION: BtoH(char *, char *, int)
//
//  PURPOSE:  Converts ascii byte to numeric
//
//  PARAMETERS:
//    ch - ascii byte to convert
//
//  RETURNS:
//    associated numeric value
//
//  COMMENTS:
//
//    Will convert any hex ascii digit to its numeric counterpart.
//    Puts in 0xff if not a valid hex digit.
//

UCHAR BtoH(char ch)
{
    if (ch >= '0' && ch <= '9') return (ch - '0');        // Handle numerals
    if (ch >= 'A' && ch <= 'F') return (ch - 'A' + 0xA);  // Handle capitol hex digits
    if (ch >= 'a' && ch <= 'f') return (ch - 'a' + 0xA);  // Handle small hex digits
    return(255);
}
