require 'test/unit'
require File.dirname(__FILE__) + '/../lib/colorize'

class TestColorize < Test::Unit::TestCase
  def test_blue_symbol
    assert_equal 'This is blue'.colorize(:blue),
                 "\e[0;34;49mThis is blue\e[0m"
  end

  def test_incorrect_symbol
    assert_equal 'This is incorrect color'.colorize(:bold),
                 "\e[0;39;49mThis is incorrect color\e[0m"
  end

  def test_incorrect_hash
    assert_equal 'This is incorrect color'.colorize(:color => :bold),
                 "\e[0;39;49mThis is incorrect color\e[0m"

    assert_equal 'This is incorrect color'.colorize(:mode => :green),
                 "\e[0;39;49mThis is incorrect color\e[0m"

    assert_equal 'This is incorrect color'.colorize(:background => :bold),
                 "\e[0;39;49mThis is incorrect color\e[0m"
  end

  def test_blue_hash
    assert_equal 'This is also blue'.colorize(:color => :blue),
                 "\e[0;34;49mThis is also blue\e[0m"
  end

  def test_light_blue_symbol
    assert_equal 'This is light blue'.colorize(:light_blue),
                 "\e[0;94;49mThis is light blue\e[0m"
  end

  def test_light_blue_with_red_background_hash
    assert_equal 'This is light blue with red background'.colorize(:color => :light_blue, :background => :red),
                 "\e[0;94;41mThis is light blue with red background\e[0m"
  end

  def test_light_blue_with_red_background_symbol_and_hash
    assert_equal 'This is light blue with red background'.colorize(:light_blue).colorize(:background => :red),
                 "\e[0;94;41mThis is light blue with red background\e[0m"
  end

  def test_blue_with_red_background_method
    assert_equal 'This is blue text on red'.blue.on_red,
                 "\e[0;34;41mThis is blue text on red\e[0m"
  end

  def test_red_with_blue_background_symbol_and_method
    assert_equal 'This is red on blue'.colorize(:red).on_blue,
                 "\e[0;31;44mThis is red on blue\e[0m"
  end

  def test_red_with_blue_background_and_underline_sumbol_and_methods
    assert_equal 'This is red on blue and underline'.colorize(:red).on_blue.underline,
                 "\e[4;31;44mThis is red on blue and underline\e[0m"
  end

  def test_blue_with_red_background_and_blink_methods
    assert_equal 'This is blue text on red'.blue.on_red.blink,
                 "\e[5;34;41mThis is blue text on red\e[0m"
  end

  def test_uncolorize
    assert_equal 'This is uncolorized'.blue.on_red.uncolorize,
                 "This is uncolorized"
  end

  def test_colorized?
    assert_equal 'Red'.red.colorized?, true
    assert_equal 'Blue'.colorized?, false
    assert_equal 'Green'.blue.green.uncolorize.colorized?, false
  end

  def test_concatenated_strings_on_green
    assert_equal ('none' + 'red'.red + 'none' + 'blue'.blue + 'none').on_green,
                 "\e[0;39;42mnone\e[0m\e[0;31;42mred\e[0m\e[0;39;42mnone\e[0m\e[0;34;42mblue\e[0m\e[0;39;42mnone\e[0m"
  end

  def test_concatenated_strings_uncolorize
    assert_equal ('none' + 'red'.red + 'none' + 'blue'.blue + 'none').uncolorize,
                 "nonerednonebluenone"
  end

  def test_frozen_strings
    assert_equal 'This is blue text on red'.freeze.blue.on_red.blink,
                 "\e[5;34;41mThis is blue text on red\e[0m"
  end
  
  def test_new_line
    assert_equal "This is blue\ntext on red".freeze.blue.on_red.blink,
                 "\e[5;34;41mThis is blue\ntext on red\e[0m"
  end
end
