module Fog
  module Storage
    class GoogleXML
      class Real
        # Get torrent for an Google Storage object
        #
        # ==== Parameters
        # * bucket_name<~String> - name of bucket containing object
        # * object_name<~String> - name of object to get torrent for
        #
        # ==== Returns
        # * response<~Excon::Response>:
        #   * body<~Hash>:
        #     * 'AccessControlPolicy'<~Hash>
        #       * 'Owner'<~Hash>:
        #         * 'DisplayName'<~String> - Display name of object owner
        #         * 'ID'<~String> - Id of object owner
        #       * 'AccessControlList'<~Array>:
        #         * 'Grant'<~Hash>:
        #           * 'Grantee'<~Hash>:
        #             * 'DisplayName'<~String> - Display name of grantee
        #             * 'ID'<~String> - Id of grantee
        #           * 'Permission'<~String> - Permission, in [FULL_CONTROL, WRITE, WRITE_ACP, READ, READ_ACP]
        #
        def get_object_torrent(bucket_name, object_name)
          raise ArgumentError.new("bucket_name is required") unless bucket_name
          raise ArgumentError.new("object_name is required") unless object_name
          request(:expects    => 200,
                  :headers    => {},
                  :host       => "#{bucket_name}.#{@host}",
                  :idempotent => true,
                  :method     => "GET",
                  :path       => Fog::Google.escape(object_name),
                  :query      => { "torrent" => nil })
        end
      end
    end
  end
end
