require 'runit/testcase'

class TestArray < RUNIT::TestCase
  def setup
    @empty = Array.new
    @full = Array.new
    @full.push 1
    @full.push 2
    @full.push 3
  end

  def test_capacity
    size = @full.size
    for i in 1..100 
      @full.push i
    end
    assert(@full.size == 100 + size)
  end

  def test_dup
    array_dup = @full.dup
    assert(array_dup.size == @full.size)
    assert(array_dup.include?(2))
  end

  def test_include
    assert(@full.include?(1))
    assert(!@empty.include?(1))
  end
    
  def test_at
    assert(@full[0] == 1)
  end

  def test_clear
    @full.clear
    @empty.clear
    assert(@full.empty?)
    assert(@empty.empty?)
  end

  def test_delete
    @full.delete(3)
    assert(!@full.include?(3))
  end
  
end
