#include <rumba/baseManifold.h>
#include <rumba/manifoldFile.h>
#include <rumba/arghandler.h>
#include <rumba/util.hpp>
#include <rumba/parse.h>
#include <rumba/matrixio.h>
#include <iostream>
#include <cstdlib>

using std::cerr;
using std::endl;

using RUMBA::Argument;

Argument myArgs [] = {
	Argument ( "bigendian", RUMBA::FLAG, 'b' ),
	Argument()
};

void help_message()
{	
	cerr << "Usage: babelfish [-i|--infile] infile [-o|--outfile] outfile  [--be|--le]" << endl;
}

int main(int argc, char** argv)
{
	RUMBA::ArgHandler::setRequiredDefaultArg("infile");
	RUMBA::ArgHandler::setRequiredDefaultArg("outfile");
	bool be;
	bool help;
	try 
	{
		RUMBA::ArgHandler argh(argc,argv,myArgs);
		std::string infile, outfile;
		argh.arg("infile", infile );
		argh.arg("outfile", outfile );
		be = argh.arg("bigendian");
		help = argh.arg ("help");

		if ( help )
		{
			help_message();
			exit(0);
		}



		if ( RUMBA::fileExtension ( infile ) == ".txt" )
		{
			RUMBA::Manifold<double> X (RUMBA::loadAsciiManifold(infile.c_str()));
			X.save(outfile.c_str());
			return 0;
		}
		
	
		RUMBA::ManifoldFile* inManifold;
		RUMBA::BaseManifold* transferManifold;
		RUMBA::ManifoldFile* outManifold;

		inManifold= RUMBA::ManifoldFile::construct(infile.c_str());
		if (!inManifold)
		{
			cerr << "Fatal: can't identify file type" << endl;
			exit (1);
		}

		outManifold = RUMBA::ManifoldFile::construct ( outfile, std::ios::out, inManifold );

		if (!outManifold)
		{
			cerr << "Fatal: can't open output file" << std::endl;
			delete inManifold;
			exit(1);
		}

		if (be)
			outManifold->setLittleEndian(false);
		else	
			outManifold->setLittleEndian(true);



		for ( int i = 0; i < inManifold->timepoints(); ++i )
		{
			transferManifold = inManifold->get 
				( 
					RUMBA::intPoint(0,0,0,i),
					RUMBA::intPoint(inManifold->width(),inManifold->height(),inManifold->depth(),1)
				);
			outManifold->put ( transferManifold, RUMBA::intPoint(0,0,0,i));

			delete transferManifold;
		}

		delete inManifold;
		delete outManifold;

	}

    catch (RUMBA::MissingArgumentException& s)
    {
		cerr << "Error, missing required argument: " << s.error() << endl;
		help_message();
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cerr << "Duplicate argument: " << s.error() << endl;
		help_message();
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cerr << "Error: " << s.error() << endl;
		help_message();
	}
	catch ( RUMBA::Exception & e)
	{
		cerr << "Fatal exception " << e.error() << endl;	
	}

	return 0;
}
