#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/loadVols.h>

using namespace std;
using namespace RUMBA;


Argument myArgs[] =
{
	Argument("sort",RUMBA::ALPHA,0,"numeric"),
	Argument()
};
void help_message()
{
	cerr << "Usage: manifoldcat [-h | -i infile1 infile2 infile3 ... -o outfile --sort [none|alpha|numeric|origin]]" << endl;
}
int main(int argc, char** argv)
{

	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");

	ArgHandler::setMultiDefaultArg("infile");
	vector<Splodge> v;	
	vector<string> w;
	string outfile;
	string sortMethod;
	void (*theSortFunction)(vector<string> & );

	try {
		ArgHandler argh(argc,argv,myArgs);
		if (argh.arg("help"))
		{
			help_message();
			exit(0);
		}

		argh.arg("outfile",outfile);
		argh.arg("sort",sortMethod);
		v =  argh.multiarg("infile");


		if ( sortMethod == "none" )
			theSortFunction = doNothing;
		else if ( sortMethod == "alpha" )
			theSortFunction = sortFilesByName;
		else if ( sortMethod == "numeric" )
			theSortFunction = sortFilesByNumber;
		else if ( sortMethod == "origin" )
			theSortFunction = sortFilesByOrigin;
		else
		{
			cerr << "Warning: bad sort method " << sortMethod <<endl;
			cerr << "Valid choices are none, alpha, origin, numeric" << endl;
			cerr << "Using numeric " << endl;
			theSortFunction = doNothing;
		}
		
		for (vector<Splodge>::const_iterator it = v.begin(); it!=v.end();++it)
			w.push_back(it->asString());

		loadVols(w,outfile.c_str(),theSortFunction);

	}
    catch (RUMBA::MissingArgumentException& s)
    {
		cerr << "Error, missing required argument: " << s.error() << endl;
		help_message();
	}	
	catch ( RUMBA::InvalidArgumentException& s)
	{
		cerr << "Invalid argument: " << s.error() << endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cerr << "Duplicate argument: " << s.error() << endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cerr << "Error: " << s.error() << endl;
	}
	catch (RUMBA::Exception& s)
	{
		cerr << "Exception: " << s.error() << endl;
	}

	return 0;
}


