
template <class TYPE>
void RUMBA::Manifold<TYPE>::loadBrikHeader ( string filename )
{
	string tagname;
	string tmp;
	string type;
	string name;

	string stringData;
	float* floatData;
	int* intData;

	int count = 0;

	ifstream f ( filename.c_str() );

	while (f >> tmp)
	{
		if ( tmp != "type" ) cerr << "Bad data: word 'type' expected, instead I got" << tmp << " \n";
		f >> tmp;
		if ( tmp != "=" )  cerr << "Bad data: = expected\n"; 
		f >> type;

		f >> tmp;
		if ( tmp != "name" ) cerr << "Bad data: word 'name' expected\n";
		f >> tmp;
		if ( tmp != "=" )  cerr << "Bad data: = expected\n"; 
		f >> name;

		f >> tmp;
		if ( tmp != "count" ) cerr << "Bad data: word 'count' expected\n";
		f >> tmp;
		if ( tmp != "=" )  cerr << "Bad data: = expected\n"; 
		f >> count;



		if ( type == "string-attribute" ) 
		{ 
			stringData = getBrikString ( f, count );	
			processBrikData ( name, stringData );
		}

		if ( type == "integer-attribute" ) {
			intData = new int[ count ];
			for ( int i=0;i<count;++i ) f >> intData[i];	
			processBrikData ( name, intData, count );
			delete [] intData;
		}
		if ( type == "float-attribute" ) {
			floatData = new float[ count ];
			for ( int i=0;i<count;++i ) f >> floatData[i];	
			processBrikData ( name, floatData, count );
			delete [] floatData;
		}

	}	/* Done reading file */

	
}



string RUMBA::BrikFile::getBrikString ( ifstream& f, int count )
{
	count--;
	string s = "";
	char c;
	for ( ; f.get() != '\'' ; );	

	
	for ( ; c != '~'; c = f.get() )
	{		
		s += c;
		cerr << s << endl;
		count--;
	}
	for ( ; count >=0; count-- ) f.get();

	/*	For some reason, I get a leading ^H. Dunno why.	*/
	s.assign ( s,1 );	
	cerr << "***" << s << "***" << endl;
	return s;
}

void RUMBA::BrikFile::processBrikData ( string name, string s )
{

	if ( name == "BYTEORDER_STRING" ) {
		if ( s == "MSB_FIRST" ) {
			LittleEndian = false;
		} else if ( s == "LSB_FIRST" ) {
			LittleEndian = true;
		} else {
			cerr << "Unsupported BYTEORDER_STRING:::" << s << ":::" << endl;
		}
	}



}

void RUMBA::BrikFile::processBrikData ( string name, int* x, int length )
{
	int i;

	if ( name == "DATASET_DIMENSIONS" ) {
		Width = x[0];
		if ( length >=2 ) Height = x[1];
		if ( length >=3 ) Depth = x[2];
		if ( length >=4 && x[3] != 0 ) TimePoints = x[3];
	cerr << "DATASET_DIMENSIONS : " << Width << " : " << Height << " : " << Depth << " : " << TimePoints << endl;
	}

	if ( name == "BRICK_TYPES" ) 
	{
		switch ( x[0] ) {
			case 0:	fileDataType = TYPE_CHAR; 	break;
			case 1: fileDataType = TYPE_SHORT; 	break;
			case 2: fileDataType = TYPE_INT; 	break;	
			case 3: fileDataType = TYPE_FLOAT; 	break;
			case 4: fileDataType = TYPE_DOUBLE; 	break;
			default: cerr << "Unsupported datatype: " << x[0] << endl;
		}
		TimePoints = length;
		cerr << "In Manifold::processBrikData: datatype is " << fileDataType << endl;	

		/*	Check to see that datatypes are consistent 	*/
		for ( i = 0; i < length; ++i ) 
			if ( x[i] != x[0] ) 
				cerr << "Manifold class does not support different data types within the one manifold\n";
	}
}

void RUMBA::BrikFile::processBrikData ( string name, float* x, int length )
{
	if ( name == "DELTA" ) {
		DimX = ( x[0] > 0 ) ? x[0] : - x[0];
		if ( length >=2 ) DimY = ( x[1] > 0 ) ? x[1] : - x[1];
		if ( length >=3 ) DimZ = ( x[2] > 0 ) ? x[2] : - x[2];
	}


}




