#ifndef RUMBA_ANALYZE_FILE_H
#define RUMBA_ANALYZE_FILE_H

#include <rumba/exemplar.h>
#include <header_request.h>
#include <manifoldFile.h>
#include <string>
#include <list>



namespace RUMBA
{



class AnalyzeFile : public ManifoldFile 
{

public:
	AnalyzeFile();
	AnalyzeFile(Exemplar);
	ManifoldFile* make( std::string s, int mode, const BaseManifold*);
	virtual bool isMine(std::string s);
	void saveHeader(const char* filename);
	void loadHeader(const char* filename);

	void initFile ( int mode);


private:

	void endian_hack(const char* filename, std::ifstream& in);
	void copyHeaderDataToManifold();
	void copyHeaderDataFromManifold();

	void loadCsv();
	void loadRc();
	Factory* getFactoryFromDataType(std::string );
	void fillRequiredHeaders();


	std::list<RUMBA::header_request> HeaderRequests;

	std::string data_extension;
	std::string header_extension;
	std::string header_size;

	std::string classname;
	std::map<std::string, std::string> types;
};

	extern AnalyzeFile AnalyzeFileInstance;
	extern AnalyzeFile* AnalyzeFileExemplar;



}//namespace RUMBA


#endif
