#ifndef RUMBA_BINARY_HEADER_H
#define RUMBA_BINARY_HEADER_H


/**
  * \file binary_header.h
  * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
  * Copyright Ben Bly
  * This file is released under the artistic license. See the file
  * COPYING for details.
  *
  *	General routines for processing headers with fixed length fields
*/





#include <map>
#include <string>
#include <list>
#include <iosfwd>
#include <rumba/constants.h>
#include <rumba/header_request.h>
#include <rumba/splodge.h>

namespace RUMBA {

std::map<std::string, RUMBA::Splodge>
getData ( const std::list<header_request>&  , std::ifstream& Stream, bool le);

RUMBA::Splodge 
	RUMBA::getDataHelper ( int t, std::ifstream& stream, bool le, int bytes);

void putData 
( 
	const std::map<std::string, RUMBA::Splodge>& data,
	const std::list<header_request>& , 
	std::ofstream& Stream, 
	bool le = 1 
);

}

#endif
