#include <rumba/iohandler.h>

namespace RUMBA
{

class SiemensIOHandler : public IOHandler<short>
{
public:
	SiemensIOHandler ( const char* filename, int Width, int Height, int Depth, int nTilesWide, int SliceOrder,
			std::ios_base::openmode mode )
		:
		IOHandlerBase(filename,mode),
		nTilesWide(nTilesWide),
		Width(Width), Height(Height), Depth(Depth), 
		 SliceOrder(SliceOrder)
		{
			log.logName() << "Tiles wide: " << nTilesWide << "\n";
			if ( mode & std::ios::out )
			{
				Stream.seekp( 2 * Width * Height * (nTilesWide*nTilesWide) + 6144 -1, std::ios::beg );
				Stream.put(0);
			}
		}


	virtual void seekg ( int x, std::ios::seekdir = std::ios::beg );
	virtual void seekp ( int x, std::ios::seekdir = std::ios::beg );

private:
	int getTopLeft(int image);
	int getTopRight(int image);
	int getBottomLeft(int image);
	int getBottomRight(int image);
	char find_orientation(char top, char back);
	int flatToMosaic (int n);
	int curpos ( int topLeft, int x, int y );
	int mosaicX(int,int);
	int mosaicY(int,int);
	
	int nTilesWide;
	int Width,Height,Depth;

	int SliceOrder;

};

}
