#ifndef RUMBA_FILEIO_H
#define RUMBA_FILEIO_H



#include <fstream>
using std::ifstream;
using std::ofstream;
using std::istream;
using std::ostream;

namespace RUMBA {


/**
  * \file fileIO.h
  * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
  * Copyright Ben Bly
  * This file is released under the artistic license. See the file
  * COPYING for details.
  *
  * These functions allow the source and destination to have the
  *   same address, but other overlap may be problematic (because
  *   implementations using memcpy() are permissible). If the source
  *   and destination are the same and no byteswap is required, the
  *   functions do nothing. 
  *   
  *   If byteswap is required, they work as expected (though no overlap
  *   is allowed barring exact equality).
  *
  *   If the addresses are different and byteswap isn't required, memcpy()
  *   is used.
*/

	void iGet( char* dest, const char* buf, int nelts, bool le );
	void iGet( short* dest, const char* buf, int nelts, bool le );
	void iGet( int* dest, const char* buf, int nelts, bool le );
	void iGet( float* dest, const char* buf, int nelts, bool le );
	void iGet( double* dest, const char* buf, int nelts, bool le );

	void iPut( char* dest, const char* src, int nelts, bool le );
	void iPut( char* dest, const short* src, int nelts, bool le );
	void iPut( char* dest, const int* src, int nelts, bool le );

	void iPut( char* dest, const float* src, int nelts, bool le );
	void iPut( char* dest, const double* src, int nelts, bool le );



	inline char getChar(istream& file, bool){ return file.get(); }
	inline short getShort(istream& file, bool le){ 
		short x;
		char buf[2];
		file.read(buf,2);
		iGet(&x,buf,1,le);
		return x;
	}
	inline int getInt(istream& file, bool le){
		int x;
		char buf[4];
		file.read(buf,4);
		iGet(&x,buf,1,le);
		return x;
	}
	inline float getFloat(istream& file, bool le){
		float x;
		char buf[4];
		file.read(buf,4);
		iGet(&x,buf,1,le);
		return x;
	}
	inline double getDouble(istream& file, bool le){
		double x;
		char buf[8];
		file.read(buf,8);
		iGet(&x,buf,1,le);
		return x;
	}


	inline void putChar(ostream& file, char x ){ file.put(x); }
	inline void putShort(ostream& file, short x, bool le){ 
		char buf[2];
		iPut(buf,&x,1,le);
		file.write(buf,2);
	}
	inline void putInt(ostream& file, int x, bool le){
		char buf[4];
		iPut(buf,&x,1,le);
		file.write(buf,4);
	}
	
	inline void putFloat(ostream& file, float x, bool le){
		char buf[4];
		iPut(buf,&x,1,le);
		file.write(buf,4);
	}
 	inline void putDouble(ostream& file, double x, bool le){
		char buf[8];
		iPut(buf,&x,1,le);
		file.write(buf,8);
	}
//
//

} /* namespace RUMBA */

#endif
