/*
	Minc support functions. This code interfaces with a C API, so it's a
	bit of an odd mix between C and C++. I've kept it here to avoid polluting
	other code with this.

*/


#ifndef MINCHELPER_H
#define MINCHELPER_H


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <minc.h>
#include <string>
#include <vector>
#include <map>

using std::map;
using std::string;

namespace RUMBA {

// forward declaration
class Splodge;

struct netcdfDescriptor 
{
	int cdf;						/* NetCDF File descriptor */
	int image;						/* Image handle */
	int dim [ MAX_VAR_DIMS ];		/* Dimension handle */
	int space [ MAX_VAR_DIMS ];		/* Space variables */
	int patient; 					/* Patient variable */
};

struct netcdfAttr 
{
	double stepX; 
	double stepY; 
	double stepZ;
	double startX;
	double startY;
	double startZ;
	double cosinesX[3];
	double cosinesY[3];
	double cosinesZ[3];
	int nDims;
	char* spacing;
};



struct Patient 
{

	Patient() : 
		fullname(""), other_names(""), identification(""), other_ids(""),
		birthdate(""), sex(""), address(""), insurance_id(""),
		weight(0), size(0) 
	{ }
	std::string 
		fullname, 
		other_names, 
		identification, 
		other_ids, 
		birthdate, 
		sex, // MI_MALE, MI_FEMALE, MI_OTHER
		address, 
		insurance_id;
	double
		weight, // in kg
		size; // height in meters
		

};

struct Study 
{
	Study () :
		manufacturer(""),
		device_model(""),
		institution(""),
		department(""),
		station_id(""),
		reffering_physician(""),
		attending_physician(""),
		radiologist(""),
		op(""),	
		admitting_diagnosis(""),
		proceedure(""),
		study_id(""),
		start_year(0), 
		start_month (0), 
		start_day (0), 
		start_hour (0), 
		start_minute (0), 
		start_seconds (0)
{}

	std::string manufacturer,	// device manufacturer
	device_model,
	institution,
	department,
	station_id,
	reffering_physician,
	attending_physician,
	radiologist,
	op,	// machine operator
	admitting_diagnosis,
	proceedure,
	study_id;
	int start_year, start_month, start_day, start_hour, start_minute;
	float start_seconds;
};

struct Acquisition 
{
	Acquisition () :
		protocol(""),
		scanning_sequence(""),
		imaged_nucleus(""),
		radionuclide(""),
		contrast_agent(""),
		tracer(""),
		injection_time(""),
		dose_units(""),
		injection_route(""),
		repitition_time(0), 
		echo_time(0), 
		inversion_time(0), 
		imaging_frequency(0), 
		radionuclide_halflife(0), 
		injection_seconds(0), 
		injection_length(0), 
		injection_dose(0), 
		injection_volume(0),
		num_averages(0), 
		injection_year(0), 
		injection_month(0), 
		injection_hour(0), 
		injection_minute(0) 
	{}


	std::string
		protocol,
		scanning_sequence,
		imaged_nucleus,
		radionuclide,
		contrast_agent,
		tracer,
		injection_time,
		dose_units,
		injection_route;
	double
		repitition_time,
		echo_time,
		inversion_time,
		imaging_frequency,
		radionuclide_halflife,
		injection_seconds,
		injection_length,
		injection_dose,
		injection_volume;

	int
		num_averages,
		injection_year,
		injection_month,
		injection_hour,
		injection_minute;
};

void mincSize ( struct netcdfDescriptor, long*  );
void mincInitDescriptor ( struct netcdfDescriptor* );
nc_type mincGetDataType ( struct netcdfDescriptor D );

vector<double> mincGetAttDouble ( int cdfid, int varid, string attname  ) ;
double mincGetAttDouble1 ( int cdfid, int varid, string attname ) ;

vector<int> mincGetAttInt ( int cdfid, int varid, string attname ) ;
int mincGetAttInt1 ( int cdfid, int varid, string attname ) ;


string mincGetAttString ( int cdfid, int varid, string attname ) ;

Splodge mincGetAtt1 ( int cdfid, int varid, string attname ) ;

map<string, Splodge, less<string> > loadAtts ( int mincid, int varid );

} // namespace RUMBA

#endif
