#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: covariance-matrix -i infile  -o outfile\n";
}

int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");
	std::string infile, outfile;

	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg( "infile",infile );
		argh.arg ("outfile", outfile);
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}



	try 
	{
		ManifoldMatrix in = manifoldMatrixReadHack( infile );
		ManifoldMatrix product =  in.transpose() * in;
		manifoldMatrixWriteHack( product , outfile.c_str() );
	}
	catch ( RUMBA::Exception& e )
	{
		std::cerr << "Fatal Exception: " << e.error() << std::endl;
	}
}
