#include <iostream>
#include <vector>
#include <list>
#include <algorithm>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrixio.h>
#include <rumba/matrix.hpp>
#include <rumba/util.hpp>

//template class std::map<std::string, RUMBA::Factory*>;


//RUMBA::Manifold<double> permute_fill(const std::vector<double> &, bool transpose = false);

using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: cycle-vector -i infile -o outfile\n";
}

/********** If we had special args, here would be the place for them...
Argument myArgs [] = {
	Argument()
};
*********** But we don't...*******************************************/

int main(int argc,char** argv)
{
	std::string infile , outfile;
	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );

		double tmp; std::vector<double> v; std::ifstream fin(infile.c_str());
		while (fin>>tmp)
			v.push_back(tmp);
		manifoldMatrixWriteHack(makeMatrix(cycle_vector(v)), outfile.c_str() );

	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

}
