#include <iostream>
#include <vector>
#include <list>
#include <algorithm>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/util.hpp>


//RUMBA::Manifold<double> permute_fill(const std::vector<double> &, bool transpose = false);

using namespace RUMBA;

void usage()
{
	cerr << "Usage: matrix-transpose -i infile -o outfile\n";
}

/********** If we had special args, here would be the place for them...
Argument myArgs [] = {
	Argument()
};
*********** But we don't...*******************************************/

int main(int argc,char** argv)
{
	std::string infile , outfile;
	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		cout << "Invalid argument: " << s.error() << endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cout << "Duplicate argument: " << s.error() << endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cout << "Error: " << s.error() << endl;
	}
	catch (Exception& s)
	{
		cout << "Exception:" << s.error() << endl;
	}

	double tmp; vector<double> v; std::ifstream fin(infile.c_str());
	while (fin>>tmp)
		v.push_back(tmp);
	copy ( v.begin(),v.end(), ostream_iterator<double> ( cout, " " ) );
	cout << endl;
	manifoldMatrixWriteHack( makeMatrix( permute_fill(v) ) , outfile.c_str() );
	cout << "perm fill:" << endl;
	RUMBA::Manifold<double> M(permute_fill(v));
	copy ( M.begin(),M.end(), ostream_iterator<double> ( cout, " " ) );
	cout << endl;	
}
