#include "contrast.h"
#include "tokenizer.h"
#include <rumba/parse.h>

#include <rumba/matrixio.h>

// scan something in the form of 
// Factor-name: level1, level2, level3 ....  

using std::string;
using std::map;
using std::vector;
using std::make_pair;
using std::cerr;
using std::endl;

factor_token_handler::factor_token_handler
( 
const std::string& token, const std::vector<Factor>& factors,double weight
)
: token(token),factor_index(-1), levels(), factors(factors),weight(weight)
{
	RUMBA::Log log("factor_token_handler::factor_token_handler") ;
	log.logName()  
		<< token << " " << factor_index << " " << weight << "\n";
	std::string factor_name;
//	int factor_index = -1; // what factor is it ?
	std::string tmp;
	Treatment t;



	unsigned int i = 0;	
	for ( ; i < token.length() && token[i] != ':'; ++i )

		;

	if ( i == token.length() )
		throw RUMBA::Exception ( string("bad token ") + token );

	factor_name = token.substr(0,i);
	RUMBA::strip(factor_name);

	log.logName() << "factor name : " << factor_name << "\n";
	log.logName() << "no of factors: " << factors.size() << "\n";


	for ( unsigned int j = 0; j < factors.size(); ++j )
	{
		if ( factors[j].name == factor_name )
			factor_index = j;
		log.logName() << factors[j] << "\n";
	}

	if ( factor_index == -1 )
		throw RUMBA::Exception ( string("Factor not found :" ) + factor_name );

	log.logName() << "factor index : " << factor_index << "\n";
	log.logName () << "factor is : " << factors[factor_index] << "\n";


	tmp = token.substr(i+1,token.length());	
	
	std::istringstream strin(tmp);
//	vector<string> v;
	string lev;

	while ( getline(strin,lev,','))
	{
		RUMBA::strip(lev);
		levels.push_back(lev);
	}


/*	parse_set_helper(factor_index,s,v,factors); */
/*
	for ( i = -1; i < count_treatments(factors); ++i )
	{
		t = column_to_treatment(i,factors);
		if ( std::find ( v.begin(), v.end(), t.stringLevel( factor_index ) )
				!= v.end() )
			s.insert(t);
	}
*/
}

bool apply_op ( int op, bool lhs, bool rhs, bool invert_rhs )
{
	if ( op == TOKEN_OR )
		return lhs || (invert_rhs? !rhs : rhs);
	else if ( op == TOKEN_AND )
		return lhs && (invert_rhs? !rhs : rhs);
	else
		throw RUMBA::Exception ( "Unidentified operation in apply_op" );

}





void factor_token_handler::parse
(
 const std::map<Treatment,double>& lhs,
 std::map<Treatment,double>& s,
 int op,
 bool invert_rhs
)
{
	RUMBA::Log log("void factor_token_handler::parse");
	log.logName() << "entering" << "\n";
	log.logName() << "count_treatments" << count_treatments(factors) <<"\n";

	for ( int i = 0; i < levels.size(); ++i )
		log.logName() << levels[i] << "\n";

	Treatment t;
	/* is the treatment a member of that specified by the token ? */
	bool is_rhs; 

	/* is the treatment a member of that specified by the existing set ? */
	bool is_lhs;

	map<Treatment,double>::const_iterator it;

	for ( int i = -1; i < count_treatments(factors); ++i )
	{
		t = column_to_treatment(i,factors);
		log.logName() << "t is : " << t << "\n";
		log.logName() << "factor_index is : " << factor_index << "\n";

		log.logName() << "t.stringLevel(factor_index) is : " 
			<< t.stringLevel(factor_index) << "\n";
		if ( std::find ( 
			levels.begin(), levels.end(), t.stringLevel( factor_index ) 
			) 
			!= levels.end() 
		)
			is_rhs = true;
		else
			is_rhs = false;

		if ((it = lhs.find (t)) != lhs.end() )
			is_lhs = true;
		else 
			is_lhs = false;

		log.logName() << "op, is_lhs, is_rhs, invert_rhs : " 
			<< op << " " << is_lhs << " " << is_rhs << " " 
			<< invert_rhs << "\n";

		if (apply_op(op,is_lhs,is_rhs,invert_rhs))
		{
			log.logName() << "Inserting " << t << "\n";
			// if weight and it->second don't have same signs
			// query is ill-formed.

			// if ( it->second * weight < 0 ) 
			// 	complain_very_loudly();
			// else
			s.insert(std::make_pair(t,weight + it->second));
		}
		else log.logName() << "returned false\n";
	
	}
	log.logName() << "return\n";

}



void test_parse_set (const std::string & , std::vector<Factor>& )
{
	map<Treatment,double> s;
//	parse_set(s,command,factors);


//	std::copy ( s.begin(), s.end(), std::ostream_iterator<Treatment> ( std::cout, "\n" ));
}


RUMBA::ManifoldMatrix generateContrast ( 
		const std::map<Treatment,double>& s, 
		const std::vector<Factor>& factors
		)
{
	map<Treatment,double> isec;
	RUMBA::ManifoldMatrix M = RUMBA::makeMatrix(1,count_treatments(factors));
	std::fill(M.begin(),M.end(),0.0);
//	int sz = s.size();
	for ( map<Treatment,double>::const_iterator it = s.begin(); 
			it != s.end(); ++it )
		M= M+ it->second * getDesignMatrixRow(it->first, factors );

//	M = M * (1.0/sz);
	return M;
}


bool Parser::validate() const
{
	return true;
}

void Parser::process 
( const std::map<Treatment,double>& , bool invert, int op, const std::string& tok)
{
	RUMBA::Log log("Parser::process()");
	log.logName() << "\n";
	map<Treatment,double> s;
	factor_token_handler f ( tok, factors, weight );
	f.parse(current,s,op,invert);
	current = s;

}

Parser::Parser ( const std::vector<Factor>& factors, const std::string& s) 
: 	factors(factors), 
	parse_string(s), 
	invert(false), 
	op(TOKEN_OR), 
	weight(1) { 	tokenize(parse_string, tokens); init_token_types();  }

Parser::Parser
( 
 const std::vector<Factor>& factors, 
 std::vector<std::string> tokens,
 std::vector<int> token_types ,
 double weight 
 )
:
 	factors(factors), 
	parse_string(""), 
	invert(false), 
	op(TOKEN_OR), 
	weight(weight),
	token_types(token_types),
	tokens(tokens)
{ 	 }


void Parser::init_token_types()
{
	token_types.resize(tokens.size());

	for ( unsigned int i = 0; i < tokens.size(); ++i )
	{
		if (toUpper(tokens[i])=="AND")
			token_types[i]=TOKEN_AND;
		else if (toUpper(tokens[i])=="OR")
			token_types[i]=TOKEN_OR;
		else if (toUpper(tokens[i])=="NOT")
			token_types[i]=TOKEN_NOT;
		else if (toUpper(tokens[i])=="VERSUS")
			token_types[i]=TOKEN_VERSUS;
		else 
			token_types[i]=TOKEN_FACTOR;
	}
	if (! validate())
		std::cerr << "Ill formed query" << parse_string << endl;

}

double Parser::sum_weights(const std::map<Treatment,double>& s)
{
	double sum = 0;
	map<Treatment,double>::const_iterator it;
	for ( it = s.begin(); it != s.end(); ++it )
		sum += it->second;
	return sum;
}

void Parser::normalize_weights(std::map<Treatment,double>& s)
{
	double sum = sum_weights(s);
	map<Treatment,double>::iterator it;
	for ( it = s.begin(); it != s.end(); ++it )
		it->second/=sum;
}

void Parser::process_versus(int start)
{
	vector<string> tokens (tokens.begin()+start+1, tokens.end());
	vector<int> token_types (token_types.begin()+start+1, token_types.end());
	Parser* p = new Parser(factors,tokens,token_types,-1);

	const map<Treatment,double>& s = p->parse();
	// should check s is disjoint from current!
	
	std::map<Treatment,double>::const_iterator it;

	double sum = -1*sum_weights(s);
	normalize_weights(current);
	for ( it = s.begin(); it != s.end(); ++it )
	{
		if ( current.find(it->first)!=current.end() ) // query ill-formed
		{
			cerr << "Warning: query ill-formed";
		}
		else
		{
			current.insert ( make_pair(it->first, it->second/sum ));
		}
	}
	delete p;
}

const std::map<Treatment,double>& Parser::parse ()
{
//	std::vector<std::string> tokens;
//	std::vector<int> token_types;

	RUMBA::Log log("Parser::parse()");
	log.logName() << "Parse string is " << parse_string << "\n";


	for ( unsigned int i = 0; i < token_types.size(); ++i )
	{
		if ( token_types[i] == TOKEN_NOT )
			invert = true;
		else if ( token_types[i] == TOKEN_AND )
			op = TOKEN_AND;
		else if ( token_types[i] == TOKEN_OR )
			op = TOKEN_OR;
		else if ( token_types[i] == TOKEN_VERSUS )
		{
			process_versus(i);
			break;
		}
		else if ( token_types[i] == TOKEN_FACTOR )
			process ( current, invert, op, tokens[i] );

	}
	
	log.logName() << "Returning" << "\n";

	if ( current.empty() ) 
		log.logName() << "SET IS EMPTY\n";

	for ( map<Treatment,double>::iterator it = current.begin(); 
		it != current.end(); ++it )
		log.logName() << it->first << " " << it->second << "\n";

	
	return current;
}


